/*
 * Decompiled with CFR 0.152.
 */
package reptiles.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import reptiles.common.CommonProxyReptiles;
import reptiles.common.EntityChameleon;
import reptiles.common.EntityCroc;
import reptiles.common.EntityDesertTortoise;
import reptiles.common.EntityGator;
import reptiles.common.EntityGriseus;
import reptiles.common.EntityIguana;
import reptiles.common.EntityKomodo;
import reptiles.common.EntityLace;
import reptiles.common.EntityLargeCroc;
import reptiles.common.EntityLittleTurtle;
import reptiles.common.EntityPerentie;
import reptiles.common.EntitySavanna;
import reptiles.common.EntityTortoise;

@Mod(modid="ReptileMod", name="Reptile Mod", version="1.4.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Reptiles {
    public final Properties props = new Properties();
    @Mod.Instance
    public static Reptiles instance;
    private int komodoSpawnProb;
    private int griseusSpawnProb;
    private int laceSpawnProb;
    private int perentieSpawnProb;
    private int savannaSpawnProb;
    private int crocSpawnProb;
    private int largeCrocSpawnProb;
    private int desertTortoiseSpawnProb;
    private int littleTurtleSpawnProb;
    private int iguanaSpawnProb;
    private int tortoiseSpawnProb;
    private int gatorSpawnProb;
    private int chameleonSpawnProb;
    @SidedProxy(clientSide="reptiles.client.ClientProxyReptiles", serverSide="reptiles.common.CommonProxyReptiles")
    public static CommonProxyReptiles proxy;

    public String getVersion() {
        return "1.4.2";
    }

    @Mod.PreInit
    public void preLoad(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        try {
            this.init(configFile);
        }
        catch (IOException e) {
            System.err.println("Doh! Reptiles::init() crashed.");
        }
        proxy.registerRenderers();
        proxy.registerSounds();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.registerEntity(EntityKomodo.class, "Komodo", 25600, 10025880);
        this.registerEntity(EntitySavanna.class, "Savanna", 0x8B8989, 13485503);
        this.registerEntity(EntityGriseus.class, "Griseus", 13468991, 14596231);
        this.registerEntity(EntityPerentie.class, "Perentie", 0x363636, 0x7F7F7F);
        this.registerEntity(EntityLace.class, "Lace", 657930, 0xABABAB);
        this.registerEntity(EntityCroc.class, "Croc", 35584, 10669402);
        this.registerEntity(EntityDesertTortoise.class, "DesertTortoise", 9127187, 9129017);
        this.registerEntity(EntityLittleTurtle.class, "LittleTurtle", 16744228, 16747625);
        this.registerEntity(EntityLargeCroc.class, "LargeCroc", 9127187, 9132587);
        this.registerEntity(EntityIguana.class, "Iguana", 52480, 12648254);
        this.registerEntity(EntityTortoise.class, "Tortoise", 35653, 12648254);
        this.registerEntity(EntityGator.class, "Alligator", 35653, 12648254);
        this.registerEntity(EntityChameleon.class, "Chameleon", 0xB22222, 0x228B22);
        LanguageRegistry.instance().addStringLocalization("entity.Komodo.name", "Komodo");
        LanguageRegistry.instance().addStringLocalization("entity.Savanna.name", "Savanna");
        LanguageRegistry.instance().addStringLocalization("entity.Griseus.name", "Griseus");
        LanguageRegistry.instance().addStringLocalization("entity.Perentie.name", "Perentie");
        LanguageRegistry.instance().addStringLocalization("entity.Lace.name", "Lace");
        LanguageRegistry.instance().addStringLocalization("entity.Iguana.name", "Iguana");
        LanguageRegistry.instance().addStringLocalization("entity.Chameleon.name", "Chameleon");
        LanguageRegistry.instance().addStringLocalization("entity.Croc.name", "Crocodile");
        LanguageRegistry.instance().addStringLocalization("entity.DesertTortoise.name", "Desert Tortoise");
        LanguageRegistry.instance().addStringLocalization("entity.LittleTurtle.name", "Little Turtle");
        LanguageRegistry.instance().addStringLocalization("entity.LargeCroc.name", "Large Crocodile");
        LanguageRegistry.instance().addStringLocalization("entity.Alligator.name", "Alligator");
        LanguageRegistry.instance().addStringLocalization("entity.Tortoise.name", "Tortoise");
        xz[] monitorBiomes = new xz[]{xz.r, xz.f, xz.t, xz.w, xz.x, xz.c, xz.v};
        xz[] tortoiseBiomes = new xz[]{xz.d, xz.s, xz.c};
        xz[] turtleBiomes = new xz[]{xz.r, xz.f, xz.t, xz.w, xz.x, xz.p, xz.q, xz.c, xz.h};
        xz[] lizardBiomes = new xz[]{xz.f, xz.t, xz.w, xz.x};
        xz[] crocBiomes = new xz[]{xz.r, xz.w, xz.p, xz.q, xz.h};
        this.addSpawn(EntityKomodo.class, this.komodoSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntitySavanna.class, this.savannaSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityGriseus.class, this.griseusSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityPerentie.class, this.perentieSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityLace.class, this.laceSpawnProb, 1, 4, monitorBiomes);
        this.addSpawn(EntityCroc.class, this.crocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityLargeCroc.class, this.largeCrocSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityGator.class, this.gatorSpawnProb, 1, 2, crocBiomes);
        this.addSpawn(EntityDesertTortoise.class, this.desertTortoiseSpawnProb, 1, 4, tortoiseBiomes);
        this.addSpawn(EntityLittleTurtle.class, this.littleTurtleSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityTortoise.class, this.tortoiseSpawnProb, 1, 4, turtleBiomes);
        this.addSpawn(EntityIguana.class, this.iguanaSpawnProb, 1, 4, lizardBiomes);
        this.addSpawn(EntityChameleon.class, this.chameleonSpawnProb, 1, 4, lizardBiomes);
    }

    public void registerEntity(Class entityClass, String entityName, int bkEggColor, int fgEggColor) {
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)entityName, (int)id, (int)bkEggColor, (int)fgEggColor);
    }

    public void addSpawn(Class entityClass, int spawnProb, int min, int max, xz[] biomes) {
        if (spawnProb > 0) {
            EntityRegistry.addSpawn((Class)entityClass, (int)spawnProb, (int)min, (int)max, (lo)lo.b, (xz[])biomes);
        }
    }

    public void loadConfig(File cfgFile) throws IOException {
        try {
            if (!cfgFile.exists() && !cfgFile.createNewFile()) {
                return;
            }
            if (cfgFile.canRead()) {
                FileInputStream fileinputstream = new FileInputStream(cfgFile);
                this.props.load(fileinputstream);
                fileinputstream.close();
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void saveConfig(File cfgFile) throws IOException {
        String comments = " Reptile Mod Config\n\n Michael Sheppard (crackedEgg)\n";
        try {
            if (!cfgFile.exists() && !cfgFile.createNewFile()) {
                return;
            }
            if (cfgFile.canWrite()) {
                FileOutputStream fileoutputstream = new FileOutputStream(cfgFile);
                this.props.store(fileoutputstream, comments);
                fileoutputstream.close();
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void init(File cfgFile) throws IOException {
        this.initDefaults();
        try {
            this.loadConfig(cfgFile);
            if (this.props.containsKey("komodoSpawnProb")) {
                this.komodoSpawnProb = Integer.parseInt(this.props.getProperty("komodoSpawnProb"));
            }
            if (this.props.containsKey("griseusSpawnProb")) {
                this.griseusSpawnProb = Integer.parseInt(this.props.getProperty("griseusSpawnProb"));
            }
            if (this.props.containsKey("laceSpawnProb")) {
                this.laceSpawnProb = Integer.parseInt(this.props.getProperty("laceSpawnProb"));
            }
            if (this.props.containsKey("perentieSpawnProb")) {
                this.perentieSpawnProb = Integer.parseInt(this.props.getProperty("perentieSpawnProb"));
            }
            if (this.props.containsKey("savannaSpawnProb")) {
                this.savannaSpawnProb = Integer.parseInt(this.props.getProperty("savannaSpawnProb"));
            }
            if (this.props.containsKey("crocSpawnProb")) {
                this.crocSpawnProb = Integer.parseInt(this.props.getProperty("crocSpawnProb"));
            }
            if (this.props.containsKey("largeCrocSpawnProb")) {
                this.largeCrocSpawnProb = Integer.parseInt(this.props.getProperty("largeCrocSpawnProb"));
            }
            if (this.props.containsKey("desertTortoiseSpawnProb")) {
                this.desertTortoiseSpawnProb = Integer.parseInt(this.props.getProperty("desertTortoiseSpawnProb"));
            }
            if (this.props.containsKey("littleTurtleSpawnProb")) {
                this.littleTurtleSpawnProb = Integer.parseInt(this.props.getProperty("littleTurtleSpawnProb"));
            }
            if (this.props.containsKey("iguanaSpawnProb")) {
                this.iguanaSpawnProb = Integer.parseInt(this.props.getProperty("iguanaSpawnProb"));
            }
            if (this.props.containsKey("tortoiseSpawnProb")) {
                this.tortoiseSpawnProb = Integer.parseInt(this.props.getProperty("tortoiseSpawnProb"));
            }
            if (this.props.containsKey("gatorSpawnProb")) {
                this.gatorSpawnProb = Integer.parseInt(this.props.getProperty("gatorSpawnProb"));
            }
            if (this.props.containsKey("chameleonSpawnProb")) {
                this.chameleonSpawnProb = Integer.parseInt(this.props.getProperty("chameleonSpawnProb"));
            }
            this.props.setProperty("komodoSpawnProb", Integer.toString(this.komodoSpawnProb));
            this.props.setProperty("griseusSpawnProb", Integer.toString(this.griseusSpawnProb));
            this.props.setProperty("laceSpawnProb", Integer.toString(this.laceSpawnProb));
            this.props.setProperty("perentieSpawnProb", Integer.toString(this.perentieSpawnProb));
            this.props.setProperty("savannaSpawnProb", Integer.toString(this.savannaSpawnProb));
            this.props.setProperty("crocSpawnProb", Integer.toString(this.crocSpawnProb));
            this.props.setProperty("largeCrocSpawnProb", Integer.toString(this.largeCrocSpawnProb));
            this.props.setProperty("desertTortoiseSpawnProb", Integer.toString(this.desertTortoiseSpawnProb));
            this.props.setProperty("littleTurtleSpawnProb", Integer.toString(this.littleTurtleSpawnProb));
            this.props.setProperty("iguanaSpawnProb", Integer.toString(this.iguanaSpawnProb));
            this.props.setProperty("tortoiseSpawnProb", Integer.toString(this.tortoiseSpawnProb));
            this.props.setProperty("gatorSpawnProb", Integer.toString(this.gatorSpawnProb));
            this.props.setProperty("chameleonSpawnProb", Integer.toString(this.chameleonSpawnProb));
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.saveConfig(cfgFile);
        }
    }

    protected void initDefaults() {
        this.komodoSpawnProb = 10;
        this.griseusSpawnProb = 12;
        this.laceSpawnProb = 12;
        this.perentieSpawnProb = 12;
        this.savannaSpawnProb = 12;
        this.crocSpawnProb = 5;
        this.largeCrocSpawnProb = 4;
        this.desertTortoiseSpawnProb = 12;
        this.littleTurtleSpawnProb = 10;
        this.iguanaSpawnProb = 12;
        this.tortoiseSpawnProb = 12;
        this.gatorSpawnProb = 5;
        this.chameleonSpawnProb = 12;
    }
}

