/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.configuration;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.Biomes;
import biomesoplenty.configuration.configfile.BOPConfigurationIDs;
import biomesoplenty.entities.EntityGlob;
import biomesoplenty.entities.EntityJungleSpider;
import biomesoplenty.entities.EntityPhantom;
import biomesoplenty.entities.EntityRosester;
import biomesoplenty.entities.projectiles.EntityDart;
import biomesoplenty.entities.projectiles.EntityMudball;
import biomesoplenty.entities.projectiles.EntityPoisonDart;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPEntities {
    public static int eggIdCounter = 300;

    public static int getUniqueEntityEggId() {
        while (EntityList.func_75617_a((int)(++eggIdCounter)) != null) {
        }
        return eggIdCounter;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int primaryColor, int secondaryColor) {
        int id = BOPEntities.getUniqueEntityEggId();
        EntityList.field_75623_d.put(id, entity);
        EntityList.field_75627_a.put(id, new EntityEggInfo(id, primaryColor, secondaryColor));
    }

    public static void init() {
        EntityRegistry.registerModEntity(EntityMudball.class, (String)"MudBall", (int)BOPConfigurationIDs.entityMudballID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityDart.class, (String)"Dart", (int)BOPConfigurationIDs.entityDartID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPoisonDart.class, (String)"PoisonDart", (int)BOPConfigurationIDs.entityPoisonDartID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityJungleSpider.class, (String)"JungleSpider", (int)BOPConfigurationIDs.jungleSpiderID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityRosester.class, (String)"Rosester", (int)BOPConfigurationIDs.rosesterID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityGlob.class, (String)"Glob", (int)BOPConfigurationIDs.globID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPhantom.class, (String)"Phantom", (int)BOPConfigurationIDs.phantomID, (Object)BiomesOPlenty.instance, (int)80, (int)3, (boolean)true);
        BOPEntities.registerEntityEgg(EntityJungleSpider.class, 5147192, 11013646);
        BOPEntities.registerEntityEgg(EntityRosester.class, 14831439, 16756224);
        BOPEntities.registerEntityEgg(EntityGlob.class, 6836276, 8414787);
        BOPEntities.registerEntityEgg(EntityPhantom.class, 4472140, 2499368);
        if (Biomes.bambooForest.isPresent() && Biomes.jungleNew.isPresent() && Biomes.tropicalRainforest.isPresent() && Biomes.oasis.isPresent() && Biomes.tropics.isPresent()) {
            EntityRegistry.addSpawn(EntityJungleSpider.class, (int)8, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.bambooForest.get(), (BiomeGenBase)Biomes.jungleNew.get(), (BiomeGenBase)Biomes.tropicalRainforest.get(), (BiomeGenBase)Biomes.oasis.get(), (BiomeGenBase)Biomes.tropics.get()});
        }
        if (Biomes.bog.isPresent() && Biomes.deadSwamp.isPresent() && Biomes.fen.isPresent() && Biomes.moor.isPresent() && Biomes.quagmire.isPresent() && Biomes.sludgepit.isPresent() && Biomes.swamplandNew.isPresent()) {
            EntityRegistry.addSpawn(EntityGlob.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.bog.get(), (BiomeGenBase)Biomes.deadSwamp.get(), (BiomeGenBase)Biomes.fen.get(), (BiomeGenBase)Biomes.moor.get(), (BiomeGenBase)Biomes.quagmire.get(), (BiomeGenBase)Biomes.sludgepit.get(), (BiomeGenBase)Biomes.swamplandNew.get()});
        }
        if (Biomes.garden.isPresent()) {
            EntityRegistry.addSpawn(EntityRosester.class, (int)10, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.garden.get()});
        }
        if (Biomes.netherBone.isPresent() && Biomes.netherDesert.isPresent()) {
            EntityRegistry.addSpawn(EntityPhantom.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{(BiomeGenBase)Biomes.netherBone.get(), (BiomeGenBase)Biomes.netherDesert.get()});
        }
        LanguageRegistry.instance().addStringLocalization("entity.BiomesOPlenty.JungleSpider.name", "en_US", "Jungle Spider");
        LanguageRegistry.instance().addStringLocalization("entity.BiomesOPlenty.Rosester.name", "en_US", "Rosester");
        LanguageRegistry.instance().addStringLocalization("entity.BiomesOPlenty.Glob.name", "en_US", "Glob");
        LanguageRegistry.instance().addStringLocalization("entity.BiomesOPlenty.Phantom.name", "en_US", "Phantom");
    }
}

