/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.fluids;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.Fluids;
import biomesoplenty.configuration.configfile.BOPConfigurationMisc;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidSpringWater
extends BlockFluidClassic {
    public static Icon springWaterStillIcon;
    public static Icon springWaterFlowingIcon;

    public BlockFluidSpringWater(int id, Fluid fluid, Material material) {
        super(id, fluid, material);
        this.stack = new FluidStack(fluid, 1000);
        for (int i = 8; i < 11; ++i) {
            this.displacementIds.put(i, false);
        }
        this.displacementIds.put(((Block)Fluids.liquidPoison.get()).field_71990_ca, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.func_71862_a(par1World, par2, par3, par4, par5Random);
        if (par5Random.nextInt(1) == 0) {
            BiomesOPlenty.proxy.spawnParticle("steam", (float)par2 + par5Random.nextFloat(), (float)par3 + 1.0f, (float)par4 + par5Random.nextFloat());
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0) {
            return true;
        }
        if (bId == this.field_71990_ca) {
            return false;
        }
        if (this.displacementIds.containsKey(bId)) {
            return (Boolean)this.displacementIds.get(bId);
        }
        Material material = Block.field_71973_m[bId].field_72018_cp;
        return !material.func_76230_c() && material != Material.field_76244_g && material != Material.field_76256_h && material != Material.field_76237_B;
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K && BOPConfigurationMisc.hotSpringsRegeneration && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_82165_m(Potion.field_76428_l.field_76415_H)) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 50));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        springWaterStillIcon = iconRegister.func_94245_a("biomesoplenty:spring_water_still");
        springWaterFlowingIcon = iconRegister.func_94245_a("biomesoplenty:spring_water_flowing");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return par1 != 0 && par1 != 1 ? springWaterFlowingIcon : springWaterStillIcon;
    }
}

