/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.handlers;

import biomesoplenty.api.Blocks;
import biomesoplenty.api.Items;
import biomesoplenty.configuration.configfile.BOPConfigurationIDs;
import biomesoplenty.entities.ai.EntityAITemptArmour;
import biomesoplenty.helpers.AchievementHelper;
import biomesoplenty.helpers.TeleporterPromised;
import biomesoplenty.world.WorldTypeBOP;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class EntityEventHandler {
    @ForgeSubscribe
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (entity instanceof EntityChicken) {
            ((EntityLiving)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptArmour((EntityCreature)entity, 0.25f, ((Item)Items.flowerBand.get()).field_77779_bT, 0, false));
        }
        if (entity instanceof EntitySheep) {
            ((EntityLiving)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptArmour((EntityCreature)entity, 0.25f, ((Item)Items.flowerBand.get()).field_77779_bT, 1, false));
        }
        if (entity instanceof EntityPig) {
            ((EntityLiving)entity).field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITemptArmour((EntityCreature)entity, 0.25f, ((Item)Items.flowerBand.get()).field_77779_bT, 2, false));
        }
        if (entity instanceof EntityCow) {
            ((EntityLiving)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptArmour((EntityCreature)entity, 0.25f, ((Item)Items.flowerBand.get()).field_77779_bT, 3, false));
        }
    }

    @ForgeSubscribe
    public void fallingFromPromisedLand(LivingHurtEvent event) {
        if (event.source == DamageSource.field_76380_i && event.entityLiving.field_71093_bK == BOPConfigurationIDs.promisedLandDimID) {
            event.setCanceled(true);
            if (!event.entityLiving.field_70170_p.field_72995_K && !event.entityLiving.field_70128_L && event.entityLiving instanceof EntityPlayerMP) {
                EntityPlayerMP thePlayer = (EntityPlayerMP)event.entityLiving;
                thePlayer.field_71133_b.func_71203_ab().transferPlayerToDimension(thePlayer, 0, (Teleporter)new TeleporterPromised(thePlayer.field_71133_b.func_71218_a(0), true));
            }
        }
    }

    @ForgeSubscribe
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.world.field_73011_w.field_76577_b instanceof WorldTypeBOP && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            player.func_71064_a((StatBase)AchievementHelper.achBOP, 1);
        }
    }

    @ForgeSubscribe
    public void entityInteract(EntityInteractEvent event) {
        ItemStack itemstack = event.entityPlayer.func_71045_bC();
        Entity entity = event.target;
        EntityPlayer player = event.entityPlayer;
        if (itemstack != null) {
            int itemDamage = itemstack.func_77960_j();
            if (itemstack.field_77993_c == ((Item)Items.soulManipulator.get()).field_77779_bT && itemstack.func_77960_j() == 2) {
                if (entity instanceof EntityEnderman) {
                    EntityEnderman entityenderman = (EntityEnderman)entity;
                    if (entityenderman.field_70170_p.field_73012_v.nextInt(2) == 0) {
                        entityenderman.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                    }
                    entityenderman.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 0.0f);
                    if (entityenderman.field_70170_p.field_73012_v.nextInt(6) == 0) {
                        EntityVillager entityvillager = new EntityVillager(entityenderman.field_70170_p);
                        entityvillager.func_70012_b(entityenderman.field_70165_t, entityenderman.field_70163_u, entityenderman.field_70161_v, MathHelper.func_76142_g((float)(entityenderman.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        entityvillager.field_70759_as = entityvillager.field_70177_z;
                        entityvillager.field_70761_aq = entityvillager.field_70177_z;
                        if (!entityenderman.field_70170_p.field_72995_K) {
                            entityenderman.field_70170_p.func_72838_d((Entity)entityvillager);
                            FMLClientHandler.instance().getClient().field_71416_A.func_77364_b("mob.endermen.death", (float)entityvillager.field_70165_t + 0.5f, (float)entityvillager.field_70163_u + 0.5f, (float)entityvillager.field_70161_v + 0.5f, 5.0f, -8.0f);
                            entityenderman.func_70106_y();
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_77964_b(0);
                        }
                        event.setResult(Event.Result.ALLOW);
                        entityvillager.func_70642_aH();
                    }
                }
            } else if (itemstack.field_77993_c == ((Item)Items.miscItems.get()).field_77779_bT && (itemDamage == 5 || itemDamage == 6 || itemDamage == 7 || itemDamage == 8 || itemDamage == 9)) {
                int dyeMeta = this.convertToDyeMeta(itemDamage);
                int i = BlockColored.func_72238_e_((int)dyeMeta);
                if (entity instanceof EntityWolf) {
                    EntityWolf entitywolf = (EntityWolf)entity;
                    if (i != entitywolf.func_82186_bH()) {
                        entitywolf.func_82185_r(i);
                        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                        event.setResult(Event.Result.ALLOW);
                    }
                } else if (entity instanceof EntitySheep) {
                    EntitySheep entitysheep = (EntitySheep)entity;
                    if (!entitysheep.func_70892_o() && entitysheep.func_70896_n() != i) {
                        entitysheep.func_70891_b(i);
                        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                    }
                    event.setResult(Event.Result.ALLOW);
                }
            }
        }
    }

    private int convertToDyeMeta(int meta) {
        switch (meta) {
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    @ForgeSubscribe
    public void lightningStrike(LivingHurtEvent event) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72332_a().func_72299_a(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, event.entity.field_70165_t + 1.0, event.entity.field_70163_u + 1.0, event.entity.field_70161_v + 1.0).func_72314_b(5.0, 5.0, 5.0);
        if (!event.entity.field_70170_p.func_72872_a(EntityLightningBolt.class, axisalignedbb).isEmpty()) {
            // empty if block
        }
        if (!event.entity.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb).isEmpty()) {
            // empty if block
        }
        if (this.isBlockInBB(event.entity.field_70170_p, axisalignedbb, ((Block)Blocks.glass.get()).field_71990_ca, 2) || this.isBlockInBB(event.entity.field_70170_p, axisalignedbb, ((Block)Blocks.glass.get()).field_71990_ca, 3)) {
            event.setCanceled(true);
        }
    }

    public boolean isBlockInBB(World world, AxisAlignedBB par1AxisAlignedBB, int blockID, int blockMeta) {
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.field_71973_m[world.func_72798_a(k1, l1, i2)];
                    if (block == null || block.field_71990_ca != blockID || world.func_72805_g(k1, l1, i2) != blockMeta) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

