/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.integration;

import biomesoplenty.api.Biomes;
import biomesoplenty.api.BlockReferences;
import biomesoplenty.api.Blocks;
import biomesoplenty.api.Entities;
import biomesoplenty.api.Items;
import biomesoplenty.integration.minefactoryreloaded.Fertilizable;
import biomesoplenty.integration.minefactoryreloaded.FruitLeaves;
import biomesoplenty.integration.minefactoryreloaded.Grindable;
import biomesoplenty.integration.minefactoryreloaded.Harvestable;
import biomesoplenty.integration.minefactoryreloaded.Plantable;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.MobDrop;

public class MFRIntegration {
    protected static void init() {
        MFRIntegration.registerRubberTreeBiomes();
        MFRIntegration.registerFarmables();
        MFRIntegration.registerSludgeDrops();
        MFRIntegration.registerGrindables();
    }

    private static void registerRubberTreeBiomes() {
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.bayou.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.birchForest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.bog.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.borealForest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.deciduousForest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.forestNew.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.grove.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.jungleNew.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.lushSwamp.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.mapleWoods.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.rainforest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.seasonalForest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.shield.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.swamplandNew.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.temperateRainforest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.thicket.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.tropicalRainforest.get()).field_76791_y);
        FarmingRegistry.registerRubberTreeBiome((String)((BiomeGenBase)Biomes.woodland.get()).field_76791_y);
    }

    private static void registerFarmables() {
        Optional[] bopLeaves = new Optional[]{Blocks.leaves1, Blocks.leaves2, Blocks.leavesColorized, Blocks.treeMoss, Blocks.willow, Blocks.ivy, Blocks.moss};
        Optional[] bopFruitLeaves = new Optional[]{Blocks.leavesFruit};
        Optional[] bopLogs = new Optional[]{Blocks.logs1, Blocks.logs2, Blocks.logs3, Blocks.logs4, Blocks.bamboo};
        Optional[] bopMiscStandardHarvestables = new Optional[]{Blocks.flowers, Blocks.plants, Blocks.foliage, Blocks.mushrooms};
        Optional[] bopSaplings = new Optional[]{Blocks.saplings, Blocks.colorizedSaplings};
        for (Optional leaves : bopLeaves) {
            FarmingRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)leaves.get()).field_71990_ca, HarvestType.TreeLeaf));
        }
        for (Optional log : bopLogs) {
            FarmingRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)log.get()).field_71990_ca, HarvestType.Tree));
        }
        for (Optional harvestable : bopMiscStandardHarvestables) {
            FarmingRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)harvestable.get()).field_71990_ca, HarvestType.Normal));
        }
        for (Optional sapling : bopSaplings) {
            FarmingRegistry.registerPlantable((IFactoryPlantable)new Plantable(((Block)sapling.get()).field_71990_ca, ((Block)sapling.get()).field_71990_ca));
            FarmingRegistry.registerFertilizable((IFactoryFertilizable)new Fertilizable(((Block)sapling.get()).field_71990_ca));
        }
        for (Optional leaves : bopFruitLeaves) {
            FarmingRegistry.registerHarvestable((IFactoryHarvestable)new Harvestable(((Block)leaves.get()).field_71990_ca, HarvestType.TreeLeaf));
            FarmingRegistry.registerFruit((IFactoryFruit)new FruitLeaves(((Block)leaves.get()).field_71990_ca));
        }
    }

    private static void registerSludgeDrops() {
        FarmingRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("driedDirt"));
        FarmingRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("hardSand"));
        FarmingRegistry.registerSludgeDrop((int)15, (ItemStack)BlockReferences.getBlockItemStack("hardDirt"));
        FarmingRegistry.registerSludgeDrop((int)15, (ItemStack)new ItemStack((Item)Items.miscItems.get(), 4, 1));
        FarmingRegistry.registerSludgeDrop((int)25, (ItemStack)new ItemStack((Item)Items.mudball.get(), 4));
    }

    private static void registerGrindables() {
        FarmingRegistry.registerGrindable((IFactoryGrindable)new Grindable(Entities.JungleSpider, new MobDrop[]{new MobDrop(3, new ItemStack(Item.field_77683_K)), new MobDrop(1, new ItemStack(Item.field_77728_bu))}));
        FarmingRegistry.registerGrindable((IFactoryGrindable)new Grindable(Entities.Rosester, new MobDrop[]{new MobDrop(1, new ItemStack(Item.field_77735_bk)), new MobDrop(1, new ItemStack(Item.field_77756_aW, 1, 1))}));
        FarmingRegistry.registerGrindable((IFactoryGrindable)new Grindable(Entities.Glob, new MobDrop[]{new MobDrop(1, new ItemStack(Item.field_77761_aM)), new MobDrop(4, new ItemStack((Item)Items.mudball.get()))}));
    }
}

