/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.world;

import biomesoplenty.api.Biomes;
import biomesoplenty.configuration.configfile.BOPConfigurationIDs;
import biomesoplenty.configuration.configfile.BOPConfigurationTerrainGen;
import biomesoplenty.world.map.MapGenCavesBOP;
import biomesoplenty.world.map.MapGenRavineBOP;
import biomesoplenty.world.noise.NoiseOctaves;
import biomesoplenty.worldgen.structure.BOPMapGenScatteredFeature;
import biomesoplenty.worldgen.structure.BOPMapGenVillage;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderBOP
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCavesBOP();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private BOPMapGenVillage villageGenerator = new BOPMapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private BOPMapGenScatteredFeature scatteredFeatureGenerator = new BOPMapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavineBOP();
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    private NoiseOctaves beachnoise;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    float[] parabolicField;
    int[][] field_73219_j = new int[32][32];

    public ChunkProviderBOP(World par1World, long par2, boolean par4) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (BOPMapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (BOPMapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.beachnoise = new NoiseOctaves(this.rand, 4);
        NoiseGeneratorOctaves[] noiseGens = new NoiseGeneratorOctaves[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)par1World, (Random)this.rand, (NoiseGeneratorOctaves[])noiseGens);
        this.noiseGen1 = noiseGens[0];
        this.noiseGen2 = noiseGens[1];
        this.noiseGen3 = noiseGens[2];
        this.noiseGen4 = noiseGens[3];
        this.noiseGen5 = noiseGens[4];
        this.noiseGen6 = noiseGens[5];
        this.mobSpawnerNoise = noiseGens[6];
    }

    public void generateTerrain(int par1, int par2, byte[] par3ArrayOfByte) {
        int b0 = 4;
        int b1 = 32;
        int b2 = 63;
        int k = b0 + 1;
        int b3 = 33;
        int l = b0 + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, k + 5, l + 5);
        this.noiseArray = this.initializeNoiseField(this.noiseArray, par1 * b0, 0, par2 * b0, k, b3, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < b1; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseArray[((i1 + 0) * l + j1 + 0) * b3 + k1 + 0];
                    double d2 = this.noiseArray[((i1 + 0) * l + j1 + 1) * b3 + k1 + 0];
                    double d3 = this.noiseArray[((i1 + 1) * l + j1 + 0) * b3 + k1 + 0];
                    double d4 = this.noiseArray[((i1 + 1) * l + j1 + 1) * b3 + k1 + 0];
                    double d5 = (this.noiseArray[((i1 + 0) * l + j1 + 0) * b3 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseArray[((i1 + 0) * l + j1 + 1) * b3 + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseArray[((i1 + 1) * l + j1 + 0) * b3 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseArray[((i1 + 1) * l + j1 + 1) * b3 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 12 | 0 + j1 * 4 << 8 | k1 * 8 + l1;
                            int short1 = 256;
                            j2 -= short1;
                            double d14 = 0.25;
                            double d15 = (d11 - d10) * d14;
                            double d16 = d10 - d15;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                double d;
                                d16 += d15;
                                par3ArrayOfByte[j2 += short1] = d > 0.0 ? (byte)Block.field_71981_t.field_71990_ca : (k1 * 8 + l1 < b2 ? (byte)Block.field_71943_B.field_71990_ca : (byte)0);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, byte[] par3ArrayOfByte, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, par1, par2, par3ArrayOfByte, par4ArrayOfBiomeGenBase);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int b0 = 63;
        double d0 = 0.03125;
        this.sandNoise = this.beachnoise.generateNoiseOctaves(this.sandNoise, par1 * 16, par2 * 16, 0.0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.beachnoise.generateNoiseOctaves(this.gravelNoise, par1 * 16, 109.0134, par2 * 16, 16, 1, 16, d0, 1.0, d0);
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = par4ArrayOfBiomeGenBase[l + k * 16];
                float f = biomegenbase.func_76743_j();
                int i1 = (int)(this.stoneNoise[k + l * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                boolean sandbeach = this.sandNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean gravelbeach = this.gravelNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int j1 = -1;
                byte b1 = biomegenbase.field_76752_A;
                byte b2 = biomegenbase.field_76753_B;
                for (int k1 = 255; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 256 + k1;
                    if (k1 <= 0 + this.rand.nextInt(5)) {
                        par3ArrayOfByte[l1] = (byte)Block.field_71986_z.field_71990_ca;
                        continue;
                    }
                    byte b3 = par3ArrayOfByte[l1];
                    if (b3 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (b3 != Block.field_71981_t.field_71990_ca) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            if (BOPConfigurationTerrainGen.exposedStone) {
                                b1 = 0;
                                b2 = (byte)Block.field_71981_t.field_71990_ca;
                            } else {
                                b1 = biomegenbase.field_76752_A;
                                b2 = biomegenbase.field_76753_B;
                            }
                        } else if (k1 >= b0 - 4 && k1 <= b0 + 1) {
                            if (biomegenbase.field_76756_M == BOPConfigurationIDs.originValleyID) {
                                if (gravelbeach) {
                                    b1 = 0;
                                    b2 = (byte)Block.field_71940_F.field_71990_ca;
                                } else if (sandbeach) {
                                    b1 = (byte)Block.field_71939_E.field_71990_ca;
                                    b2 = (byte)Block.field_71939_E.field_71990_ca;
                                } else {
                                    b1 = biomegenbase.field_76752_A;
                                    b2 = biomegenbase.field_76753_B;
                                }
                            } else {
                                b1 = biomegenbase.field_76752_A;
                                b2 = biomegenbase.field_76753_B;
                            }
                        }
                        if (k1 < b0 && b1 == 0) {
                            b1 = f < 0.15f ? (byte)Block.field_72036_aT.field_71990_ca : (byte)Block.field_71943_B.field_71990_ca;
                        }
                        j1 = i1;
                        if (k1 >= b0 - 1) {
                            par3ArrayOfByte[l1] = b1;
                            continue;
                        }
                        par3ArrayOfByte[l1] = b2;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    par3ArrayOfByte[l1] = b2;
                    if (--j1 != 0 || b2 != Block.field_71939_E.field_71990_ca) continue;
                    j1 = this.rand.nextInt(4);
                    b2 = (byte)Block.field_71957_Q.field_71990_ca;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        int k;
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] abyte = new byte[415030];
        this.generateTerrain(par1, par2, abyte);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, abyte, this.biomesForGeneration);
        this.caveGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, abyte);
        this.ravineGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, abyte);
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, abyte);
            this.villageGenerator.func_75036_a(this, this.worldObj, par1, par2, abyte);
            this.strongholdGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, abyte);
            this.scatteredFeatureGenerator.func_75036_a(this, this.worldObj, par1, par2, abyte);
        }
        Chunk chunk = new Chunk(this.worldObj, par1, par2);
        ExtendedBlockStorage[] aextendedblockstorage = chunk.func_76587_i();
        byte[] abyte1 = chunk.func_76605_m();
        for (k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        for (k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                for (int i1 = 0; i1 < 256; ++i1) {
                    byte byte0 = abyte[k << 12 | l << 8 | i1];
                    if (byte0 == 0) continue;
                    int j1 = i1 >> 4;
                    if (aextendedblockstorage[j1] == null) {
                        aextendedblockstorage[j1] = new ExtendedBlockStorage(j1 << 4, true);
                    }
                    aextendedblockstorage[j1].func_76655_a(k, i1 & 0xF, l, byte0 & 0xFF);
                }
            }
        }
        chunk.func_76603_b();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, par1ArrayOfDouble, par2, par3, par4, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.parabolicField[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 160.0, d0 / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        boolean flag = false;
        boolean flag1 = false;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < par5; ++k2) {
            for (int l2 = 0; l2 < par7; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (par5 + 5)];
                for (int i3 = -b0; i3 <= b0; ++i3) {
                    for (int j3 = -b0; j3 <= b0; ++j3) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (par5 + 5)];
                        float f4 = this.parabolicField[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.field_76748_D + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.field_76749_E * f4;
                        f2 = (float)((double)f2 + ((double)biomegenbase1.field_76748_D - 2.0) * (double)f4);
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < par6; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > par6 - 4) {
                        double d11 = (float)(k3 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[i2] = d6;
                    ++i2;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int i2;
        int l1;
        int k1;
        BlockSand.field_72192_a = true;
        int k = par2 * 16;
        int l = par3 * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * i1 + (long)par3 * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, par2, par3, flag));
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            flag = this.villageGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
        }
        if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && biomegenbase != Biomes.desertNew.get() && biomegenbase != Biomes.glacier.get() && biomegenbase != Biomes.volcano.get() && biomegenbase != Biomes.scrubland.get() && biomegenbase != Biomes.dunes.get() && biomegenbase != Biomes.arctic.get() && biomegenbase != Biomes.pasture.get() && biomegenbase != Biomes.silkglades.get() && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = k + this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(128);
            i2 = l + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.field_71943_B.field_71990_ca).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !flag && this.rand.nextInt(8) == 0) {
            k1 = k + this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            i2 = l + this.rand.nextInt(16) + 8;
            if (l1 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Block.field_71938_D.field_71990_ca).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (k1 = 0; doGen && k1 < 8; ++k1) {
            int j2;
            l1 = k + this.rand.nextInt(16) + 8;
            if (!new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, l1, i2 = this.rand.nextInt(128), j2 = l + this.rand.nextInt(16) + 8)) continue;
        }
        biomegenbase.func_76728_a(this.worldObj, this.rand, k, l);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        k += 8;
        l += 8;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = this.worldObj.func_72874_g(k + k1, l + l1);
                if (this.worldObj.func_72884_u(k1 + k, i2 - 1, l1 + l)) {
                    this.worldObj.func_72832_d(k1 + k, i2 - 1, l1 + l, Block.field_72036_aT.field_71990_ca, 0, 2);
                }
                if (!this.worldObj.func_72858_w(k1 + k, i2, l1 + l)) continue;
                this.worldObj.func_72832_d(k1 + k, i2, l1 + l, Block.field_72037_aS.field_71990_ca, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, par2, par3, flag));
        BlockSand.field_72192_a = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : (biomegenbase == BiomeGenBase.field_76780_h && par1EnumCreatureType == EnumCreatureType.monster && this.scatteredFeatureGenerator.func_75048_a(par2, par3, par4) ? this.scatteredFeatureGenerator.getScatteredFeatureSpawnList() : biomegenbase.func_76747_a(par1EnumCreatureType));
    }

    public ChunkPosition func_73150_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_75050_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        if (this.mapFeaturesEnabled) {
            this.mineshaftGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, (byte[])null);
            this.villageGenerator.func_75036_a(this, this.worldObj, par1, par2, null);
            this.strongholdGenerator.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, (byte[])null);
            this.scatteredFeatureGenerator.func_75036_a(this, this.worldObj, par1, par2, null);
        }
    }

    public void func_104112_b() {
    }
}

