/*
 * Decompiled with CFR 0.152.
 */
package org.newthead.christmas;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraftforge.common.Configuration;
import org.newthead.christmas.ModSetup;
import org.newthead.christmas.PresentRecipe;
import org.newthead.christmas.blocks.BlockChristmasLight;
import org.newthead.christmas.blocks.BlockChristmasPresent;
import org.newthead.christmas.blocks.BlockChristmasStar;
import org.newthead.christmas.blocks.BlockChristmasStocking;
import org.newthead.christmas.blocks.BlockFruitcake;
import org.newthead.christmas.blocks.BlockOrnament;
import org.newthead.christmas.blocks.BlockTreestand;
import org.newthead.christmas.blocks.BlockWreath;
import org.newthead.christmas.entities.EntityCreeperClaus;
import org.newthead.christmas.entities.EntityEnderElf;
import org.newthead.christmas.items.ItemChristmasDrink;
import org.newthead.christmas.items.ItemChristmasLight;
import org.newthead.christmas.items.ItemChristmasPresent;
import org.newthead.christmas.items.ItemChristmasRecord;
import org.newthead.christmas.items.ItemChristmasStocking;
import org.newthead.christmas.items.ItemIceSkates;
import org.newthead.christmas.items.ItemOrnament;
import org.newthead.christmas.items.ItemTreestand;

@Mod(modid="ChristmasCraft", name="ChristmasCraft", version="3.0.0")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ChristmasCraft {
    @Mod.Instance(value="ChristmasCraft")
    public static ChristmasCraft instance;
    public static Configuration config;
    private static boolean forceChristmasTime;
    private static boolean allowGiftception;
    private static boolean playSnowSounds;
    private static Calendar calendar;
    public static final String RESOURCE_BASE = "christmascraft";
    @SidedProxy(clientSide="org.newthead.christmas.ClientModSetup", serverSide="org.newthead.christmas.ModSetup")
    public static ModSetup setup;
    private static int christmasLightOffBlockId;
    public static aqz blockChristmasLightOff;
    private static int christmasLightOnBlockId;
    public static aqz blockChristmasLightOn;
    private static int wreathBlockId;
    public static aqz blockWreath;
    private static int fruitcakeBlockId;
    public static aqz blockFruitcake;
    private static int stockingBlockId;
    public static aqz blockStocking;
    private static int ornamentBlockId;
    public static aqz blockOrnament;
    private static int treestandBlockId;
    public static aqz blockTreestand;
    private static int presentBlockId;
    public static aqz blockPresent;
    private static int christmasStarId;
    public static aqz blockChristmasStar;
    private static int christmasSpiceId;
    public static yc itemChristmasSpice;
    private static int chocolateMilkId;
    public static yc itemChocolateMilk;
    private static int hotCocoaId;
    public static yc itemHotCocoa;
    private static int candycaneId;
    public static yc itemCandycane;
    private static int gingerbreadId;
    public static yc itemGingerbread;
    private static int eggnogId;
    public static yc itemEggnog;
    private static int fruitcakeId;
    public static yc itemFruitcake;
    private static int iceSkatesId;
    public static yc itemIceSkates;
    private static int xmasDisc1Id;
    public static yc recordWish;
    private static int xmasDisc2Id;
    public static yc recordCarol;
    private static int xmasDisc3Id;
    public static yc recordJingle;
    private static Random random;
    public static ye[] stockingPresents;
    public static ye[] treePresents;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.loadConfiguration(event);
        setup.registerSounds();
    }

    private void loadConfiguration(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        forceChristmasTime = config.get("general", "forceChristmasTime", false).getBoolean(false);
        allowGiftception = config.get("general", "allowGiftsInsideGifts", false).getBoolean(false);
        playSnowSounds = config.get("general", "playBellsWhenSnowing", true).getBoolean(true);
        christmasLightOffBlockId = config.getBlock("xmasLightOffBlockIndex", 1230).getInt();
        christmasLightOnBlockId = config.getBlock("xmasLightOnBlockIndex", 1231).getInt();
        wreathBlockId = config.getBlock("wreathBlockIndex", 1232).getInt();
        fruitcakeBlockId = config.getBlock("fruitcakeBlockIndex", 1233).getInt();
        stockingBlockId = config.getBlock("stockingBlockIndex", 1234).getInt();
        ornamentBlockId = config.getBlock("ornamentBlockIndex", 1235).getInt();
        treestandBlockId = config.getBlock("treestandBlockIndex", 1236).getInt();
        presentBlockId = config.getBlock("presentBlockIndex", 1237).getInt();
        christmasStarId = config.getBlock("christmasStarBlockIndex", 1238).getInt();
        christmasSpiceId = config.getItem("christmasSpiceItemIndex", 25120).getInt();
        chocolateMilkId = config.getItem("chocolateMilkItemIndex", 25121).getInt();
        hotCocoaId = config.getItem("hotCocoaItemIndex", 25122).getInt();
        candycaneId = config.getItem("candycaneItemIndex", 25123).getInt();
        gingerbreadId = config.getItem("gingerbreadItemIndex", 25124).getInt();
        eggnogId = config.getItem("eggnogItemIndex", 25125).getInt();
        fruitcakeId = config.getItem("fruitcakeItemIndex", 25126).getInt();
        iceSkatesId = config.getItem("iceSkatesItemIndex", 25127).getInt();
        xmasDisc1Id = config.getItem("recordWishIndex", 25128).getInt();
        xmasDisc2Id = config.getItem("recordCarolIndex", 25129).getInt();
        xmasDisc3Id = config.getItem("recordJingleIndex", 25130).getInt();
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.createBlocks();
        GameRegistry.registerBlock((aqz)blockChristmasLightOff, ItemChristmasLight.class, (String)"blockChristmasLightOff");
        GameRegistry.registerBlock((aqz)blockChristmasLightOn, ItemChristmasLight.class, (String)"blockChristmasLightOn");
        GameRegistry.registerBlock((aqz)blockWreath, (String)"blockWreath");
        GameRegistry.registerBlock((aqz)blockFruitcake, (String)"blockFruitcake");
        GameRegistry.registerBlock((aqz)blockStocking, ItemChristmasStocking.class, (String)"blockStocking");
        GameRegistry.registerBlock((aqz)blockOrnament, ItemOrnament.class, (String)"blockOrnament");
        GameRegistry.registerBlock((aqz)blockTreestand, ItemTreestand.class, (String)"blockTreestand");
        GameRegistry.registerBlock((aqz)blockPresent, ItemChristmasPresent.class, (String)"blockPresent");
        GameRegistry.registerBlock((aqz)blockChristmasStar, (String)"blockChristmasStar");
        this.createItems();
        setup.registerTileEntities();
        setup.registerEntities();
        setup.registerCraftingRecipes();
        setup.registerRenderers();
        setup.registerItemNames();
        setup.registerTickHandlers();
    }

    private void createBlocks() {
        blockChristmasLightOff = new BlockChristmasLight(christmasLightOffBlockId, false).c(0.1f).c("xmasLight").d("christmascraft:xmasLight_off").a(ww.d);
        blockChristmasLightOn = new BlockChristmasLight(christmasLightOnBlockId, true).c(0.1f).c("xmasLight").d("christmascraft:xmasLight_on").a(ww.d);
        blockWreath = new BlockWreath(wreathBlockId).c(0.2f).c("wreath").d("christmascraft:wreath").a(ww.c);
        blockFruitcake = new BlockFruitcake(fruitcakeBlockId).c(0.5f).a(aqz.n).c("fruitcake").d("christmascraft:fruitcake");
        blockStocking = new BlockChristmasStocking(stockingBlockId).c("stocking").d("christmascraft:stocking").a(ww.c);
        blockOrnament = new BlockOrnament(ornamentBlockId).c(0.1f).c("ornament").d("christmascraft:ornament").a(ww.c);
        blockTreestand = new BlockTreestand(treestandBlockId).c(2.0f).b(5.0f).c("treestand").d("christmascraft:treestand").a(ww.c);
        blockPresent = new BlockChristmasPresent(presentBlockId).c(2.0f).b(3.0f).c("xmasGift").d("christmascraft:xmasGift");
        blockChristmasStar = new BlockChristmasStar(christmasStarId).c("xmasStar").d("christmascraft:xmasStar").a(ww.c);
    }

    private void createItems() {
        itemChristmasSpice = new yc(christmasSpiceId).b("xmasSpice").d("christmascraft:xmasSpice").a(ww.h);
        itemChocolateMilk = new ItemChristmasDrink(chocolateMilkId, 3, 0.3f).b("chocolateMilk").d("christmascraft:chocolateMilk").a(ww.h);
        itemHotCocoa = new ItemChristmasDrink(hotCocoaId, 8, 0.8f).b("hotCocoa").d("christmascraft:hotCocoa").a(ww.h);
        itemCandycane = new xx(candycaneId, 2, 0.6f, false).b("candycane").d("christmascraft:candycane").a(ww.h);
        itemGingerbread = new xx(gingerbreadId, 1, 0.1f, false).b("gingerbread").d("christmascraft:gingerbread").a(ww.h);
        itemEggnog = new ItemChristmasDrink(eggnogId, 5, 0.6f).k().a(ni.k.H, 20, 0, 0.4f).b("eggnog").d("christmascraft:eggnog").a(ww.h);
        itemFruitcake = new zi(fruitcakeId, blockFruitcake).d(1).b("fruitcake").d("christmascraft:fruitcake").a(ww.h);
        recordWish = new ItemChristmasRecord(xmasDisc1Id, "wish").b("record").d("christmascraft:record_wish");
        recordCarol = new ItemChristmasRecord(xmasDisc2Id, "carol").b("record").d("christmascraft:record_carol");
        recordJingle = new ItemChristmasRecord(xmasDisc3Id, "jingle").b("record").d("christmascraft:record_jingle");
        itemIceSkates = new ItemIceSkates(iceSkatesId).b("iceSkates").d("christmascraft:iceSkates").a(ww.e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.editWorldGen();
        this.populatePresentLists();
    }

    private void editWorldGen() {
        if (!ChristmasCraft.isChristmasTime()) {
            return;
        }
        for (int i = 0; i < acq.a.length; ++i) {
            if (acq.a[i] == null) continue;
            acq biome = acq.a[i];
            if (!(biome.F <= 1.0f) || biome instanceof adi || biome instanceof ade || biome instanceof ada || biome instanceof adk || biome instanceof add || biome instanceof acp || biome instanceof adh) continue;
            biome.F = 0.0f;
            biome.b();
            EntityRegistry.addSpawn(EntityCreeperClaus.class, (int)5, (int)1, (int)1, (oh)oh.b, (acq[])new acq[]{biome});
            EntityRegistry.addSpawn(EntityEnderElf.class, (int)1, (int)1, (int)4, (oh)oh.a, (acq[])new acq[]{biome});
            EntityRegistry.removeSpawn(tg.class, (oh)oh.a, (acq[])new acq[]{biome});
        }
    }

    public static boolean isChristmasTime() {
        if (forceChristmasTime) {
            return true;
        }
        calendar.setTime(new Date());
        return calendar.get(2) == 11;
    }

    public static boolean isChristmasDay() {
        calendar.setTime(new Date());
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean canWrapGiftsInsideGifts() {
        return allowGiftception;
    }

    public static boolean shouldPlaySnowSound() {
        return playSnowSounds;
    }

    public static ye getRandomStockingGift() {
        return PresentRecipe.createPresentFromItemStack(stockingPresents[random.nextInt(stockingPresents.length)]);
    }

    public static ye getRandomTreeGift() {
        return PresentRecipe.createPresentFromItemStack(treePresents[random.nextInt(treePresents.length)]);
    }

    private void populatePresentLists() {
        stockingPresents = new ye[]{new ye(yc.l), new ye(yc.aG), new ye(yc.aN), new ye(yc.W), new ye(yc.o), new ye(yc.aS), new ye((yc)yc.aT), new ye(yc.au), new ye(yc.aU), new ye(recordWish), new ye(recordCarol), new ye(recordJingle), new ye(yc.aC), new ye(yc.aO), new ye(yc.bD), new ye(itemCandycane), new ye(itemGingerbread), new ye(yc.j), new ye((yc)yc.ai), new ye((yc)yc.af), new ye(yc.R), new ye((yc)yc.ah), new ye(yc.i), new ye((yc)yc.ag), new ye(yc.h), new ye(yc.s), new ye(yc.bJ), new ye(yc.bR)};
        treePresents = new ye[]{new ye(yc.av), new ye(yc.E), new ye((yc)yc.am), new ye(yc.p), new ye((yc)yc.aj), new ye(yc.S), new ye((yc)yc.al), new ye(yc.D), new ye((yc)yc.ak), new ye(yc.C), new ye(yc.B), new ye(yc.bD), new ye((aqz)aqz.aa), new ye(aqz.am), new ye(aqz.an), new ye(aqz.bJ), new ye(yc.bA), new ye(yc.bq), new ye(yc.bC), new ye(blockFruitcake), new ye(itemIceSkates)};
    }

    static {
        forceChristmasTime = false;
        allowGiftception = false;
        playSnowSounds = true;
        calendar = Calendar.getInstance();
        random = new Random();
    }
}

