/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.extendedWorkbench.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import naruto1310.extendedWorkbench.item.ItemExtendedCompass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderExtendedCompass
implements IItemRenderer {
    double spawnI;
    double spawnJ;
    private int tileSizeBase = 16;
    private short[] imageDataR = new short[256];
    private short[] imageDataG = new short[256];
    private short[] imageDataB = new short[256];
    private RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderEquippedItem(stack.func_77973_b().func_77650_f(stack), 0, 0, 1.0f, 1.0f, 1.0f);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderInventoryItem(stack.func_77973_b().func_77650_f(stack), 0, 0, 1.0f, 1.0f, 1.0f);
        }
        ItemExtendedCompass.setupNBT(stack);
        if (stack.func_77978_p().func_74763_f("lastUpdate") < System.currentTimeMillis() - 50L) {
            stack.func_77978_p().func_74772_a("lastUpdate", System.currentTimeMillis());
            this.updateNeedles(stack.func_77978_p(), true);
        } else {
            this.updateNeedles(stack.func_77978_p(), false);
        }
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0001f);
        for (int i = 0; i < 256; ++i) {
            if (this.imageDataR[i] == -1 || this.imageDataG[i] == -1 || this.imageDataB[i] == -1) continue;
            if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                this.renderEquippedItem(ItemExtendedCompass.empty, 14 - i / 16, -1 + i % 16, (float)this.imageDataR[i] / 256.0f, (float)this.imageDataG[i] / 256.0f, (float)this.imageDataB[i] / 256.0f);
            }
            if (type != IItemRenderer.ItemRenderType.INVENTORY) continue;
            this.renderInventoryItem(ItemExtendedCompass.empty, i / 16, 16 - i % 16, (float)this.imageDataR[i] / 256.0f, (float)this.imageDataG[i] / 256.0f, (float)this.imageDataB[i] / 256.0f);
        }
    }

    private void renderEquippedItem(IIcon icon, int x, int y, float red, float green, float blue) {
        GL11.glColor3f((float)red, (float)green, (float)blue);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    private void renderInventoryItem(IIcon icon, int x, int y, float red, float green, float blue) {
        GL11.glColor3f((float)red, (float)green, (float)blue);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        this.renderItem.func_94149_a(x * 16, y * 16, icon, x == 0 ? 16 : 17, x == 0 ? 16 : 17);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    private void updateNeedles(NBTTagCompound nbt, boolean update) {
        for (int i = 0; i < 256; ++i) {
            this.imageDataB[i] = -1;
            this.imageDataG[i] = -1;
            this.imageDataR[i] = -1;
        }
        for (int k = 0; k < 4; ++k) {
            String s;
            if (!nbt.func_74764_b("needle" + k) || (s = nbt.func_74779_i("needle" + k)).length() <= 0 || s.charAt(0) != '1') continue;
            double i = Double.valueOf(s.substring(1, s.indexOf("a")));
            double j = Double.valueOf(s.substring(s.indexOf("a") + 1, s.indexOf("b")));
            int x = Integer.valueOf(s.substring(s.indexOf("b") + 1, s.indexOf("c")));
            int z = Integer.valueOf(s.substring(s.indexOf("c") + 1, s.indexOf("d")));
            int c = Integer.valueOf(s.substring(s.indexOf("d") + 1, s.indexOf("e")));
            s = "1" + this.drawNeedle(new ChunkCoordinates(x, 0, z), i, j, c) + "b" + x + "c" + z + "d" + c + "e" + s.substring(s.indexOf("e") + 1, s.length());
            if (!update) continue;
            nbt.func_74778_a("needle" + k, s);
        }
        if (nbt.func_74767_n("drawSpawnNeedle")) {
            String s = this.drawNeedle(Minecraft.func_71410_x().field_71441_e.func_72861_E(), this.spawnI, this.spawnJ, 0xFF1414);
            if (update) {
                this.spawnI = Double.valueOf(s.substring(0, s.indexOf("a")));
                this.spawnJ = Double.valueOf(s.substring(s.indexOf("a") + 1, s.length()));
            }
        }
    }

    private String drawNeedle(ChunkCoordinates coords, double i, double j, int color) {
        int xy;
        int y;
        int x;
        int f;
        double angle;
        for (angle = this.getNeedleAngle(coords) - 1.5707963267948966 - i; angle < -Math.PI; angle += Math.PI * 2) {
        }
        while (angle >= Math.PI) {
            angle -= Math.PI * 2;
        }
        j += Math.min(1.0, Math.max(-1.0, angle)) * 0.1;
        double sin = Math.sin(i += (j *= 0.8));
        double cos = Math.cos(i);
        for (f = -(this.tileSizeBase >> 2); f <= this.tileSizeBase >> 2; ++f) {
            x = (int)((double)(this.tileSizeBase >> 1) + 0.5 + cos * (double)f * 0.3);
            y = (int)((double)(this.tileSizeBase >> 1) - 0.5 - sin * (double)f * 0.3 * 0.5);
            xy = y * this.tileSizeBase + x;
            this.imageDataB[xy] = 100;
            this.imageDataG[xy] = 100;
            this.imageDataR[xy] = 100;
        }
        for (f = -(this.tileSizeBase >> 2); f <= this.tileSizeBase; ++f) {
            x = (int)((double)(this.tileSizeBase >> 1) + 0.5 + sin * (double)f * 0.3);
            y = (int)((double)(this.tileSizeBase >> 1) - 0.5 + cos * (double)f * 0.3);
            xy = y * this.tileSizeBase + x;
            this.imageDataR[xy] = (short)(f >= 0 ? (color & 0xFF0000) >> 16 : 100);
            this.imageDataG[xy] = (short)(f >= 0 ? (color & 0xFF00) >> 8 : 100);
            this.imageDataB[xy] = (short)(f >= 0 ? color & 0xFF : 100);
        }
        return i + "a" + j;
    }

    private double getNeedleAngle(ChunkCoordinates coords) {
        double angle = 0.0;
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            double x = (double)coords.field_71574_a - Minecraft.func_71410_x().field_71439_g.field_70165_t;
            double z = (double)coords.field_71573_c - Minecraft.func_71410_x().field_71439_g.field_70161_v;
            angle = (double)(Minecraft.func_71410_x().field_71439_g.field_70177_z - 90.0f) * Math.PI / 180.0 - Math.atan2(z, x);
            if (!Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76569_d()) {
                angle = Math.random() * Math.PI * 2.0;
            }
        }
        return angle;
    }
}

