/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.themes.Theme;
import jaredbgreat.dldungeons.themes.ThemeReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private static File mainConfig;
    private static File themesDir;
    private static File listsDir;
    private static final int DEFAULT_SCALE = 6;
    private static final int DEFAULT_MINXZ = 16;
    private static final int DEFAULT_DIF = 3;
    private static final int[] DEFAULT_DIMS;
    private static boolean writeLists;
    private static final boolean DEFAULT_NODEND = true;
    private static final boolean DEFAULT_WRITE_LISTS = false;
    public static Difficulty difficulty;

    public static void init(File file) {
        mainConfig = file;
        Configuration config = new Configuration(file);
        config.load();
        int freqScale = config.get("General", "FrequencyScale", 6).getInt();
        if (freqScale > 30 || freqScale < 4) {
            freqScale = 6;
        }
        GenerationHandler.setFrequency(freqScale);
        System.out.println("[DLDUNGEONS] Frequency Scaling Factor Set To: " + freqScale);
        int minXZ = config.get("General", "MinChunkXY", 16).getInt();
        if (minXZ < 0) {
            freqScale = 16;
        }
        GenerationHandler.setMinXZ(minXZ);
        System.out.println("[DLDUNGEONS] Minimum X Factor Set To: " + minXZ);
        int diff = config.get("General", "Difficulty", 3).getInt();
        if (diff < 0 || diff > 5) {
            freqScale = 3;
        }
        ConfigHandler.parseDiff(diff);
        System.out.println("[DLDUNGEONS] Difficulty set to: " + ConfigHandler.difficulty.label);
        int[] dims = config.get("General", "Allowed Dimensions", DEFAULT_DIMS).getIntList();
        GenerationHandler.setDimensions(dims);
        System.out.print("[DLDUNGEONS] Dungeons will spawn in these dimensions: ");
        for (int i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        boolean noEnd = config.get("General", "NotInEnd", true).getBoolean(true);
        GenerationHandler.setEnd(noEnd);
        System.out.println("[DLDUNGEONS] NoEnd set to: " + noEnd);
        writeLists = config.get("General", "ExportLists", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will export item, block, and mob lists? " + writeLists);
        Theme.addDefaultTheme();
        ConfigHandler.openThemesDir();
        config.save();
    }

    public static void generateLists() {
        if (!writeLists) {
            return;
        }
        listsDir = new File(themesDir.toString() + File.separator + "lists");
        if (!listsDir.exists()) {
            listsDir.mkdir();
        }
        if (!listsDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + listsDir + ".");
        } else if (!listsDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + listsDir + " is not a directory (folder); no themes loaded.");
        } else {
            ConfigHandler.listEntities();
            ConfigHandler.listItems();
            ConfigHandler.listBlocks();
        }
    }

    public static void listEntities() {
        ArrayList mobNames = new ArrayList();
        mobNames.addAll(EntityList.field_75625_b.keySet());
        Collections.sort(mobNames);
        BufferedWriter outstream = null;
        File moblist = new File(listsDir.toString() + File.separator + "mobs.txt");
        if (moblist.exists()) {
            moblist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(moblist.toString()));
            if (outstream == null) {
                throw new IOException();
            }
            for (String name : mobNames) {
                Class A = (Class)EntityList.field_75625_b.get(name);
                if (!EntityLiving.class.isAssignableFrom(A) || Modifier.isAbstract(A.getModifiers())) continue;
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file mobs.txt");
            e.printStackTrace();
        }
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "itmes.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            if (outstream == null) {
                throw new IOException();
            }
            for (Object item : Item.field_150901_e) {
                String name = Item.field_150901_e.func_148750_c(item);
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file items.txt");
            e.printStackTrace();
        }
    }

    public static void listBlocks() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "blocks.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            if (outstream == null) {
                throw new IOException();
            }
            for (Object block : Block.field_149771_c) {
                String name = Block.field_149771_c.func_148750_c(block);
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file blocks.txt");
            e.printStackTrace();
        }
    }

    private static void openThemesDir() {
        String themesDirName = mainConfig.getParentFile() + File.separator + "DLDungeonThemes" + File.separator;
        themesDir = new File(themesDirName);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        if (!themesDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + themesDirName + ".");
        } else if (!themesDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + themesDirName + " is not a directory (folder); no themes loaded.");
        } else {
            ThemeReader.setThemesDir(themesDir);
        }
    }

    private static void parseDiff(int diff) {
        switch (diff) {
            case 0: {
                difficulty = Difficulty.NONE;
                break;
            }
            case 1: {
                difficulty = Difficulty.BABY;
                break;
            }
            case 2: {
                difficulty = Difficulty.NOOB;
                break;
            }
            case 4: {
                difficulty = Difficulty.HARD;
                break;
            }
            case 5: {
                difficulty = Difficulty.NUTS;
                break;
            }
            default: {
                difficulty = Difficulty.NORM;
            }
        }
    }

    static {
        DEFAULT_DIMS = new int[]{0, -1};
    }
}

