/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces;

import jaredbgreat.dldungeons.pieces.Rectangle;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Room;

public class Shape {
    Rectangle[] rectangles;
    public static final Shape simpleRect;
    public static final Shape X;
    public static final Shape[] xgroup;
    public static final Shape L000;
    public static final Shape L090;
    public static final Shape L180;
    public static final Shape L270;
    public static final Shape[] lgroup;
    public static final Shape O;
    public static final Shape[] ogroup;
    public static final Shape T000;
    public static final Shape T090;
    public static final Shape T180;
    public static final Shape T270;
    public static final Shape[] tgroup;
    public static final Shape F000;
    public static final Shape F090;
    public static final Shape F180;
    public static final Shape F270;
    public static final Shape[] fgroup;
    public static final Shape E000;
    public static final Shape E090;
    public static final Shape E180;
    public static final Shape E270;
    public static final Shape[] egroup;
    public static final Shape I000;
    public static final Shape I090;
    public static final Shape I180;
    public static final Shape I270;
    public static final Shape[] igroup;
    public static final Shape CROSS;
    public static final Shape[] cgroup;
    public static final Shape U000;
    public static final Shape U090;
    public static final Shape U180;
    public static final Shape U270;
    public static final Shape[] ugroup;
    public static final Shape S000;
    public static final Shape S090;
    public static final Shape S180;
    public static final Shape S270;
    public static final Shape[] sgroup;
    public static final Shape[][] assymmetrics;
    public static final Shape[][] xsymmetrics;
    public static final Shape[][] ysymmetrics;
    public static final Shape[][] xysymmetrics;
    public static final Shape[][] transshapes;
    public static final Shape[][] rotateds;
    public static final Shape[][] allshapes;
    public static final Shape[][] assymmetricPart;
    public static final Shape[][] xsymmetricPart;
    public static final Shape[][] ysymmetricPart;
    public static final Shape[][] xysymmetricPart;
    public static final Shape[][] transPart;
    public static final Shape[][] rotatedPart;
    public static final Shape[][] allPart;
    public static final Shape[][] assymmetricSolid;
    public static final Shape[][] xsymmetricSolid;
    public static final Shape[][] ysymmetricSolid;
    public static final Shape[][] xysymmetricSolid;
    public static final Shape[][] transSolid;
    public static final Shape[][] rotatedSolid;
    public static final Shape[][] allSolids;

    public Shape(Rectangle[] rectangles) {
        this.rectangles = rectangles;
    }

    public void write(Dungeon dungeon, Room room, float sx, byte sy, float sz, byte height, byte sdimx, byte sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.write(dungeon, room, sx, sy, sz, height, sdimx, sdimz, invertX, invertZ);
        }
    }

    public void drawLiquid(Dungeon dungeon, Room room, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.drawLiquid(dungeon, room, sx, sz, sdimx, sdimz, invertX, invertZ);
        }
    }

    public void drawWalkway(Dungeon dungeon, Room room, float sx, float sz, byte sdimx, byte sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.drawWalkway(dungeon, room, sx, sz, sdimx, sdimz, invertX, invertZ);
        }
    }

    public void drawCutout(Dungeon dungeon, Room room, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.drawCutout(dungeon, room, sx, sz, sdimx, sdimz, invertX, invertZ);
        }
    }

    public void drawCutin(Dungeon dungeon, Room room, float sx, float sz, byte sdimx, byte sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.drawCutin(dungeon, room, sx, sz, sdimx, sdimz, invertX, invertZ);
        }
    }

    public void drawPlatform(Dungeon dungeon, Room room, byte floorY, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        for (Rectangle rect : this.rectangles) {
            rect.drawPlatform(dungeon, room, floorY, sx, sz, sdimx, sdimz, invertX, invertZ);
        }
    }

    static {
        X = simpleRect = new Shape(new Rectangle[]{Rectangle.simple});
        xgroup = new Shape[]{X, X, X, X};
        L000 = new Shape(new Rectangle[]{Rectangle.lback000, Rectangle.lbottom000});
        L090 = new Shape(new Rectangle[]{Rectangle.lback090, Rectangle.lbottom090});
        L180 = new Shape(new Rectangle[]{Rectangle.lback180, Rectangle.lbottom180});
        L270 = new Shape(new Rectangle[]{Rectangle.lback270, Rectangle.lbottom270});
        lgroup = new Shape[]{L000, L090, L180, L270};
        O = new Shape(new Rectangle[]{Rectangle.obottom, Rectangle.oleft, Rectangle.oright, Rectangle.otop});
        ogroup = new Shape[]{O, O, O, O};
        T000 = new Shape(new Rectangle[]{Rectangle.ttop000, Rectangle.tbottom000});
        T090 = new Shape(new Rectangle[]{Rectangle.ttop090, Rectangle.tbottom090});
        T180 = new Shape(new Rectangle[]{Rectangle.ttop180, Rectangle.tbottom180});
        T270 = new Shape(new Rectangle[]{Rectangle.ttop270, Rectangle.tbottom270});
        tgroup = new Shape[]{T000, T090, T180, T270};
        F000 = new Shape(new Rectangle[]{Rectangle.eback000, Rectangle.etop000, Rectangle.emiddle000});
        F090 = new Shape(new Rectangle[]{Rectangle.eback090, Rectangle.etop090, Rectangle.emiddle090});
        F180 = new Shape(new Rectangle[]{Rectangle.eback180, Rectangle.etop180, Rectangle.emiddle180});
        F270 = new Shape(new Rectangle[]{Rectangle.eback270, Rectangle.etop270, Rectangle.emiddle270});
        fgroup = new Shape[]{F000, F090, F180, F270};
        E000 = new Shape(new Rectangle[]{Rectangle.eback000, Rectangle.etop000, Rectangle.emiddle000, Rectangle.ebottom000});
        E090 = new Shape(new Rectangle[]{Rectangle.eback090, Rectangle.etop090, Rectangle.emiddle090, Rectangle.ebottom090});
        E180 = new Shape(new Rectangle[]{Rectangle.eback180, Rectangle.etop180, Rectangle.emiddle180, Rectangle.ebottom180});
        E270 = new Shape(new Rectangle[]{Rectangle.eback270, Rectangle.etop270, Rectangle.emiddle270, Rectangle.ebottom270});
        egroup = new Shape[]{E000, E090, E180, E270};
        I000 = new Shape(new Rectangle[]{Rectangle.itop, Rectangle.imiddle, Rectangle.ibottom});
        I090 = new Shape(new Rectangle[]{Rectangle.ileft, Rectangle.imiddle, Rectangle.iright});
        I180 = I000;
        I270 = I090;
        igroup = new Shape[]{I000, I090, I180, I270};
        CROSS = new Shape(new Rectangle[]{Rectangle.crosstop, Rectangle.crossmiddle, Rectangle.crossbottom});
        cgroup = new Shape[]{CROSS, CROSS, CROSS, CROSS};
        U000 = new Shape(new Rectangle[]{Rectangle.uleft000, Rectangle.uright000, Rectangle.ubottom000});
        U090 = new Shape(new Rectangle[]{Rectangle.uleft090, Rectangle.uright090, Rectangle.ubottom090});
        U180 = new Shape(new Rectangle[]{Rectangle.uleft180, Rectangle.uright180, Rectangle.ubottom180});
        U270 = new Shape(new Rectangle[]{Rectangle.uleft270, Rectangle.uright270, Rectangle.ubottom270});
        ugroup = new Shape[]{U000, U090, U180, U270};
        S000 = new Shape(new Rectangle[]{Rectangle.stop000, Rectangle.smiddle000, Rectangle.sbottom000, Rectangle.sleft000, Rectangle.sright000});
        S090 = new Shape(new Rectangle[]{Rectangle.stop090, Rectangle.smiddle090, Rectangle.sbottom090, Rectangle.sleft090, Rectangle.sright090});
        S180 = S000;
        S270 = S090;
        sgroup = new Shape[]{S000, S090, S180, S270};
        assymmetrics = new Shape[][]{fgroup};
        xsymmetrics = new Shape[][]{xgroup, ogroup, cgroup, ugroup, tgroup, igroup};
        ysymmetrics = new Shape[][]{xgroup, ogroup, cgroup, egroup, igroup};
        xysymmetrics = new Shape[][]{xgroup, ogroup, cgroup, igroup};
        transshapes = new Shape[][]{lgroup, xgroup, ogroup, cgroup};
        rotateds = new Shape[][]{sgroup, xgroup, ogroup, cgroup, igroup};
        allshapes = new Shape[][]{xgroup, lgroup, ogroup, tgroup, fgroup, egroup, igroup, cgroup, ugroup, sgroup};
        assymmetricPart = new Shape[][]{fgroup};
        xsymmetricPart = new Shape[][]{ogroup, cgroup, ugroup, tgroup, igroup};
        ysymmetricPart = new Shape[][]{ogroup, cgroup, egroup, igroup};
        xysymmetricPart = new Shape[][]{ogroup, cgroup, igroup};
        transPart = new Shape[][]{ogroup, cgroup, lgroup};
        rotatedPart = new Shape[][]{sgroup, ogroup, cgroup, igroup};
        allPart = new Shape[][]{lgroup, ogroup, tgroup, fgroup, egroup, igroup, cgroup, ugroup, sgroup};
        assymmetricSolid = new Shape[][]{fgroup};
        xsymmetricSolid = new Shape[][]{xgroup, ugroup, tgroup};
        ysymmetricSolid = new Shape[][]{xgroup, egroup};
        xysymmetricSolid = new Shape[][]{xgroup};
        transSolid = new Shape[][]{xgroup, lgroup};
        rotatedSolid = new Shape[][]{sgroup, xgroup};
        allSolids = new Shape[][]{xgroup, lgroup, tgroup, fgroup, egroup, ugroup};
    }
}

