/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class TreasureChest
extends BasicChest {
    static ArrayList<Integer> slots = new ArrayList();
    int slot;

    public TreasureChest(int x, int y, int z, int level) {
        super(x, y, z, level);
    }

    @Override
    public void place(World world, int x, int y, int z, Random random) {
        ItemStack treasure;
        int i;
        Collections.shuffle(slots, random);
        this.slot = 0;
        this.level += random.nextInt(2);
        Builder.placeBlock(world, x, y, z, (Block)chest, 0, 2);
        TileEntityChest contents = (TileEntityChest)world.func_147438_o(x, y, z);
        this.vanillaChest(contents, random);
        int num = random.nextInt(2 + this.level / 3) + 2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.heal.levels[this.level].getLoot(random).getStack(random);
            if (contents.func_70301_a(this.slot) != null) {
                ++this.slot;
            }
            contents.func_70299_a(slots.get(this.slot++).intValue(), treasure);
        }
        num = random.nextInt(2 + this.level / 3) + 2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.gear.levels[this.level].getLoot(random).getStack(random);
            if (contents.func_70301_a(this.slot) != null) {
                ++this.slot;
            }
            contents.func_70299_a(slots.get(this.slot++).intValue(), treasure);
            if (this.slot <= 26) continue;
            return;
        }
        num = random.nextInt(3 + this.level / 2) + 3;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.loot.levels[this.level].getLoot(random).getStack(random);
            if (contents.func_70301_a(this.slot) != null) {
                ++this.slot;
            }
            contents.func_70299_a(slots.get(this.slot++).intValue(), treasure);
            if (this.slot <= 26) continue;
            return;
        }
        if (random.nextInt(9) < this.level) {
            treasure = this.level >= 7 ? LootList.special.getLoot(random).getStack(random) : LootList.discs.getLoot(random).getStack(random);
            if (contents.func_70301_a(this.slot) != null) {
                ++this.slot;
            }
            contents.func_70299_a(slots.get(this.slot++).intValue(), treasure);
            if (this.slot > 26) {
                return;
            }
        }
    }

    private void vanillaChest(TileEntityChest chest, Random random) {
        ChestGenHooks chinf;
        int which = random.nextInt(4);
        switch (which) {
            case 0: {
                chinf = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
                break;
            }
            case 1: {
                chinf = ChestGenHooks.getInfo((String)"pyramidJungleChest");
                break;
            }
            default: {
                chinf = ChestGenHooks.getInfo((String)"dungeonChest");
            }
        }
        WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chinf.getItems(random), (IInventory)chest, (int)chinf.getCount(random));
    }

    public static void initSlots() {
        for (int i = 0; i < 27; ++i) {
            slots.add(new Integer(i));
        }
    }
}

