/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner;

import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.pieces.Spawner;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.entrances.SimpleEntrance;
import jaredbgreat.dldungeons.pieces.entrances.SpiralStair;
import jaredbgreat.dldungeons.pieces.entrances.TopRoom;
import jaredbgreat.dldungeons.planner.Node;
import jaredbgreat.dldungeons.planner.PlaceSeed;
import jaredbgreat.dldungeons.planner.Route;
import jaredbgreat.dldungeons.planner.mapping.MapMatrix;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.rooms.RoomList;
import jaredbgreat.dldungeons.themes.BiomeLists;
import jaredbgreat.dldungeons.themes.Degrees;
import jaredbgreat.dldungeons.themes.Sizes;
import jaredbgreat.dldungeons.themes.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Dungeon {
    public Theme theme;
    public Random random;
    public BiomeGenBase biome;
    public MapMatrix map;
    public Node[] nodes;
    public int numNodes;
    public int roomCount;
    public int entrancePref;
    public int baseHeight;
    public RoomList rooms;
    public ArrayList<Room> planter;
    public ArrayList<Room> grower;
    public Sizes size;
    public Degrees outside;
    public Degrees liquids;
    public Degrees subrooms;
    public Degrees islands;
    public Degrees pillars;
    public Degrees fences;
    public Degrees symmetry;
    public Degrees variability;
    public Degrees degeneracy;
    public Degrees complexity;
    public Degrees verticle;
    public Degrees entrances;
    public Degrees bigRooms;
    public Block wallBlock1;
    public Block floorBlock;
    public Block cielingBlock;
    public Block stairBlock;
    public Block stairSlab;
    public Block fenceBlock;
    public Block cornerBlock;
    public Block liquidBlock;

    public void finalize() throws Throwable {
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = null;
        }
        for (Room room : this.rooms) {
            room.finalize();
        }
        this.rooms.clear();
        this.rooms = null;
        this.grower = null;
        this.planter = null;
        this.nodes = null;
        this.theme = null;
        this.random = null;
        this.biome = null;
        this.map = null;
        this.size = null;
        this.outside = null;
        this.liquids = null;
        this.subrooms = null;
        this.islands = null;
        this.pillars = null;
        this.symmetry = null;
        this.variability = null;
        this.degeneracy = null;
        this.complexity = null;
        this.verticle = null;
        this.entrances = null;
        this.bigRooms = null;
        super.finalize();
    }

    public Dungeon(Random random, BiomeGenBase biome, World world, int chunkX, int chunkZ) throws Throwable {
        if (biome == BiomeGenBase.field_76779_k) {
            return;
        }
        this.random = new Random(random.nextLong());
        this.biome = biome;
        this.theme = BiomeLists.getTheme(biome, random);
        this.applyTheme();
        this.entrancePref = random.nextInt(3);
        this.wallBlock1 = this.theme.walls.choose(random);
        this.floorBlock = this.theme.floors.choose(random);
        this.cielingBlock = this.theme.ceilings.choose(random);
        this.fenceBlock = this.theme.fencing.choose(random);
        this.cornerBlock = this.theme.pillarBlock.choose(random);
        this.liquidBlock = this.theme.liquid.choose(random);
        this.rooms = new RoomList(this.size.maxRooms + 1);
        this.planter = new ArrayList();
        this.map = new MapMatrix(this.size.width, world, chunkX, chunkZ);
        this.numNodes = random.nextInt(this.size.maxNodes - this.size.minNodes) + this.size.minNodes + 1;
        this.nodes = new Node[this.numNodes];
        this.makeNodes();
        this.connectNodes();
        this.growthCycle();
    }

    private void applyTheme() {
        this.size = this.theme.sizes.select(this.random);
        this.outside = this.theme.outside.select(this.random);
        this.liquids = this.theme.liquids.select(this.random);
        this.subrooms = this.theme.subrooms.select(this.random);
        this.islands = this.theme.islands.select(this.random);
        this.pillars = this.theme.pillars.select(this.random);
        this.fences = this.theme.fences.select(this.random);
        this.symmetry = this.theme.symmetry.select(this.random);
        this.variability = this.theme.variability.select(this.random);
        this.degeneracy = this.theme.degeneracy.select(this.random);
        this.complexity = this.theme.complexity.select(this.random);
        this.verticle = this.theme.verticle.select(this.random);
        this.entrances = this.theme.entrances.select(this.random);
        this.baseHeight = this.random.nextInt(this.theme.maxY - this.theme.minY) + this.theme.minY;
    }

    void makeNodes() {
        int height = this.baseHeight;
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i] = new Node(this.random.nextInt(this.size.width), height, this.random.nextInt(this.size.width), this.random, this);
        }
    }

    void connectNodes() throws Throwable {
        for (int i = 0; i < this.nodes.length; ++i) {
            Node first = this.nodes[i];
            if (first == null || first.hubRoom == null) continue;
            for (int j = i + 1; j < this.nodes.length; ++j) {
                Node other = this.nodes[j];
                if (other == null || other.hubRoom == null) continue;
                if (this.rooms.size() >= this.size.maxRooms) {
                    return;
                }
                if (other == first) continue;
                new Route(first, other).drawConnections(this);
            }
        }
    }

    void makeMoreRooms() {
        while (this.rooms.size() <= this.size.maxRooms) {
            int zdim;
            int height = this.baseHeight;
            int x = this.random.nextInt(this.size.width);
            int z = this.random.nextInt(this.size.width);
            int xdim = this.random.nextInt(this.size.maxRoomSize - 5) + 6;
            int ymod = xdim <= (zdim = this.random.nextInt(this.size.maxRoomSize - 5) + 6) ? (int)Math.sqrt(xdim) : (int)Math.sqrt(zdim);
            int roomHeight = this.random.nextInt(this.verticle.value / 2 + ymod + 1) + 2;
            Room room = new PlaceSeed(x, height, z).growRoom(xdim, zdim, roomHeight, this, null, null);
        }
    }

    public void growthCycle() {
        int depth = this.subrooms.value;
        int limit = this.size.maxRooms * (depth + 1) / 5;
        boolean doMore = true;
        do {
            --depth;
            doMore = false;
            this.grower = this.planter;
            Collections.shuffle(this.grower, this.random);
            this.planter = new ArrayList();
            for (Room room : this.grower) {
                --limit;
                if (this.rooms.size() >= this.size.maxRooms) {
                    return;
                }
                if (!room.plantChildren(this)) continue;
                doMore = true;
            }
        } while (doMore && depth > 0 && limit > 0);
    }

    public void addSpawners() {
        int shiftX = this.map.chunkX * 16 - this.map.room.length / 2 + 8;
        int shiftZ = this.map.chunkZ * 16 - this.map.room.length / 2 + 8;
        for (Room room : this.rooms) {
            for (Spawner spawner : room.spawners) {
                Builder.placeSpawner(this.map.world, shiftX + spawner.x, spawner.y, shiftZ + spawner.z, spawner.mob);
            }
            for (BasicChest chest : room.chests) {
                chest.place(this.map.world, shiftX + chest.mx, chest.my, shiftZ + chest.mz, this.random);
            }
            if (!room.hasEntrance) continue;
            this.addEntrances(room);
        }
    }

    public void addEntrances(Room room) {
        int entrance = this.variability.use(this.random) ? this.random.nextInt(3) : this.entrancePref;
        switch (entrance) {
            case 0: {
                new SpiralStair((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
                break;
            }
            case 1: {
                new TopRoom((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
                break;
            }
            default: {
                new SimpleEntrance((int)room.realX, room.floorY, (int)room.realZ).build(this, this.map.world);
            }
        }
    }

    public void build() {
        if (this.map != null) {
            this.map.build(this);
        }
    }
}

