/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.planner;

import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Room;

public class PlaceSeed {
    private int w = 0;
    private int lowEdge;
    private int highEdge;
    private boolean canAddX = true;
    private boolean canAddZ = true;
    private boolean canSubX = true;
    private boolean canSubZ = true;
    int x;
    int y;
    int z;
    int height;
    int grownX = 1;
    int grownZ = 1;
    int endX;
    int beginX;
    int endZ;
    int beginZ;

    public PlaceSeed(int startX, int startY, int startZ) {
        this.endX = this.beginX = startX;
        this.x = this.beginX;
        this.y = startY;
        this.endZ = this.beginZ = startZ;
        this.z = this.beginZ;
    }

    public Room growRoom(int xdim, int zdim, int height, Dungeon dungeon, Room parent, Room previous) {
        if (dungeon.rooms.size() >= dungeon.size.maxRooms) {
            return null;
        }
        if (dungeon.random.nextBoolean()) {
            return this.growRoomX(xdim, zdim, height, dungeon, parent, previous);
        }
        return this.growRoomZ(xdim, zdim, height, dungeon, parent, previous);
    }

    public Room growRoomX(int xdim, int zdim, int height, Dungeon dungeon, Room parent, Room previous) {
        int container;
        if (parent == null) {
            container = 0;
            this.w = 0;
        } else {
            container = parent.id;
            this.w = 1;
        }
        if (this.x >= dungeon.size.width || this.x < 0 || this.z >= dungeon.size.width || this.z < 0) {
            return null;
        }
        if (dungeon.map.room[this.x][this.z] != container) {
            return null;
        }
        while ((this.canAddX || this.canSubX) && this.grownX < xdim) {
            if (this.endX + 1 >= dungeon.size.width) {
                this.canAddX = false;
            }
            if (this.beginX - 1 < 0) {
                this.canSubX = false;
            }
            if (this.canAddX) {
                if (dungeon.map.room[this.endX + this.w][this.z] == container) {
                    ++this.grownX;
                    ++this.endX;
                } else {
                    this.canAddX = false;
                }
            }
            if (!this.canSubX) continue;
            if (dungeon.map.room[this.beginX - this.w][this.z] == container) {
                ++this.grownX;
                --this.beginX;
                continue;
            }
            this.canSubX = false;
        }
        while ((this.canAddZ || this.canSubZ) && this.grownZ < zdim) {
            this.lowEdge = this.beginX + 1 - this.w;
            this.highEdge = this.endX - 1 + this.w;
            for (int i = this.lowEdge; i <= this.highEdge; ++i) {
                if (this.endZ + 1 >= dungeon.size.width) {
                    this.canAddZ = false;
                } else if (dungeon.map.room[i][this.endZ + this.w] != container) {
                    this.canAddZ = false;
                }
                if (this.beginZ - 1 < 0) {
                    this.canSubZ = false;
                    continue;
                }
                if (dungeon.map.room[i][this.beginZ - this.w] == container) continue;
                this.canSubZ = false;
            }
            if (this.canAddZ) {
                ++this.grownZ;
                ++this.endZ;
            }
            if (!this.canSubZ) continue;
            ++this.grownZ;
            --this.beginZ;
        }
        if (this.grownX < 5 || this.grownZ < 5) {
            return null;
        }
        ++dungeon.roomCount;
        return new Room(this.beginX, this.endX, this.beginZ, this.endZ, this.y, this.y + height, dungeon, parent, previous);
    }

    public Room growRoomZ(int xdim, int zdim, int height, Dungeon dungeon, Room parent, Room previous) {
        int container;
        if (parent == null) {
            container = 0;
            this.w = 0;
        } else {
            container = parent.id;
            this.w = 1;
        }
        if (this.x >= dungeon.size.width || this.x < 0 || this.z >= dungeon.size.width || this.z < 0) {
            return null;
        }
        if (dungeon.map.room[this.x][this.z] != container) {
            return null;
        }
        while ((this.canAddZ || this.canSubZ) && this.grownZ < zdim) {
            if (this.endZ + 1 >= dungeon.size.width) {
                this.canAddZ = false;
            }
            if (this.beginZ - 1 < 0) {
                this.canSubZ = false;
            }
            if (this.canAddZ) {
                if (dungeon.map.room[this.x][this.endZ + this.w] == container) {
                    ++this.grownZ;
                    ++this.endZ;
                } else {
                    this.canAddZ = false;
                }
            }
            if (!this.canSubZ) continue;
            if (dungeon.map.room[this.x][this.beginZ - this.w] == container) {
                ++this.grownZ;
                --this.beginZ;
                continue;
            }
            this.canSubZ = false;
        }
        while ((this.canAddX || this.canSubX) && this.grownX < xdim) {
            this.lowEdge = this.beginZ + 1 - this.w;
            this.highEdge = this.endZ - 1 + this.w;
            for (int i = this.lowEdge; i <= this.highEdge; ++i) {
                if (this.endX + 1 >= dungeon.size.width) {
                    this.canAddX = false;
                } else if (dungeon.map.room[this.endX + this.w][i] != container) {
                    this.canAddX = false;
                }
                if (this.beginX - 1 < 0) {
                    this.canSubX = false;
                    continue;
                }
                if (dungeon.map.room[this.beginX - this.w][i] == container) continue;
                this.canSubX = false;
            }
            if (this.canAddX) {
                ++this.grownX;
                ++this.endX;
            }
            if (!this.canSubX) continue;
            ++this.grownX;
            --this.beginX;
        }
        if (this.grownX < 5 || this.grownZ < 5) {
            return null;
        }
        ++dungeon.roomCount;
        return new Room(this.beginX, this.endX, this.beginZ, this.endZ, this.y, this.y + height, dungeon, parent, previous);
    }
}

