/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.rooms;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.pieces.Shape;
import jaredbgreat.dldungeons.pieces.Shapes;
import jaredbgreat.dldungeons.pieces.Spawner;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.TreasureChest;
import jaredbgreat.dldungeons.pieces.chests.WeakChest;
import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.planner.PlaceSeed;
import jaredbgreat.dldungeons.planner.Route;
import jaredbgreat.dldungeons.planner.Symmetry;
import jaredbgreat.dldungeons.planner.features.Cutout;
import jaredbgreat.dldungeons.planner.features.Depression;
import jaredbgreat.dldungeons.planner.features.FeatureAdder;
import jaredbgreat.dldungeons.planner.features.IslandPlatform;
import jaredbgreat.dldungeons.planner.features.IslandRoom;
import jaredbgreat.dldungeons.planner.features.Pillar;
import jaredbgreat.dldungeons.planner.features.Pool;
import jaredbgreat.dldungeons.rooms.AbstractRoom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Room
extends AbstractRoom {
    public int id;
    public static final Room roomNull = new Room();
    public int beginX;
    public int endX;
    public int beginZ;
    public int endZ;
    public int floorY;
    public int nFloorY;
    public int ceilY;
    public int nCeilY;
    public int y;
    public int level;
    public float realX;
    public float realZ;
    public boolean hasWholePattern;
    public Symmetry sym;
    public int orientation;
    public boolean XFlip;
    public boolean ZFlip;
    public Shapes shape = Shapes.X;
    public ArrayList<PlaceSeed> childSeeds;
    public boolean isNode;
    public boolean hasEntrance;
    public boolean hasSpawners;
    public ArrayList<Spawner> spawners;
    public ArrayList<BasicChest> chests;

    private Room() {
        this.id = 0;
    }

    public void finalize() throws Throwable {
        this.childSeeds.clear();
        this.childSeeds = null;
        this.spawners.clear();
        this.chests.clear();
        this.spawners = null;
        this.chests = null;
        super.finalize();
    }

    public Room(int beginX, int endX, int beginZ, int endZ, int floorY, int ceilY, Dungeon dungeon, Room parent, Room previous) {
        super(dungeon, previous);
        int j;
        int i;
        dungeon.rooms.add(this);
        this.id = dungeon.rooms.size();
        this.childSeeds = new ArrayList();
        this.spawners = new ArrayList();
        this.chests = new ArrayList();
        dungeon.planter.add(this);
        this.isNode = previous == null;
        boolean bl = this.hasEntrance = this.isNode && dungeon.entrances.use(dungeon.random);
        if (this.isNode) {
            this.degenerateFloors = false;
        }
        this.hasSpawners = false;
        this.sym = Symmetry.getSymmetry(dungeon);
        this.orientation = dungeon.random.nextInt(4);
        this.XFlip = dungeon.random.nextBoolean();
        this.ZFlip = dungeon.random.nextBoolean();
        if (this.sym == Symmetry.TR1 && this.XFlip != this.ZFlip) {
            this.sym = Symmetry.TR2;
        }
        this.beginX = beginX;
        this.endX = endX;
        this.beginZ = beginZ;
        this.endZ = endZ;
        this.floorY = floorY;
        this.ceilY = ceilY;
        this.level = 0;
        if (parent != null) {
            this.sky = this.sky && !dungeon.outside.use(dungeon.random);
        }
        this.realX = (float)(endX - beginX) / 2.0f + (float)beginX + 1.0f;
        this.realZ = (float)(endZ - beginZ) / 2.0f + (float)beginZ + 1.0f;
        for (i = beginX + 1; i < endX; ++i) {
            for (j = beginZ + 1; j < endZ; ++j) {
                if (dungeon.map.room[i][j] == 0) {
                    dungeon.map.room[i][j] = this.id;
                }
                byte by = (byte)ceilY;
                dungeon.map.nCeilY[i][j] = by;
                dungeon.map.ceilY[i][j] = by;
                byte by2 = (byte)floorY;
                dungeon.map.nFloorY[i][j] = by2;
                dungeon.map.floorY[i][j] = by2;
                if (!this.sky) {
                    dungeon.map.ceiling[i][j] = this.cielingBlock;
                }
                dungeon.map.floor[i][j] = this.floorBlock;
                dungeon.map.wall[i][j] = this.wallBlock1;
                dungeon.map.hasLiquid[i][j] = false;
                dungeon.map.isWall[i][j] = false;
            }
        }
        for (i = beginX; i <= endX; ++i) {
            this.assignEdge(dungeon, i, beginZ);
            this.assignEdge(dungeon, i, endZ);
        }
        for (i = beginZ; i <= endZ; ++i) {
            this.assignEdge(dungeon, beginX, i);
            this.assignEdge(dungeon, endX, i);
        }
        if (!dungeon.complexity.use(dungeon.random) && !this.isNode) {
            this.hasWholePattern = true;
            if (dungeon.liquids.use(dungeon.random)) {
                this.walkway(dungeon);
            } else if (!this.sky && (dungeon.complexity.use(dungeon.random) || dungeon.symmetry.use(dungeon.random))) {
                this.cutin(dungeon);
            }
        } else {
            this.addFeatures(dungeon);
        }
        this.doorways(dungeon);
        if (parent == null) {
            this.addSpawners(dungeon);
            this.addChests(dungeon);
        }
        if (this.hasEntrance) {
            for (i = (int)this.realX - 2; i < (int)this.realX + 2; ++i) {
                for (j = (int)this.realZ - 2; j < (int)this.realZ + 2; ++j) {
                    dungeon.map.floorY[i][j] = (byte)floorY;
                    dungeon.map.hasLiquid[i][j] = false;
                    dungeon.map.isWall[i][j] = false;
                }
            }
        }
    }

    private void assignEdge(Dungeon dungeon, int x, int z) {
        if (dungeon.map.room[x][z] == 0) {
            dungeon.map.room[x][z] = this.id;
        }
        if (dungeon.map.ceilY[x][z] < (byte)this.ceilY) {
            dungeon.map.ceilY[x][z] = (byte)this.ceilY;
        }
        if (dungeon.map.nCeilY[x][z] < (byte)this.ceilY) {
            dungeon.map.nCeilY[x][z] = (byte)this.ceilY;
        }
        if (dungeon.map.floorY[x][z] < (byte)this.floorY) {
            dungeon.map.floorY[x][z] = (byte)this.floorY;
        }
        if (dungeon.map.nFloorY[x][z] > (byte)this.nFloorY || dungeon.map.nFloorY[x][z] == 0) {
            dungeon.map.nFloorY[x][z] = (byte)this.floorY;
        }
        if (!this.sky) {
            dungeon.map.ceiling[x][z] = this.cielingBlock;
        }
        dungeon.map.floor[x][z] = this.floorBlock;
        dungeon.map.wall[x][z] = this.wallBlock1;
        dungeon.map.hasLiquid[x][z] = false;
        dungeon.map.isWall[x][z] = !this.sky;
        dungeon.map.isFence[x][z] = this.fenced;
    }

    public void addFeatures(Dungeon dungeon) {
        ArrayList<FeatureAdder> features = new ArrayList<FeatureAdder>();
        features.add(new IslandPlatform(dungeon.verticle));
        features.add(new Depression(dungeon.verticle));
        features.add(new Pool(dungeon.liquids));
        if (!this.sky) {
            features.add(new Cutout(dungeon.complexity));
            features.add(new Pillar(dungeon.pillars));
        }
        features.add(new IslandRoom(dungeon.islands));
        features.trimToSize();
        Collections.shuffle(features, dungeon.random);
        if (dungeon.complexity.value <= 0) {
            return;
        }
        int tries = (this.endX - this.beginX + this.endZ - this.beginZ) / (4 + this.sym.level);
        for (int i = 0; i <= tries; ++i) {
            FeatureAdder feat;
            Iterator i$ = features.iterator();
            while (i$.hasNext() && !(feat = (FeatureAdder)i$.next()).addFeature(dungeon, this)) {
            }
        }
    }

    public void addSpawners(Dungeon dungeon) {
        int lev;
        String mob;
        int y;
        int z;
        int x;
        if (ConfigHandler.difficulty == Difficulty.NONE || !this.isNode && !ConfigHandler.difficulty.addmob(dungeon.random) || this.hasEntrance) {
            return;
        }
        this.hasSpawners = true;
        if (ConfigHandler.difficulty.addmob(dungeon.random)) {
            int tmp = this.endX - this.beginX > this.endZ - this.beginZ ? this.endX - this.beginX : this.endZ - this.beginZ;
            int num = dungeon.random.nextInt(3 + tmp / 12) + 1;
            for (int i = 0; i < num; ++i) {
                tmp = this.endX - this.beginX - 1;
                x = dungeon.random.nextInt(tmp) + this.beginX + 1;
                tmp = this.endZ - this.beginZ - 1;
                z = dungeon.random.nextInt(tmp) + this.beginZ + 1;
                y = dungeon.random.nextInt(4) == 0 ? dungeon.map.ceilY[x][z] : dungeon.map.floorY[x][z];
                int lev2 = ConfigHandler.difficulty.moblevel(dungeon.random);
                mob = dungeon.theme.allMobs[lev2].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev2].size()));
                this.spawners.add(new Spawner(x, y, z, mob));
                if (this.level >= lev2) continue;
                this.level = lev2;
            }
            ++this.level;
        } else {
            int tmp = (this.endX - this.beginX) / 2;
            x = dungeon.random.nextInt(tmp) + this.beginX + tmp / 2;
            tmp = (this.endZ - this.beginZ) / 2;
            z = dungeon.random.nextInt(tmp) + this.beginZ + tmp / 2;
            y = dungeon.random.nextInt(4) == 0 ? dungeon.map.floorY[x][z] : dungeon.map.ceilY[x][z];
            lev = ConfigHandler.difficulty.moblevel(dungeon.random);
            mob = dungeon.theme.allMobs[lev].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev].size()));
            this.spawners.add(new Spawner(x, y, z, mob));
            this.level = lev;
        }
        if (this.isNode) {
            x = (int)this.realX;
            z = (int)this.realZ;
            y = dungeon.map.floorY[x][z] - 1;
            lev = ConfigHandler.difficulty.nodelevel(dungeon.random);
            mob = dungeon.theme.allMobs[lev].get(dungeon.random.nextInt(dungeon.theme.allMobs[lev].size()));
            this.spawners.add(new Spawner(x, y, z, mob));
            if (this.level < lev) {
                this.level = lev;
            }
            ++this.level;
        }
    }

    public void addChests(Dungeon dungeon) {
        byte y;
        int z;
        int x;
        if (ConfigHandler.difficulty == Difficulty.NONE || this.hasEntrance) {
            return;
        }
        if (!this.hasSpawners && dungeon.random.nextInt(5) > 0) {
            return;
        }
        if (!this.hasSpawners) {
            int tmp = this.endX - this.beginX - 1;
            x = dungeon.random.nextInt(tmp) + this.beginX + 1;
            tmp = this.endZ - this.beginZ - 1;
            z = dungeon.random.nextInt(tmp) + this.beginZ + 1;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new WeakChest(x, y, z));
        } else if (dungeon.random.nextBoolean()) {
            int tmp = this.endX - this.beginX - 1;
            x = dungeon.random.nextInt(tmp) + this.beginX + 1;
            tmp = this.endZ - this.beginZ - 1;
            z = dungeon.random.nextInt(tmp) + this.beginZ + 1;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new BasicChest(x, y, z, this.level));
        } else {
            int num = dungeon.random.nextInt(2 + this.spawners.size() / 2) + 1;
            for (int i = 0; i < num; ++i) {
                int tmp = this.endX - this.beginX - 1;
                x = dungeon.random.nextInt(tmp) + this.beginX + 1;
                tmp = this.endZ - this.beginZ - 1;
                z = dungeon.random.nextInt(tmp) + this.beginZ + 1;
                y = dungeon.map.floorY[x][z];
                this.chests.add(new BasicChest(x, y, z, this.level));
            }
        }
        if (this.isNode) {
            x = (int)this.realX;
            z = (int)this.realZ;
            y = dungeon.map.floorY[x][z];
            this.chests.add(new TreasureChest(x, y, z, this.level));
        }
    }

    public boolean islandSubroom(Dungeon dungeon) {
        int dimX = (int)((float)(this.endX - this.beginX) * (0.2f + 0.3f * dungeon.random.nextFloat()));
        int dimZ = (int)((float)(this.endZ - this.beginZ) * (0.2f + 0.3f * dungeon.random.nextFloat()));
        float centerX = dungeon.random.nextInt(this.endX - this.beginX) + this.beginX;
        float centerZ = dungeon.random.nextInt(this.endZ - this.beginZ) + this.beginZ;
        float oppX = (float)this.endX - (centerX - (float)this.beginX);
        float oppZ = (float)this.endZ - (centerZ - (float)this.beginZ);
        if (this.sym.halfX) {
            dimX *= 2;
            dimX /= 3;
            oppX = (float)this.endX - (centerX - (float)this.beginX) / 2.0f;
            centerX = (centerX - (float)this.beginX) / 2.0f + (float)this.beginX;
        }
        if (this.sym.halfZ) {
            dimZ *= 2;
            dimZ /= 3;
            oppZ = (float)this.endZ - (centerZ - (float)this.beginZ) / 2.0f;
            centerZ = (centerZ - (float)this.beginZ) / 2.0f + (float)this.beginZ;
        }
        if (this.sym.doubler) {
            dimX = (int)((double)dimX * 0.75);
            dimZ = (int)((double)dimZ * 0.75);
        }
        if (dimX < 5 || dimZ < 5) {
            return false;
        }
        int ymod = dimX <= dimZ ? (int)Math.sqrt(dimX) : (int)Math.sqrt(dimZ);
        int height = dungeon.random.nextInt(dungeon.verticle.value / 2 + ymod + 1) + 2;
        Room created = new PlaceSeed((int)centerX, this.floorY, (int)centerZ).growRoom(dimX, dimZ, height, dungeon, this, this);
        if (created == null) {
            return false;
        }
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                created = new PlaceSeed((int)oppX, this.floorY, (int)oppZ).growRoom(dimZ, dimX, height, dungeon, this, this);
                break;
            }
            case TR2: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                oppZ = (float)this.endZ - (oppZ - (float)this.beginZ);
                created = new PlaceSeed((int)oppX, this.floorY, (int)oppZ).growRoom(dimZ, dimX, height, dungeon, this, this);
                break;
            }
            case X: {
                created = new PlaceSeed((int)oppX, this.floorY, (int)centerZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                break;
            }
            case Y: {
                created = new PlaceSeed((int)centerX, this.floorY, (int)oppZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                break;
            }
            case XY: {
                created = new PlaceSeed((int)oppX, this.floorY, (int)centerZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                created = new PlaceSeed((int)centerX, this.floorY, (int)oppZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                created = new PlaceSeed((int)oppX, this.floorY, (int)oppZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                break;
            }
            case R: {
                created = new PlaceSeed((int)oppX, this.floorY, (int)oppZ).growRoom(dimX, dimZ, height, dungeon, this, this);
                break;
            }
            case SW: {
                float swX1 = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ1 = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                float swX2 = this.realX + (oppZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ2 = this.realZ + (oppX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                created = new PlaceSeed((int)swX2, this.floorY, (int)swZ1).growRoom(dimZ, dimX, height, dungeon, this, this);
                created = new PlaceSeed((int)swX1, this.floorY, (int)swZ2).growRoom(dimZ, dimX, height, dungeon, this, this);
                created = new PlaceSeed((int)oppX, this.floorY, (int)oppZ).growRoom(dimX, dimZ, height, dungeon, this, this);
            }
        }
        return true;
    }

    public void doorways(Dungeon dungeon) {
        int num = dungeon.random.nextInt(2 + (this.endX - this.beginX + this.endZ - this.beginZ) / (this.sym.level * 8 + 8) + dungeon.subrooms.value / (2 + this.sym.level)) + 1;
        for (int i = 0; i < num; ++i) {
            this.doorway(dungeon);
        }
    }

    public void doorway(Dungeon dungeon) {
        int oppZ;
        int z;
        int oppX;
        int x;
        int xExtend = 0;
        int zExtend = 0;
        int xSeedDir = 0;
        int zSeedDir = 0;
        int wall = dungeon.random.nextInt(4);
        switch (wall) {
            case 0: {
                x = this.beginX;
                oppX = this.endX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 1: {
                z = this.beginZ;
                oppZ = this.endZ;
                x = dungeon.random.nextInt(this.endX - this.beginX - 3) + 2;
                oppX = this.endX - x;
                x += this.beginX;
                xSeedDir = 0;
                zSeedDir = -1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 2: {
                x = this.endX;
                oppX = this.beginX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = 1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 3: {
                z = this.endZ;
                oppZ = this.beginZ;
                x = dungeon.random.nextInt(this.endX - this.beginX - 3) + 2;
                oppX = this.endX - x;
                x += this.beginX;
                xSeedDir = 0;
                zSeedDir = 1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            default: {
                x = this.beginX;
                oppX = this.endX;
                z = dungeon.random.nextInt(this.endZ - this.beginZ - 3) + 2;
                oppZ = this.endZ - z;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
            }
        }
        dungeon.map.isDoor[x][z] = true;
        dungeon.map.isDoor[x + xExtend][z + zExtend] = true;
        this.childSeeds.add(new PlaceSeed(x + xSeedDir, this.floorY, z + zSeedDir));
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = (int)(this.realX + ((float)z - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX));
                if (oppX < 1) {
                    oppX = 1;
                }
                if (oppX > dungeon.size.width - 2) {
                    oppX = dungeon.size.width - 2;
                }
                if ((oppZ = (int)(this.realZ + ((float)x - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ))) < 1) {
                    oppZ = 1;
                }
                if (oppZ > dungeon.size.width - 2) {
                    oppZ = dungeon.size.width - 2;
                }
                dungeon.map.isDoor[oppX][oppZ] = true;
                dungeon.map.isDoor[oppX + xExtend][oppZ + zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX + zSeedDir, this.floorY, oppZ + xSeedDir));
                break;
            }
            case TR2: {
                oppX = (int)(this.realX + ((float)z - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX));
                if (oppX < 1) {
                    oppX = 1;
                }
                if (oppX > dungeon.size.width - 2) {
                    oppX = dungeon.size.width - 2;
                }
                oppZ = (int)(this.realZ + ((float)x - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ));
                if ((oppZ = this.endZ - (oppZ - this.beginZ)) < 1) {
                    oppZ = 1;
                }
                if (oppZ > dungeon.size.width - 2) {
                    oppZ = dungeon.size.width - 2;
                }
                dungeon.map.isDoor[oppX][oppZ] = true;
                dungeon.map.isDoor[oppX + xExtend][oppZ + zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX + zSeedDir, this.floorY, oppZ - xSeedDir));
                break;
            }
            case X: {
                dungeon.map.isDoor[oppX][z] = true;
                dungeon.map.isDoor[oppX - xExtend][z + zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                break;
            }
            case Y: {
                dungeon.map.isDoor[x][oppZ] = true;
                dungeon.map.isDoor[x + xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case XY: {
                dungeon.map.isDoor[oppX][z] = true;
                dungeon.map.isDoor[oppX - xExtend][z + zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                dungeon.map.isDoor[x][oppZ] = true;
                dungeon.map.isDoor[x + xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                dungeon.map.isDoor[oppX][oppZ] = true;
                dungeon.map.isDoor[oppX - xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case R: {
                dungeon.map.isDoor[oppX][oppZ] = true;
                dungeon.map.isDoor[oppX - xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
                break;
            }
            case SW: {
                dungeon.map.isDoor[oppX][z] = true;
                dungeon.map.isDoor[oppX - xExtend][z + zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, z + zSeedDir));
                dungeon.map.isDoor[x][oppZ] = true;
                dungeon.map.isDoor[x + xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(x + xSeedDir, this.floorY, oppZ - zSeedDir));
                dungeon.map.isDoor[oppX][oppZ] = true;
                dungeon.map.isDoor[oppX - xExtend][oppZ - zExtend] = true;
                this.childSeeds.add(new PlaceSeed(oppX - xSeedDir, this.floorY, oppZ - zSeedDir));
            }
        }
    }

    public Room connector(Dungeon dungeon, int dir, int xdim, int zdim, int height, Route route) {
        int z;
        int x;
        route.roomNew = true;
        int xExtend = 0;
        int zExtend = 0;
        int xSeedDir = 0;
        int zSeedDir = 0;
        switch (dir) {
            case 2: {
                x = this.beginX;
                int oppX = this.endX;
                int oppZ = z = (int)this.realZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 3: {
                z = this.beginZ;
                int oppZ = this.endZ;
                int oppX = x = (int)this.realX;
                xSeedDir = 0;
                zSeedDir = -1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 0: {
                x = this.endX;
                int oppX = this.beginX;
                int oppZ = z = (int)this.realZ;
                xSeedDir = 1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            case 1: {
                z = this.endZ;
                int oppZ = this.beginZ;
                int oppX = x = (int)this.realX;
                xSeedDir = 0;
                zSeedDir = 1;
                xExtend = dungeon.random.nextInt(3) - 1;
                break;
            }
            default: {
                x = this.beginX;
                int oppX = this.endX;
                int oppZ = z = (int)this.realZ;
                z += this.beginZ;
                xSeedDir = -1;
                zSeedDir = 0;
                zExtend = dungeon.random.nextInt(3) - 1;
            }
        }
        dungeon.map.isDoor[x][z] = true;
        dungeon.map.isDoor[x + xExtend][z + zExtend] = true;
        if (x + xSeedDir >= dungeon.size.width || x + xSeedDir < 0 || z + zSeedDir >= dungeon.size.width || z + zSeedDir < 0) {
            return null;
        }
        if (dungeon.map.room[x + xSeedDir][z + zSeedDir] != 0) {
            route.roomNew = false;
            return dungeon.rooms.get(dungeon.map.room[x + xSeedDir][z + zSeedDir]);
        }
        if (dir % 2 == 0) {
            return new PlaceSeed(x + xSeedDir, this.floorY, z + zSeedDir).growRoomZ(xdim, zdim, height, dungeon, null, this);
        }
        return new PlaceSeed(x + xSeedDir, this.floorY, z + zSeedDir).growRoomX(xdim, zdim, height, dungeon, null, this);
    }

    public void islandPlatform(Dungeon dungeon, boolean isDepression) {
        byte platY;
        int available = this.ceilY - this.floorY;
        if (available < 4) {
            return;
        }
        int rotation = dungeon.random.nextInt(4);
        float dimX = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.25f + 0.15f);
        float dimZ = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.25f + 0.15f);
        float centerX = dungeon.random.nextInt(this.endX - this.beginX - 1) + this.beginX + 1;
        float centerZ = dungeon.random.nextInt(this.endZ - this.beginZ - 1) + this.beginZ + 1;
        float oppX = (float)this.endX - (centerX - (float)this.beginX);
        float oppZ = (float)this.endZ - (centerZ - (float)this.beginZ);
        if (this.sym.halfX) {
            dimX *= 2.0f;
            dimX /= 3.0f;
            oppX = (float)this.endX - (centerX - (float)this.beginX) / 2.0f;
            centerX = (centerX - (float)this.beginX) / 2.0f + (float)this.beginX;
        }
        if (this.sym.halfZ) {
            dimZ *= 2.0f;
            dimZ /= 3.0f;
            oppZ = (float)this.endZ - (centerZ - (float)this.beginZ) / 2.0f;
            centerZ = (centerZ - (float)this.beginZ) / 2.0f + (float)this.beginZ;
        }
        if (this.sym.doubler) {
            dimX = (float)((double)dimX * 0.75);
            dimZ = (float)((double)dimZ * 0.75);
        }
        centerX += 1.0f;
        centerZ += 1.0f;
        oppX += 1.0f;
        oppZ += 1.0f;
        if (isDepression) {
            if ((available -= 2) > dungeon.verticle.value / 2 + 1) {
                available = dungeon.verticle.value / 2 + 1;
            }
            platY = (byte)(this.floorY - dungeon.random.nextInt(dungeon.verticle.value / 2 + 1) - 1);
        } else {
            platY = (byte)(this.floorY + 1 + dungeon.random.nextInt(2));
            if (available > 4) {
                platY = (byte)(platY + (byte)dungeon.random.nextInt(available - 3));
            }
        }
        Shape[] which = dungeon.random.nextBoolean() || !dungeon.complexity.use(dungeon.random) ? Shape.xgroup : Shape.allSolids[dungeon.random.nextInt(Shape.allSolids.length)];
        if (platY > this.nFloorY) {
            this.nFloorY = platY;
        }
        which[rotation].drawPlatform(dungeon, this, platY, centerX, centerZ, dimX, dimZ, false, false);
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 3) % 4].drawPlatform(dungeon, this, platY, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case TR2: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                oppZ = (float)this.endZ - (oppZ - (float)this.beginZ);
                which[(rotation + 3) % 4].drawPlatform(dungeon, this, platY, oppX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case X: {
                which[rotation].drawPlatform(dungeon, this, platY, oppX, centerZ, dimX, dimZ, true, false);
                break;
            }
            case Y: {
                which[rotation].drawPlatform(dungeon, this, platY, centerX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case XY: {
                which[rotation].drawPlatform(dungeon, this, platY, oppX, centerZ, dimX, dimZ, true, false);
                which[rotation].drawPlatform(dungeon, this, platY, centerX, oppZ, dimX, dimZ, false, true);
                which[rotation].drawPlatform(dungeon, this, platY, oppX, oppZ, dimX, dimZ, true, true);
                break;
            }
            case R: {
                which[(rotation + 2) % 4].drawPlatform(dungeon, this, platY, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case SW: {
                float swX1 = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ1 = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                float swX2 = this.realX + (oppZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ2 = this.realZ + (oppX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 1) % 4].drawPlatform(dungeon, this, platY, swX2, swZ1, dimX, dimZ, false, false);
                which[(rotation + 3) % 4].drawPlatform(dungeon, this, platY, swX1, swZ2, dimX, dimZ, false, false);
                which[(rotation + 2) % 4].drawPlatform(dungeon, this, platY, oppX, oppZ, dimX, dimZ, false, false);
            }
        }
    }

    public void pillar(Dungeon dungeon) {
        int pillarx1 = dungeon.random.nextInt(this.endX - this.beginX - 2) + 1;
        int pillarz1 = dungeon.random.nextInt(this.endZ - this.beginZ - 2) + 1;
        if (this.sym.halfX) {
            pillarx1 = (pillarx1 - 1) / 2 + 1;
        }
        if (this.sym.halfZ) {
            pillarz1 = (pillarz1 - 1) / 2 + 1;
        }
        int pillarx2 = this.endX - pillarx1;
        int pillarz2 = this.endZ - pillarz1;
        pillarx1 += this.beginX;
        pillarz1 += this.beginZ;
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarz1][pillarx1] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarz1][pillarx1] = this.pillarBlock;
                break;
            }
            case TR2: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarz1][pillarx1] = true;
                dungeon.map.wall[pillarx2][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarz2][pillarx1] = this.pillarBlock;
                break;
            }
            case X: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarx2][pillarz1] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz1] = this.pillarBlock;
                break;
            }
            case Y: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarx1][pillarz2] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx1][pillarz2] = this.pillarBlock;
                break;
            }
            case XY: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarx1][pillarz2] = true;
                dungeon.map.isWall[pillarx2][pillarz1] = true;
                dungeon.map.isWall[pillarx2][pillarz2] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx1][pillarz2] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz2] = this.pillarBlock;
                break;
            }
            case R: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarx2][pillarz2] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz2] = this.pillarBlock;
                break;
            }
            case SW: {
                dungeon.map.isWall[pillarx1][pillarz1] = true;
                dungeon.map.isWall[pillarx1][pillarz2] = true;
                dungeon.map.isWall[pillarx2][pillarz1] = true;
                dungeon.map.isWall[pillarx2][pillarz2] = true;
                dungeon.map.wall[pillarx1][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx1][pillarz2] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz1] = this.pillarBlock;
                dungeon.map.wall[pillarx2][pillarz2] = this.pillarBlock;
            }
        }
    }

    public void pool(Dungeon dungeon) {
        int rotation = dungeon.random.nextInt(4);
        float dimX = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.25f + 0.15f);
        float dimZ = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.25f + 0.15f);
        float centerX = dungeon.random.nextInt(this.endX - this.beginX - 1) + this.beginX + 1;
        float centerZ = dungeon.random.nextInt(this.endZ - this.beginZ - 1) + this.beginZ + 1;
        float oppX = (float)this.endX - (centerX - (float)this.beginX);
        float oppZ = (float)this.endZ - (centerZ - (float)this.beginZ);
        if (this.sym.halfX) {
            dimX *= 2.0f;
            dimX /= 3.0f;
            oppX = (float)this.endX - (centerX - (float)this.beginX) / 2.0f;
            centerX = (centerX - (float)this.beginX) / 2.0f + (float)this.beginX;
        }
        if (this.sym.halfZ) {
            dimZ *= 2.0f;
            dimZ /= 3.0f;
            oppZ = (float)this.endZ - (centerZ - (float)this.beginZ) / 2.0f;
            centerZ = (centerZ - (float)this.beginZ) / 2.0f + (float)this.beginZ;
        }
        if (this.sym.doubler) {
            dimX = (float)((double)dimX * 0.75);
            dimZ = (float)((double)dimZ * 0.75);
        }
        oppX += 1.0f;
        oppZ += 1.0f;
        Shape[] which = dungeon.random.nextBoolean() || !dungeon.complexity.use(dungeon.random) ? Shape.xgroup : Shape.allSolids[dungeon.random.nextInt(Shape.allSolids.length)];
        which[rotation].drawLiquid(dungeon, this, centerX += 1.0f, centerZ += 1.0f, dimX, dimZ, false, false);
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 1) % 4].drawLiquid(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case TR2: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                oppZ = (float)this.endZ - (oppZ - (float)this.beginZ);
                which[(rotation + 1) % 4].drawLiquid(dungeon, this, oppX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case X: {
                which[rotation].drawLiquid(dungeon, this, oppX, centerZ, dimX, dimZ, true, false);
                break;
            }
            case Y: {
                which[rotation].drawLiquid(dungeon, this, centerX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case XY: {
                which[rotation].drawLiquid(dungeon, this, oppX, centerZ, dimX, dimZ, true, false);
                which[rotation].drawLiquid(dungeon, this, centerX, oppZ, dimX, dimZ, false, true);
                which[rotation].drawLiquid(dungeon, this, oppX, oppZ, dimX, dimZ, true, true);
                break;
            }
            case R: {
                which[(rotation + 2) % 4].drawLiquid(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case SW: {
                float swX1 = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ1 = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                float swX2 = this.realX + (oppZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ2 = this.realZ + (oppX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 1) % 4].drawLiquid(dungeon, this, swX2, swZ1, dimX, dimZ, false, false);
                which[(rotation + 3) % 4].drawLiquid(dungeon, this, swX1, swZ2, dimX, dimZ, false, false);
                which[(rotation + 2) % 4].drawLiquid(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
            }
        }
    }

    public void cutout(Dungeon dungeon) {
        int rotation = dungeon.random.nextInt(4);
        float dimX = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.2f + 0.1f);
        float dimZ = (float)(this.endX - this.beginX) * (dungeon.random.nextFloat() * 0.2f + 0.1f);
        float centerX = dungeon.random.nextInt(this.endX - this.beginX - 1) + this.beginX + 1;
        float centerZ = dungeon.random.nextInt(this.endZ - this.beginZ - 1) + this.beginZ + 1;
        float oppX = (float)this.endX - (centerX - (float)this.beginX);
        float oppZ = (float)this.endZ - (centerZ - (float)this.beginZ);
        if (this.sym.halfX) {
            dimX *= 2.0f;
            dimX /= 3.0f;
            oppX = (float)this.endX - (centerX - (float)this.beginX) / 2.0f;
            centerX = (centerX - (float)this.beginX) / 2.0f + (float)this.beginX;
        }
        if (this.sym.halfZ) {
            dimZ *= 2.0f;
            dimZ /= 3.0f;
            oppZ = (float)this.endZ - (centerZ - (float)this.beginZ) / 2.0f;
            centerZ = (centerZ - (float)this.beginZ) / 2.0f + (float)this.beginZ;
        }
        if (this.sym.doubler) {
            dimX = (float)((double)dimX * 0.7);
            dimZ = (float)((double)dimZ * 0.7);
        }
        oppX += 1.0f;
        oppZ += 1.0f;
        Shape[] which = !dungeon.complexity.use(dungeon.random) ? Shape.xgroup : Shape.allSolids[dungeon.random.nextInt(Shape.allSolids.length)];
        which[rotation].drawCutout(dungeon, this, centerX += 1.0f, centerZ += 1.0f, dimX, dimZ, false, false);
        switch (this.sym) {
            case NONE: {
                break;
            }
            case TR1: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case TR2: {
                oppX = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                oppZ = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                oppZ = (float)this.endZ - (oppZ - (float)this.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, this, oppX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case X: {
                which[rotation].drawCutout(dungeon, this, oppX, centerZ, dimX, dimZ, true, false);
                break;
            }
            case Y: {
                which[rotation].drawCutout(dungeon, this, centerX, oppZ, dimX, dimZ, false, true);
                break;
            }
            case XY: {
                which[rotation].drawCutout(dungeon, this, oppX, centerZ, dimX, dimZ, true, false);
                which[rotation].drawCutout(dungeon, this, centerX, oppZ, dimX, dimZ, false, true);
                which[rotation].drawCutout(dungeon, this, oppX, oppZ, dimX, dimZ, true, true);
                break;
            }
            case R: {
                which[(rotation + 2) % 4].drawCutout(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
                break;
            }
            case SW: {
                float swX1 = this.realX + (centerZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ1 = this.realZ + (centerX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                float swX2 = this.realX + (oppZ - this.realZ) / (float)(this.endZ - this.beginZ) * (float)(this.endX - this.beginX);
                float swZ2 = this.realZ + (oppX - this.realX) / (float)(this.endX - this.beginX) * (float)(this.endZ - this.beginZ);
                which[(rotation + 1) % 4].drawCutout(dungeon, this, swX2, swZ1, dimX, dimZ, false, false);
                which[(rotation + 3) % 4].drawCutout(dungeon, this, swX1, swZ2, dimX, dimZ, false, false);
                which[(rotation + 2) % 4].drawCutout(dungeon, this, oppX, oppZ, dimX, dimZ, false, false);
            }
        }
    }

    private void walkway(Dungeon dungeon) {
        this.shape = Shapes.wholeShape(this.sym, dungeon.random);
        for (int i = this.beginX; i <= this.endX; ++i) {
            for (int j = this.beginZ; j <= this.endZ; ++j) {
                byte[] byArray = dungeon.map.floorY[i];
                int n = j;
                byArray[n] = (byte)(byArray[n] - 2);
                dungeon.map.hasLiquid[i][j] = true;
            }
        }
        this.shape.family[this.orientation].drawWalkway(dungeon, this, this.realX, this.realZ, (byte)(this.endX - this.beginX + 1), (byte)(this.endZ - this.beginZ + 1), this.XFlip, this.ZFlip);
    }

    private void cutin(Dungeon dungeon) {
        this.shape = Shapes.wholeShape(this.sym, dungeon.random);
        for (int i = this.beginX; i <= this.endX; ++i) {
            for (int j = this.beginZ; j <= this.endZ; ++j) {
                dungeon.map.isWall[i][j] = true;
            }
        }
        this.shape.family[this.orientation].drawCutin(dungeon, this, this.realX, this.realZ, (byte)(this.endX - this.beginX - 1), (byte)(this.endZ - this.beginZ - 1), this.XFlip, this.ZFlip);
    }

    public boolean plantChildren(Dungeon dungeon) {
        boolean result = false;
        for (PlaceSeed planted : this.childSeeds) {
            int ymod;
            int roomHeight;
            int zdim;
            int xdim;
            if (dungeon.rooms.size() >= dungeon.size.maxRooms) {
                return false;
            }
            int height = dungeon.baseHeight;
            int x = dungeon.random.nextInt(dungeon.size.width);
            int z = dungeon.random.nextInt(dungeon.size.width);
            if (height > dungeon.theme.maxY) {
                height = dungeon.baseHeight;
            }
            if (height < dungeon.theme.minY) {
                height = dungeon.baseHeight;
            }
            if (planted.growRoom(xdim, zdim, roomHeight = dungeon.random.nextInt(dungeon.verticle.value / 2 + (ymod = (xdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6) <= (zdim = dungeon.random.nextInt(dungeon.size.maxRoomSize - 5) + 6) ? (int)Math.sqrt(xdim) : (int)Math.sqrt(zdim)) + 1) + 2, dungeon, null, this) == null) continue;
            result = true;
        }
        return result;
    }
}

