/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.themes;

import jaredbgreat.dldungeons.themes.BiomeLists;
import jaredbgreat.dldungeons.themes.BlockList;
import jaredbgreat.dldungeons.themes.Element;
import jaredbgreat.dldungeons.themes.SizeElement;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraftforge.common.BiomeDictionary;

public class Theme {
    public String name;
    public static Theme classic;
    public static Theme nether;
    public static Theme end;
    public EnumSet<BiomeDictionary.Type> biomes = EnumSet.noneOf(BiomeDictionary.Type.class);
    public EnumSet<BiomeDictionary.Type> notIn = EnumSet.noneOf(BiomeDictionary.Type.class);
    public int minY;
    public int maxY;
    public boolean buildFoundation;
    public SizeElement sizes;
    public Element outside;
    public Element liquids;
    public Element subrooms;
    public Element islands;
    public Element pillars;
    public Element fences;
    public Element symmetry;
    public Element variability;
    public Element degeneracy;
    public Element complexity;
    public Element verticle;
    public Element entrances;
    public BlockList walls;
    public BlockList floors;
    public BlockList ceilings;
    public BlockList fencing;
    public BlockList liquid;
    public BlockList pillarBlock;
    public ArrayList<String> commonMobs;
    public ArrayList<String> hardMobs;
    public ArrayList<String> bruteMobs;
    public ArrayList<String> eliteMobs;
    public ArrayList<String>[] allMobs;

    public Theme(int minY, int maxY, boolean buildFoundation, SizeElement sizes, Element skies, Element liquids, Element subrooms, Element islands, Element pillars, Element fences, Element symmetry, Element variability, Element degeneracy, Element complexity, Element verticle, Element entrances, Element bigRooms, BlockList walls, BlockList floors, BlockList ceilings, BlockList stairs, BlockList stairSlabs, BlockList fencing, BlockList liquid, BlockList corner, BlockList windowContent, String[] mobs, String[] hardMobs) {
        int i;
        this.minY = minY;
        this.maxY = maxY;
        this.buildFoundation = buildFoundation;
        this.sizes = sizes;
        this.outside = skies;
        this.liquids = liquids;
        this.subrooms = subrooms;
        this.islands = islands;
        this.pillars = pillars;
        this.symmetry = symmetry;
        this.variability = variability;
        this.degeneracy = degeneracy;
        this.complexity = complexity;
        this.verticle = verticle;
        this.entrances = entrances;
        this.walls = walls;
        this.floors = floors;
        this.ceilings = ceilings;
        this.fencing = fencing;
        this.liquid = liquid;
        this.pillarBlock = corner;
        this.commonMobs = new ArrayList(mobs.length);
        this.hardMobs = new ArrayList(hardMobs.length);
        for (i = 0; i < mobs.length; ++i) {
            this.commonMobs.add(mobs[i]);
        }
        for (i = 0; i < hardMobs.length; ++i) {
            this.hardMobs.add(hardMobs[i]);
        }
    }

    public Theme() {
        int i;
        this.minY = 10;
        this.maxY = 50;
        this.buildFoundation = true;
        this.sizes = new SizeElement(2, 5, 10, 5, 1);
        this.outside = new Element(25, 0, 0, 0, 0, 0);
        this.liquids = new Element(1, 30, 50, 20, 10, 0);
        this.subrooms = new Element(20, 0, 50, 45, 5, 0);
        this.islands = new Element(5, 50, 10, 50, 20, 0);
        this.pillars = new Element(5, 30, 60, 40, 20, 0);
        this.symmetry = new Element(5, 15, 30, 75, 25, 0);
        this.variability = new Element(5, 10, 25, 75, 50, 25);
        this.degeneracy = new Element(50, 5, 15, 50, 10, 0);
        this.complexity = new Element(5, 10, 25, 75, 15, 0);
        this.verticle = new Element(5, 10, 25, 20, 10, 0);
        this.entrances = new Element(2, 5, 25, 50, 15, 3);
        this.fences = new Element(15, 25, 55, 15, 0, 0);
        this.walls = new BlockList(new String[]{"stonebrick", "cobblestone", "sandstone", "brick_block"});
        this.floors = new BlockList(new String[]{"stonebrick", "cobblestone", "dirt", "stone"});
        this.ceilings = new BlockList(new String[]{"stonebrick", "cobblestone", "planks", "double_stone_slab"});
        this.fencing = new BlockList(new String[]{"cobblestone_wall", "fence"});
        this.liquid = new BlockList(new String[]{"water", "lava"});
        this.pillarBlock = new BlockList(new String[]{"stonebrick", "cobblestone", "sandstone", "planks", "double_stone_slab"});
        String[] mobs = new String[]{"Zombie", "Skeleton", "Spider"};
        String[] hard = new String[]{"Creeper", "Enderman", "Witch", "CaveSpider"};
        this.commonMobs = new ArrayList(mobs.length);
        this.hardMobs = new ArrayList(hard.length);
        for (i = 0; i < mobs.length; ++i) {
            this.commonMobs.add(mobs[i]);
        }
        for (i = 0; i < hard.length; ++i) {
            this.hardMobs.add(hard[i]);
        }
    }

    public static void addDefaultTheme() {
        int i;
        classic = new Theme();
        classic.fixMobs();
        nether = new Theme();
        Theme.nether.minY = 32;
        Theme.nether.maxY = 64;
        Theme.nether.walls = new BlockList(new String[]{"nether_brick"});
        Theme.nether.floors = new BlockList(new String[]{"nether_brick"});
        Theme.nether.ceilings = new BlockList(new String[]{"nether_brick"});
        Theme.nether.liquid = new BlockList(new String[]{"lava"});
        Theme.nether.pillarBlock = new BlockList(new String[]{"nether_brick", "obsidian", "nether_brick", "obsidian", "quartz_block"});
        Theme.nether.fencing = new BlockList(new String[]{"nether_brick_fence"});
        Theme.nether.liquids = new Element(0, 0, 5, 85, 10, 0);
        Theme.nether.verticle = new Element(0, 0, 5, 55, 15, 0);
        Theme.nether.outside = new Element(5, 10, 15, 5, 0, 0);
        Theme.nether.pillars = new Element(5, 15, 10, 5, 0, 0);
        Theme.nether.degeneracy = new Element(10, 0, 0, 0, 0, 0);
        Theme.nether.entrances = new Element(10, 0, 0, 0, 0, 0);
        String[] mobs = new String[]{"LavaSlime", "PigZombie", "Blaze"};
        String[] hard = new String[]{"Blaze", "Skeleton"};
        Theme.nether.commonMobs = new ArrayList(mobs.length);
        Theme.nether.hardMobs = new ArrayList(hard.length);
        for (i = 0; i < mobs.length; ++i) {
            Theme.nether.commonMobs.add(mobs[i]);
        }
        for (i = 0; i < hard.length; ++i) {
            Theme.nether.hardMobs.add(hard[i]);
        }
        Theme.nether.bruteMobs = Theme.nether.hardMobs;
        Theme.nether.eliteMobs = new ArrayList();
        nether.fixMobs();
        end = new Theme();
        Theme.end.minY = 30;
        Theme.end.maxY = 60;
        Theme.end.walls = new BlockList(new String[]{"endstone"});
        Theme.end.floors = new BlockList(new String[]{"endstone"});
        Theme.end.ceilings = new BlockList(new String[]{"endstone"});
        Theme.end.liquid = new BlockList(new String[]{"air"});
        Theme.end.pillarBlock = new BlockList(new String[]{"endstone", "obsidian", "obsidian", "obsidian", "glowstone"});
        Theme.end.liquids = new Element(5, 0, 0, 0, 0, 0);
        Theme.end.verticle = new Element(0, 0, 5, 55, 15, 0);
        Theme.end.outside = new Element(5, 10, 15, 5, 0, 0);
        Theme.end.pillars = new Element(0, 5, 15, 10, 5, 0);
        Theme.end.degeneracy = new Element(10, 0, 0, 0, 0, 0);
        Theme.end.entrances = new Element(10, 0, 0, 0, 0, 0);
        Theme.end.commonMobs = new ArrayList(mobs.length);
        Theme.end.hardMobs = new ArrayList(hard.length);
        Theme.end.bruteMobs = new ArrayList(hard.length);
        Theme.end.eliteMobs = new ArrayList(hard.length);
        Theme.end.commonMobs.add("Enderman");
        Theme.end.hardMobs.add("Enderman");
        Theme.end.bruteMobs.add("Enderman");
        Theme.end.eliteMobs.add("WitherBoss");
        end.fixMobs();
    }

    public void fixMobs() {
        if (this.hardMobs == null) {
            this.hardMobs = this.commonMobs;
        } else if (this.hardMobs.isEmpty()) {
            this.hardMobs = this.commonMobs;
        }
        if (this.bruteMobs == null) {
            this.bruteMobs = this.hardMobs;
        } else if (this.bruteMobs.isEmpty()) {
            this.bruteMobs = this.hardMobs;
        }
        if (this.eliteMobs == null) {
            this.eliteMobs = this.bruteMobs;
        } else if (this.eliteMobs.isEmpty()) {
            this.eliteMobs = this.bruteMobs;
        }
        this.allMobs = new ArrayList[4];
        this.allMobs[0] = this.commonMobs;
        this.allMobs[1] = this.hardMobs;
        this.allMobs[2] = this.bruteMobs;
        this.allMobs[3] = this.eliteMobs;
    }

    public void biomeRegister() {
        BiomeLists.registerTheme(this);
        BiomeLists.removeTheme(this);
    }

    public String toString() {
        if (this.name == null) {
            return "null";
        }
        return this.name;
    }
}

