/*
 * Decompiled with CFR 0.152.
 */
package ssr.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import ssr.SSRCore;

public class SoulConfig {
    public static boolean allowModMobs;
    public static boolean autoID;
    public static boolean disallowMobs;
    public static boolean canAbsorbSpawners;
    public static boolean easyVanillaAbsorb;
    public static boolean requireOwnerOnline;
    public static int vanillaBonus;
    public static int soulShardID;
    public static int soulCageID;
    public static int soulStealerID;
    public static int soulStealerWeight;
    public static int maxNumSpawns;
    public static int[] coolDown;
    public static int[] numMobs;
    public static int[] killReq;
    public static boolean[] enableRS;
    public static boolean[] needPlayer;
    public static boolean[] checkLight;
    public static boolean[] otherWorlds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        Configuration config = new Configuration(configFile);
        try {
            int i;
            config.load();
            autoID = config.get("IDs", "Enable the mod's dynamic ID system", true).getBoolean(true);
            disallowMobs = config.get("Misc", "Set soul shards to accept only peaceful mobs (will be ignored if set to allow non vanilla mobs)", false).getBoolean(false);
            canAbsorbSpawners = config.get("Misc", "Allow levelling up shards by absorbing vanilla spawners", true).getBoolean(true);
            easyVanillaAbsorb = config.get("Misc", "Allow absorbing of vanilla spawners even if the entity in the spawner is not equal to the entity bound to the shard", false).getBoolean(false);
            requireOwnerOnline = config.get("Misc", "Require the owner of the Soul Cage to be online for it to spawn mobs", false).getBoolean(false);
            vanillaBonus = config.get("Misc", "Bonus amount from absorbing a vanilla spawner", 200).getInt(200);
            maxNumSpawns = config.get("Misc", "The max amount of mobs spawned by Soul Cages that can be alive at once (setting this to 0 sets it to unlimited)", 80).getInt(80);
            allowModMobs = config.get("Misc", "Allow non vanilla mobs", true).getBoolean(true);
            soulShardID = config.get("IDs", "Soul Shard item ID (ignored if dynamic ID system is on)", 4097).getInt(4097);
            soulCageID = config.get("IDs", "Soul Cage block ID (ignored if dynamic ID system is on)", 1000).getInt(1000);
            soulStealerID = config.get("IDs", "Soul Stealer enchant ID", 85).getInt();
            soulStealerWeight = config.get("Misc", "The weight (probability) of the Soul Stealer enchant", 5).getInt(5);
            SoulConfig.coolDown[0] = config.get("Tier 1 Settings", "Cool-down (in seconds)", 20).getInt(20);
            SoulConfig.numMobs[0] = config.get("Tier 1 Settings", "Number of mobs to spawn", 2).getInt(2);
            SoulConfig.enableRS[0] = config.get("Tier 1 Settings", "Responds to redstone signal", false).getBoolean(false);
            SoulConfig.needPlayer[0] = config.get("Tier 1 Settings", "Needs a player within 16 blocks", true).getBoolean(true);
            SoulConfig.checkLight[0] = config.get("Tier 1 Settings", "Check if light level is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.otherWorlds[0] = config.get("Tier 1 Settings", "Check if the dimension is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.killReq[0] = config.get("Tier 1 Settings", "Amount of kills required", 64).getInt(64);
            SoulConfig.coolDown[1] = config.get("Tier 2 Settings", "Cool-down (in seconds)", 10).getInt(10);
            SoulConfig.numMobs[1] = config.get("Tier 2 Settings", "Number of mobs to spawn", 4).getInt(4);
            SoulConfig.enableRS[1] = config.get("Tier 2 Settings", "Responds to redstone signal", false).getBoolean(false);
            SoulConfig.needPlayer[1] = config.get("Tier 2 Settings", "Needs a player within 16 blocks", true).getBoolean(true);
            SoulConfig.checkLight[1] = config.get("Tier 2 Settings", "Check if light level is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.otherWorlds[1] = config.get("Tier 2 Settings", "Check if the dimension is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.killReq[1] = config.get("Tier 2 Settings", "Amount of kills required (must be larger than Tier 1 requirement)", 128).getInt(128);
            SoulConfig.coolDown[2] = config.get("Tier 3 Settings", "Cool-down (in seconds)", 5).getInt(5);
            SoulConfig.numMobs[2] = config.get("Tier 3 Settings", "Number of mobs to spawn", 4).getInt(4);
            SoulConfig.enableRS[2] = config.get("Tier 3 Settings", "Responds to redstone signal", false).getBoolean(false);
            SoulConfig.needPlayer[2] = config.get("Tier 3 Settings", "Needs a player within 16 blocks", false).getBoolean(false);
            SoulConfig.checkLight[2] = config.get("Tier 3 Settings", "Check if light level is appropriate for the Mob", false).getBoolean(false);
            SoulConfig.otherWorlds[2] = config.get("Tier 3 Settings", "Check if the dimension is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.killReq[2] = config.get("Tier 3 Settings", "Amount of kills required (must be larger than Tier 2 requirement)", 256).getInt(256);
            SoulConfig.coolDown[3] = config.get("Tier 4 Settings", "Cool-down (in seconds)", 5).getInt(5);
            SoulConfig.numMobs[3] = config.get("Tier 4 Settings", "Number of mobs to spawn", 4).getInt(4);
            SoulConfig.enableRS[3] = config.get("Tier 4 Settings", "Responds to redstone signal", false).getBoolean(false);
            SoulConfig.needPlayer[3] = config.get("Tier 4 Settings", "Needs a player within 16 blocks", false).getBoolean(false);
            SoulConfig.checkLight[3] = config.get("Tier 4 Settings", "Check if light level is appropriate for the Mob", true).getBoolean(true);
            SoulConfig.otherWorlds[3] = config.get("Tier 4 Settings", "Check if the dimension is appropriate for the Mob", false).getBoolean(false);
            SoulConfig.killReq[3] = config.get("Tier 4 Settings", "Amount of kills required (must be larger than Tier 3 requirement)", 512).getInt(512);
            SoulConfig.coolDown[4] = config.get("Tier 5 Settings", "Cool-down (in seconds)", 2).getInt(2);
            SoulConfig.numMobs[4] = config.get("Tier 5 Settings", "Number of mobs to spawn", 6).getInt(6);
            SoulConfig.enableRS[4] = config.get("Tier 5 Settings", "Responds to redstone signal", true).getBoolean(true);
            SoulConfig.needPlayer[4] = config.get("Tier 5 Settings", "Needs a player within 16 blocks", false).getBoolean(false);
            SoulConfig.checkLight[4] = config.get("Tier 5 Settings", "Check if light level is appropriate for the Mob", false).getBoolean(false);
            SoulConfig.otherWorlds[4] = config.get("Tier 5 Settings", "Check if the dimension is appropriate for the Mob", false).getBoolean(false);
            SoulConfig.killReq[4] = config.get("Tier 5 Settings", "Amount of kills required (must be larger than Tier 4 requirement)", 1024).getInt(1024);
            if (maxNumSpawns > 150) {
                maxNumSpawns = 80;
            }
            for (i = 0; i < coolDown.length; ++i) {
                if (coolDown[i] < 2) {
                    SoulConfig.coolDown[i] = 2;
                }
                if (coolDown[i] <= 60) continue;
                SoulConfig.coolDown[i] = 60;
            }
            for (i = 0; i < numMobs.length; ++i) {
                if (numMobs[i] < 1) {
                    SoulConfig.numMobs[i] = 1;
                }
                if (numMobs[i] <= 6) continue;
                SoulConfig.numMobs[i] = 6;
            }
            if (soulStealerWeight > 10 || soulStealerWeight < 1) {
                soulStealerWeight = 5;
            }
            SSRCore.SoulLog.info("Loaded Main configuration file.");
        }
        catch (Exception e) {
            SSRCore.SoulLog.warn("Soul-Shards Reborn had a problem loading it's configuration files.");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        coolDown = new int[5];
        numMobs = new int[5];
        killReq = new int[5];
        enableRS = new boolean[5];
        needPlayer = new boolean[5];
        checkLight = new boolean[5];
        otherWorlds = new boolean[5];
    }
}

