/*
 * Decompiled with CFR 0.152.
 */
package ssr.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import ssr.gameObjs.ObjHandler;
import ssr.utils.EntityWhitelist;
import ssr.utils.InvUtils;
import ssr.utils.TierHandling;

public class PlayerKill {
    @SubscribeEvent
    public void killEvent(LivingDeathEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayerMP && event.entityLiving instanceof EntityLiving) {
            String localization;
            EntitySkeleton skele;
            EntityLiving ent = (EntityLiving)event.entityLiving;
            EntityPlayerMP player = (EntityPlayerMP)event.source.func_76346_g();
            String mobName = ent.func_70005_c_();
            if (mobName.equals("Skeleton") && ent instanceof EntitySkeleton && (skele = (EntitySkeleton)ent).func_82202_m() == 1) {
                mobName = "Wither Skeleton";
            }
            if ((localization = LanguageRegistry.instance().getStringLocalization(mobName)) != null && !localization.isEmpty()) {
                mobName = localization;
            }
            String mobId = EntityList.func_75621_b((Entity)ent);
            if (EntityWhitelist.isEntityAccepted(mobName) && !ent.getEntityData().func_74767_n("fromSSR")) {
                if (!InvUtils.HasShard(player, mobName)) {
                    return;
                }
                ItemStack stack = InvUtils.getStack(player, mobName);
                if (stack != null && !stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.field_77990_d.func_74778_a("EntityType", "empty");
                    stack.field_77990_d.func_74768_a("EntityID", 0);
                    stack.field_77990_d.func_74768_a("KillCount", 0);
                    stack.field_77990_d.func_74768_a("Tier", 0);
                    stack.field_77990_d.func_74778_a("entId", "empty");
                }
                if (stack.field_77990_d.func_74779_i("EntityType").equals("empty")) {
                    stack.field_77990_d.func_74778_a("EntityType", mobName);
                    stack.field_77990_d.func_74778_a("entId", mobId);
                    ItemStack heldItem = ent.func_71124_b(0);
                    if (!(mobName.equals("Zombie") && mobName.equals("Enderman") || heldItem == null)) {
                        stack.field_77990_d.func_74757_a("HasItem", true);
                        NBTTagCompound nbt2 = new NBTTagCompound();
                        heldItem.func_77955_b(nbt2);
                        stack.field_77990_d.func_74782_a("Item", (NBTBase)nbt2);
                    }
                }
                String name = stack.field_77990_d.func_74779_i("EntityType");
                int kills = stack.field_77990_d.func_74762_e("KillCount");
                if (mobName.equals(name) && kills < TierHandling.getMax(5)) {
                    if (stack.func_77960_j() == 0) {
                        stack.func_77964_b(1);
                    }
                    kills = (kills += this.getSoulBonus(player.func_70694_bm()) + 1) > TierHandling.getMax(5) ? TierHandling.getMax(5) : kills;
                    stack.field_77990_d.func_74768_a("KillCount", kills);
                }
            }
        }
    }

    private int getSoulBonus(ItemStack stack) {
        return stack == null ? 0 : EnchantmentHelper.func_77506_a((int)ObjHandler.sStealer.field_77352_x, (ItemStack)stack);
    }
}

