/*
 * Decompiled with CFR 0.152.
 */
package ssr.gameObjs;

import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import ssr.SSRCore;
import ssr.config.SoulConfig;
import ssr.gameObjs.ObjHandler;

public class CageTile
extends TileEntity
implements IInventory {
    int maxMobs;
    int timer;
    int timer2;
    int timerEnd;
    public int tier;
    public String entName;
    public String entId;
    public String owner;
    public boolean isPowered;
    public boolean flag;
    public boolean hasFailed;
    private boolean hasLoaded;
    public ItemStack HeldItem;
    public ItemStack inventory;

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Tier", this.tier);
        if (this.entName != null && !this.entName.isEmpty()) {
            nbt.func_74778_a("Entity", this.entName);
        }
        if (this.entId != null && !this.entId.isEmpty()) {
            nbt.func_74778_a("entId", this.entId);
        }
        if (this.owner != null && !this.owner.isEmpty()) {
            nbt.func_74778_a("Owner", this.owner);
        }
        nbt.func_74757_a("Power", this.isPowered);
        if (this.HeldItem != null) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.HeldItem.func_77955_b(nbt2);
            nbt.func_74782_a("Item", (NBTBase)nbt2);
        }
        if (this.inventory != null) {
            NBTTagCompound nbt3 = new NBTTagCompound();
            this.inventory.func_77955_b(nbt3);
            nbt.func_74782_a("Inventory", (NBTBase)nbt3);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tier = nbt.func_74762_e("Tier");
        this.entName = nbt.func_74779_i("Entity");
        this.entId = nbt.func_74779_i("entId");
        this.owner = nbt.func_74779_i("Owner");
        this.isPowered = nbt.func_74767_n("Power");
        this.HeldItem = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
        this.inventory = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Inventory"));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void SendUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.hasFailed || this.field_145850_b.field_72995_K) {
            return;
        }
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.inventory == null) {
            if (this.hasLoaded) {
                this.ClearData();
                this.hasLoaded = false;
            }
            this.adjustMetadata(metadata, 0);
            return;
        }
        if (!this.hasLoaded) {
            this.LoadNbtData();
            if (this.tier == 0 || this.entName.equals("empty") || this.entName.isEmpty()) {
                SSRCore.SoulLog.fatal("Soul Cage failed to load NBT Data, invalidating tile entity.");
                this.hasFailed = true;
                return;
            }
            this.maxMobs = SoulConfig.numMobs[this.tier - 1];
            this.timerEnd = this.SecToTick(SoulConfig.coolDown[this.tier - 1]);
            this.adjustMetadata(metadata, 1);
        }
        if (this.timer == 20) {
            this.timer = 0;
            if (SoulConfig.requireOwnerOnline && this.owner != null && !this.owner.isEmpty() && !this.isOwnerOnline()) {
                this.flag = false;
                this.adjustMetadata(metadata, 1);
                return;
            }
            EntityLiving tempEnt = null;
            if (this.entName.equals("Wither Skeleton")) {
                EntitySkeleton skele = new EntitySkeleton(this.field_145850_b);
                skele.func_82201_a(1);
                tempEnt = skele;
            } else {
                tempEnt = (EntityLiving)EntityList.func_75620_a((String)this.entId, (World)this.field_145850_b);
            }
            if (tempEnt != null) {
                this.flag = SoulConfig.enableRS[this.tier - 1] ? this.isPowered : true;
                if (this.flag) {
                    boolean bl = this.flag = !this.hasReachedSpawnLimit(tempEnt) || SoulConfig.maxNumSpawns == 0;
                    if (SoulConfig.needPlayer[this.tier - 1] && this.flag) {
                        this.flag = this.isPlayerClose(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (SoulConfig.checkLight[this.tier - 1] && this.flag) {
                        this.flag = this.canSpawnInLight(tempEnt, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (SoulConfig.otherWorlds[this.tier - 1] && this.flag) {
                        this.flag = this.canSpawnInWorld(tempEnt);
                    }
                }
                if (this.flag) {
                    this.adjustMetadata(1, 2);
                } else {
                    this.adjustMetadata(2, 1);
                }
                tempEnt = null;
            }
        } else {
            ++this.timer;
        }
        if (this.timer2 == this.timerEnd) {
            this.timer2 = 0;
            if (this.flag) {
                int i;
                EntityLiving[] entity = new EntityLiving[this.maxMobs];
                for (i = 0; i < entity.length; ++i) {
                    if (this.entName.equals("Wither Skeleton")) {
                        EntitySkeleton skele = new EntitySkeleton(this.field_145850_b);
                        skele.func_82201_a(1);
                        entity[i] = skele;
                        continue;
                    }
                    entity[i] = (EntityLiving)EntityList.func_75620_a((String)this.entId, (World)this.field_145850_b);
                }
                this.SpawnAlgo(entity);
                for (i = 0; i < entity.length; ++i) {
                    if (entity[i].field_70128_L) continue;
                    if (entity[i] instanceof EntitySlime) {
                        entity[i].func_70096_w().func_75692_b(16, (Object)new Byte(1));
                    }
                    entity[i].getEntityData().func_74757_a("fromSSR", true);
                    entity[i].field_98038_p = true;
                    entity[i].func_110163_bv();
                    if (this.HeldItem != null) {
                        entity[i].func_70062_b(0, this.HeldItem);
                    }
                    this.field_145850_b.func_72838_d((Entity)entity[i]);
                }
            }
        } else {
            ++this.timer2;
        }
    }

    private void LoadNbtData() {
        NBTTagCompound nbt = this.inventory.field_77990_d;
        this.entName = nbt.func_74779_i("EntityType");
        this.entId = nbt.func_74779_i("entId");
        this.tier = nbt.func_74762_e("Tier");
        if (nbt.func_74767_n("HasItem")) {
            this.HeldItem = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
        }
        this.hasLoaded = true;
        this.SendUpdate();
    }

    private void ClearData() {
        this.tier = 0;
        this.timer = 0;
        this.timer2 = 0;
        this.entName = "";
        this.entId = "";
        this.HeldItem = null;
        this.flag = false;
        this.hasFailed = false;
        this.isPowered = false;
        this.SendUpdate();
    }

    private void adjustMetadata(int currentMeta, int correctMeta) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (currentMeta != correctMeta) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, correctMeta, 2);
        }
    }

    private boolean isOwnerOnline() {
        if (!this.field_145850_b.field_72995_K) {
            Iterator iter = this.field_145850_b.field_73010_i.iterator();
            String[] names = MinecraftServer.func_71276_C().func_71213_z();
            if (names == null || names.length == 0) {
                return false;
            }
            return Arrays.asList(names).contains(this.owner);
        }
        return false;
    }

    private boolean isPlayerClose(int x, int y, int z) {
        return this.field_145850_b.func_72977_a((double)x, (double)y, (double)z, 16.0) != null;
    }

    private boolean canSpawnInLight(EntityLiving ent, int x, int y, int z) {
        if (ent instanceof EntitySlime || ent instanceof EntityGhast || ent instanceof EntityPigZombie) {
            return true;
        }
        if (ent instanceof EntityMob) {
            float light = this.field_145850_b.func_72938_d(x >> 4, z >> 4).func_76629_c(x & 0xF, y, z & 0xF, this.field_145850_b.field_73008_k);
            return light <= 8.0f;
        }
        return true;
    }

    private boolean canSpawnInWorld(EntityLiving ent) {
        int dimension = this.field_145850_b.field_73011_w.field_76574_g;
        if (ent instanceof EntitySkeleton) {
            EntitySkeleton skele = (EntitySkeleton)ent;
            if (skele.func_82202_m() == 1 && dimension == -1) {
                return true;
            }
            return dimension == 0;
        }
        if (ent instanceof EntityBlaze || ent instanceof EntityPigZombie || ent instanceof EntityGhast || ent instanceof EntityMagmaCube) {
            return dimension == -1;
        }
        if (ent instanceof EntityEnderman) {
            return dimension == 1;
        }
        if (ent instanceof EntityMob || ent instanceof EntitySlime) {
            return dimension == 0;
        }
        return true;
    }

    private boolean canSpawnAtCoords(EntityLiving ent) {
        return this.field_145850_b.func_72945_a((Entity)ent, ent.field_70121_D).isEmpty();
    }

    private boolean hasReachedSpawnLimit(EntityLiving ent) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 16), (double)(this.field_145848_d - 16), (double)(this.field_145849_e - 16), (double)(this.field_145851_c + 16), (double)(this.field_145848_d + 16), (double)(this.field_145849_e + 16));
        Iterator entIter = this.field_145850_b.func_72872_a(ent.getClass(), aabb).iterator();
        int mobCount = 0;
        while (entIter.hasNext()) {
            EntityLiving entity = (EntityLiving)entIter.next();
            if (!entity.getEntityData().func_74767_n("fromSSR")) continue;
            ++mobCount;
        }
        return mobCount > SoulConfig.maxNumSpawns;
    }

    private int SecToTick(int seconds) {
        return seconds * 20;
    }

    private void SpawnAlgo(EntityLiving[] ents) {
        block0: for (int i = 0; i < ents.length; ++i) {
            int counter = 0;
            do {
                if (++counter >= 5) {
                    ents[i].func_70106_y();
                    continue block0;
                }
                double x = (double)this.field_145851_c + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
                double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
                double z = (double)this.field_145849_e + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
                ents[i].func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            } while (!this.canSpawnAtCoords(ents[i]) || counter >= 5);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (j == 0) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ObjHandler.sShard, 1, this.inventory.func_77960_j());
        stack.field_77990_d = this.inventory.func_77978_p();
        this.func_70299_a(i, null);
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inventory = stack;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (stack.func_77973_b() != ObjHandler.sShard || !stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound nbt = stack.field_77990_d;
        return this.inventory == null && nbt.func_74762_e("Tier") > 0 && !nbt.func_74779_i("EntityType").equals("empty");
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

