/*
 * Decompiled with CFR 0.152.
 */
package ssr.utils;

import ssr.SSRCore;
import ssr.config.SoulConfig;

public class TierHandling {
    private static final int[] defaultMin = new int[]{0, 64, 128, 256, 512, 1024};
    private static final int[] defaultMax = new int[]{63, 127, 255, 511, 1023, 1024};
    private static int[] min = new int[defaultMin.length];
    private static int[] max = new int[defaultMax.length];

    public static void init() {
        int i;
        boolean fault = false;
        TierHandling.min[0] = 0;
        for (i = 1; i < min.length; ++i) {
            TierHandling.min[i] = SoulConfig.killReq[i - 1];
            if (min[i] > min[i - 1]) continue;
            fault = true;
            break;
        }
        if (!fault) {
            for (i = 0; i < max.length; ++i) {
                TierHandling.max[i] = i == max.length - 1 ? min[i] : min[i + 1] - 1;
            }
        } else {
            for (i = 0; i < min.length; ++i) {
                if (i != 0) {
                    TierHandling.min[i] = defaultMin[i];
                }
                TierHandling.max[i] = defaultMax[i];
            }
        }
        SSRCore.SoulLog.info("Loaded custom tier settings.");
        if (fault) {
            SSRCore.SoulLog.fatal("Custom tier settings are not accepted. Resetting defaults..");
        }
        for (i = 0; i < min.length; ++i) {
            SSRCore.SoulLog.info("Tier: " + i);
            SSRCore.SoulLog.info(min[i] + ":" + max[i]);
        }
    }

    public static int getMin(int tier) {
        return min[tier];
    }

    public static int getMax(int tier) {
        return max[tier];
    }

    public static boolean isInBounds(int tier, int kills) {
        return kills >= min[tier] && kills <= max[tier];
    }

    public static int updateTier(int kills) {
        for (int i = 0; i < min.length; ++i) {
            if (kills < min[i] || kills > max[i]) continue;
            return i;
        }
        return 0;
    }
}

