/*
 * Decompiled with CFR 0.152.
 */
package me.jophestus.JOPHWarn;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.jophestus.JOPHWarn.JOPHWarnListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class JOPHWarn
extends JavaPlugin {
    public static JOPHWarn plugin;
    Logger log = Logger.getLogger("Minecraft");
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;
    public final JOPHWarnListener Listener = new JOPHWarnListener(this);
    CommandSender warnedby = null;
    Player warnee = null;
    String reason = null;
    List<String> warnings = null;
    List<String> infractions = null;
    String rawName = null;
    String warnQueue = "";

    public void reloadCustomConfig() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.getDataFolder(), "warnings.yml");
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
        InputStream defConfigStream = this.getResource("warnings.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.customConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getCustomConfig() {
        if (this.customConfig == null) {
            this.reloadCustomConfig();
        }
        return this.customConfig;
    }

    public void saveCustomConfig() {
        if (this.customConfig == null || this.customConfigFile == null) {
            return;
        }
        try {
            this.getCustomConfig().save(this.customConfigFile);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save config to " + this.customConfigFile, ex);
        }
    }

    public void onEnable() {
        this.SetupConfig();
        this.loadConfiguration();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.Listener, (Plugin)this);
    }

    private void SetupConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    private void loadConfiguration() {
        this.getCustomConfig().options().copyDefaults(true);
        this.saveCustomConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int i;
        StringBuilder b;
        String dateNow;
        SimpleDateFormat formatter;
        Calendar currentDate;
        if (command.getName().equalsIgnoreCase("warn")) {
            if (sender.hasPermission("JOPHWarn.warn")) {
                currentDate = Calendar.getInstance();
                formatter = new SimpleDateFormat("dd/MMM HH:mm:ss");
                dateNow = formatter.format(currentDate.getTime());
                if (args.length == 0 || args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", You haven't provided enough arguments for this command.");
                    return false;
                }
                b = new StringBuilder();
                for (i = 1; i < args.length; ++i) {
                    if (i != 1) {
                        b.append(" ");
                    }
                    b.append(args[i]);
                }
                this.warnings = this.getCustomConfig().getStringList(args[0] + ".warnings");
                this.rawName = args[0];
                this.infractions = this.getCustomConfig().getStringList(this.rawName + ".infractions");
                this.reason = b.toString();
                this.warnedby = sender;
                int warningCount = this.warnings.size();
                this.warnee = Bukkit.getServer().getPlayer(args[0]);
                this.reloadCustomConfig();
                if (warningCount >= 1) {
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + args[0] + " already has 1 or more warnings. Would you like to issue an infraction instead? '/confim' to infract, '/deny' to warn");
                    sender.sendMessage("The previous warnings were for:");
                    this.reloadCustomConfig();
                    List warns = this.getCustomConfig().getStringList(args[0] + ".warnings");
                    for (String s : warns) {
                        sender.sendMessage(ChatColor.GOLD + s);
                        this.warnQueue = sender.getName();
                    }
                    return true;
                }
                if (this.warnee == null) {
                    OfflinePlayer offline = Bukkit.getServer().getOfflinePlayer(args[0]);
                    this.warnings.add(b.toString() + " - By: " + sender.getName() + " " + dateNow);
                    this.getCustomConfig().set(offline.getName() + "offline", this.warnings);
                    this.saveCustomConfig();
                    this.reloadCustomConfig();
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + args[0] + " is not online. The warning will be received when they logon");
                    this.warnings.clear();
                    return true;
                }
                this.warnUser();
                if (this.getConfig().getBoolean("notifyadmins", true)) {
                    for (Player plr : Bukkit.getServer().getOnlinePlayers()) {
                        if (!plr.hasPermission("JOPHWarn.notify") && !plr.isOp()) continue;
                        plr.sendMessage(this.warnee.getName() + ChatColor.GREEN + " Was warned by " + sender.getName() + " for:");
                        plr.sendMessage(ChatColor.GOLD + b.toString());
                    }
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
                return true;
            }
        }
        if (command.getName().equalsIgnoreCase("confirm")) {
            if (sender.hasPermission("JOPHWarn.warn")) {
                if (this.warnQueue.equals("")) {
                    sender.sendMessage("There's nothing to confirm.");
                    return true;
                }
                this.infractUser();
                this.warnQueue = "";
                return true;
            }
            sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
            return true;
        }
        if (command.getName().equalsIgnoreCase("deny")) {
            if (sender.hasPermission("JOPHWarn.warn")) {
                if (this.warnQueue.equals("")) {
                    sender.sendMessage("There's nothing to deny.");
                    return true;
                }
                this.warnUser();
                this.warnQueue = "";
                return true;
            }
            sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
            return true;
        }
        if (command.getName().equalsIgnoreCase("warnings")) {
            if (args.length < 2) {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "You have not provided enough arguments :(");
                return false;
            }
            if (sender.hasPermission("JOPHWarn.view")) {
                if (args[0].equalsIgnoreCase("view")) {
                    this.reloadCustomConfig();
                    List warns = this.getCustomConfig().getStringList(args[1] + ".warnings");
                    sender.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
                    sender.sendMessage(ChatColor.GREEN + "Viewing " + args[1] + "'s Warnings");
                    for (String s : warns) {
                        sender.sendMessage(ChatColor.GOLD + s);
                    }
                    sender.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
                    return true;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
                return true;
            }
            if (sender.hasPermission("JOPHWarn.warnings.clearall")) {
                if (args[0].equalsIgnoreCase("clear")) {
                    this.getCustomConfig().set(args[1] + ".warnings", null);
                    this.saveCustomConfig();
                    this.reloadCustomConfig();
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn]" + ChatColor.GREEN + " You have cleared " + args[1] + "'s warnings");
                    return true;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
                return true;
            }
        }
        if (command.getName().equalsIgnoreCase("infractions")) {
            if (args.length < 2) {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "You have not provided enough arguments :(");
                return false;
            }
            if (sender.hasPermission("JOPHWarn.infractions.view")) {
                if (args[0].equalsIgnoreCase("view")) {
                    this.reloadCustomConfig();
                    List infractions = this.getCustomConfig().getStringList(args[1] + ".infractions");
                    sender.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
                    sender.sendMessage(ChatColor.GREEN + "Viewing " + args[1] + "'s Infractions");
                    for (String s : infractions) {
                        sender.sendMessage(ChatColor.GOLD + s);
                    }
                    sender.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
                    return true;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
                return true;
            }
            if (sender.hasPermission("JOPHWarn.infractions.clearall")) {
                if (args[0].equalsIgnoreCase("clear")) {
                    this.getCustomConfig().set(args[1] + ".infractions", null);
                    this.saveCustomConfig();
                    this.reloadCustomConfig();
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn]" + ChatColor.GREEN + " You have cleared " + args[1] + "'s infractions");
                    return true;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
                return true;
            }
        }
        if (command.getName().equalsIgnoreCase("jophwarn")) {
            sender.sendMessage(ChatColor.RED + "[JOPHWarn]" + ChatColor.GREEN + " JOPHWarn, by JOPHESTUS & Drew1080. Version 2.0");
        }
        if (command.getName().equalsIgnoreCase("infract")) {
            if (sender.hasPermission("JOPHWarn.infract")) {
                currentDate = Calendar.getInstance();
                formatter = new SimpleDateFormat("dd/MMM HH:mm:ss");
                dateNow = formatter.format(currentDate.getTime());
                if (args.length == 0 || args.length == 1) {
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", You haven't provided enough arguments for this command.");
                    return false;
                }
                this.rawName = args[0];
                b = new StringBuilder();
                for (i = 1; i < args.length; ++i) {
                    if (i != 1) {
                        b.append(" ");
                    }
                    b.append(args[i]);
                }
                this.warnee = Bukkit.getServer().getPlayer(args[0]);
                this.reason = b.toString();
                this.warnedby = sender;
                this.infractions = this.getCustomConfig().getStringList(args[0] + ".infractions");
                if (this.warnee == null) {
                    OfflinePlayer offline = Bukkit.getServer().getOfflinePlayer(args[0]);
                    this.infractions.add(b.toString() + " - By: " + sender.getName() + " " + dateNow);
                    this.getCustomConfig().set(offline.getName() + "offline_infractions", this.infractions);
                    this.saveCustomConfig();
                    this.reloadCustomConfig();
                    sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + args[0] + " is not online. The infraction will be received when they logon");
                    this.infractions.clear();
                    return true;
                }
                if (this.getConfig().getBoolean("notifyadmins", true)) {
                    for (Player plr : Bukkit.getServer().getOnlinePlayers()) {
                        if (!plr.hasPermission("JOPHWarn.notify") && !plr.isOp()) continue;
                        plr.sendMessage(this.warnee.getName() + ChatColor.GREEN + " Was infracted by " + sender.getName() + " for:");
                        plr.sendMessage(ChatColor.GOLD + b.toString());
                    }
                }
                this.infractUser();
            } else {
                sender.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "I'm sorry " + sender.getName() + ", but you can't do that.");
            }
        }
        return super.onCommand(sender, command, label, args);
    }

    private void infractUser() {
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        int maxinfractions = this.getConfig().getInt("kickafter");
        int maxinfractionsBan = this.getConfig().getInt("banafter");
        int custom1 = this.getConfig().getInt("custom1infractions");
        int custom2 = this.getConfig().getInt("custom2infractions");
        int custom3 = this.getConfig().getInt("custom3infractions");
        int custom4 = this.getConfig().getInt("custom4infractions");
        int custom5 = this.getConfig().getInt("custom5infractions");
        int custom6 = this.getConfig().getInt("custom6infractions");
        String custom1command = this.getConfig().getString("custom1command");
        String custom2command = this.getConfig().getString("custom2command");
        String custom3command = this.getConfig().getString("custom3command");
        String custom4command = this.getConfig().getString("custom4command");
        String custom5command = this.getConfig().getString("custom5command");
        String custom6command = this.getConfig().getString("custom6command");
        custom1command = custom1command.replace("%p", this.warnee.getName());
        custom2command = custom2command.replace("%p", this.warnee.getName());
        custom3command = custom3command.replace("%p", this.warnee.getName());
        custom4command = custom4command.replace("%p", this.warnee.getName());
        custom5command = custom5command.replace("%p", this.warnee.getName());
        custom6command = custom6command.replace("%p", this.warnee.getName());
        custom1command = custom1command.replace("%w", this.reason);
        custom2command = custom2command.replace("%w", this.reason);
        custom3command = custom3command.replace("%w", this.reason);
        custom4command = custom4command.replace("%w", this.reason);
        custom5command = custom5command.replace("%w", this.reason);
        custom6command = custom6command.replace("%w", this.reason);
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM HH:mm:ss");
        String dateNow = formatter.format(currentDate.getTime());
        this.warnedby.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "Infraction sent to " + this.warnee.getName());
        this.warnee.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
        this.warnee.sendMessage(ChatColor.RED + "You have been infracted by " + ChatColor.BLUE + this.warnedby.getName() + ChatColor.RED + " for:");
        this.warnee.sendMessage(ChatColor.GREEN + this.reason);
        this.warnee.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
        this.infractions.add(this.reason + " - By: " + this.warnedby.getName() + " " + dateNow);
        this.getCustomConfig().set(this.warnee.getName() + ".infractions", this.infractions);
        this.saveCustomConfig();
        this.reloadCustomConfig();
        int infractionCount = this.infractions.size();
        this.infractions.clear();
        this.log.info("JOPHWarn:: " + this.warnedby.getName() + " infracted " + this.warnee.getName() + " for:");
        this.log.info("JOPHWarn:: " + this.reason);
        if (this.getConfig().getBoolean("enablekick") && infractionCount == maxinfractions) {
            this.warnee.kickPlayer(this.getConfig().getString("kickmessage"));
            this.log.info(this.warnee.getName() + " reached the max warnings amount and was kicked");
        }
        if (this.getConfig().getBoolean("enableban") && infractionCount == maxinfractionsBan) {
            Bukkit.getOfflinePlayer((String)this.rawName).setBanned(true);
            if (this.getServer().getPlayer(this.rawName) != null) {
                this.warnee.setBanned(true);
                this.warnee.kickPlayer(this.getConfig().getString("banmessage"));
                this.log.info(this.warnee.getName() + " reached the max warnings amount and was banned");
            }
        }
        if (this.getConfig().getBoolean("enablecustom1") && infractionCount == custom1) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom1command);
        }
        if (this.getConfig().getBoolean("enablecustom2") && infractionCount == custom2) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom2command);
        }
        if (this.getConfig().getBoolean("enablecustom3") && infractionCount == custom3) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom3command);
        }
        if (this.getConfig().getBoolean("enablecustom4") && infractionCount == custom4) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom4command);
        }
        if (this.getConfig().getBoolean("enablecustom5") && infractionCount == custom5) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom5command);
        }
        if (this.getConfig().getBoolean("enablecustom6") && infractionCount == custom6) {
            Bukkit.dispatchCommand((CommandSender)console, (String)custom6command);
        }
    }

    private void warnUser() {
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM HH:mm:ss");
        String dateNow = formatter.format(currentDate.getTime());
        this.warnedby.sendMessage(ChatColor.RED + "[JOPHWarn] " + ChatColor.GREEN + "Warning sent to " + this.warnee.getName());
        this.warnee.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
        this.warnee.sendMessage(ChatColor.RED + "You have been warned by " + ChatColor.BLUE + this.warnedby.getName() + ChatColor.RED + " for:");
        this.warnee.sendMessage(ChatColor.GREEN + this.reason);
        this.warnee.sendMessage(ChatColor.BLACK + "+++++++++++++++++++++++++++++++++++++++");
        this.warnings.add(this.reason + " - By: " + this.warnedby.getName() + " " + dateNow);
        this.getCustomConfig().set(this.warnee.getName() + ".warnings", this.warnings);
        this.saveCustomConfig();
        this.reloadCustomConfig();
        this.warnings.clear();
        this.log.info("JOPHWarn:: " + this.warnedby.getName() + " warned " + this.warnee.getName() + " for:");
        this.log.info("JOPHWarn:: " + this.reason);
    }
}

