/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.forge.GuiContainerManager;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemList {
    public static List<ItemStack> items = new ArrayList<ItemStack>();
    public static ListMultimap<Item, ItemStack> itemMap = ArrayListMultimap.create();
    private static boolean matching = false;
    private static boolean loading = false;
    private static boolean research = false;
    private static boolean reload = false;
    private static HashSet<Item> erroredItems = new HashSet();
    private static HashSet<String> stackTraces = new HashSet();

    public static ItemMatcher getSearchMatcher() {
        String matchstring = NEIClientConfig.getSearchExpression().toLowerCase();
        matchstring = matchstring.replace(".", "");
        matchstring = matchstring.replace("?", ".");
        matchstring = matchstring.replace("*", ".+?");
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(matchstring);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        if (pattern == null || pattern.toString().equals("")) {
            return new EverythingItemMatcher();
        }
        return new PatternItemMatcher(pattern);
    }

    public static boolean itemMatchesSearch(ItemStack item) {
        return ItemList.getSearchMatcher().matches(item);
    }

    public static boolean isMatching() {
        return matching;
    }

    public static void updateSearch() {
        if (matching) {
            research = true;
        } else {
            new ThreadMatchSearch().start();
        }
    }

    public static void loadItems() {
        if (loading) {
            reload = true;
        } else {
            new ThreadLoadItems().start();
        }
    }

    public static class ThreadLoadItems
    extends Thread
    implements IItemCounter {
        private Item item;

        public ThreadLoadItems() {
            super("NEI Item Loading Thread");
            loading = true;
        }

        @Override
        public Item getItem() {
            return this.item;
        }

        @Override
        public Thread getThread() {
            return this;
        }

        @Override
        public void run() {
            new ThreadLoadMonitor(this).start();
            block6: while (loading) {
                try {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    ArrayList<ItemStack> permutations = new ArrayList<ItemStack>();
                    ArrayListMultimap itemMap = ArrayListMultimap.create();
                    Iterator i$ = Item.field_150901_e.iterator();
                    while (i$.hasNext()) {
                        Item item;
                        this.item = item = (Item)i$.next();
                        if (reload) {
                            reload = false;
                            continue block6;
                        }
                        if (item == null || ItemInfo.isHidden(item)) continue;
                        permutations.clear();
                        permutations.addAll(ItemInfo.getItemOverrides(item));
                        if (permutations.isEmpty()) {
                            try {
                                item.func_150895_a(item, null, permutations);
                            }
                            catch (Exception e) {
                                System.err.println("Removing itemID: " + item + " from list.");
                                e.printStackTrace();
                                erroredItems.add(item);
                                continue;
                            }
                        }
                        if (permutations.isEmpty()) {
                            HashSet<String> damageIconSet = new HashSet<String>();
                            for (int damage = 0; damage < 16; ++damage) {
                                ItemStack itemstack = new ItemStack(item, 1, damage);
                                try {
                                    IIcon icon = item.func_77650_f(itemstack);
                                    String name = GuiContainerManager.concatenatedDisplayName(itemstack, false);
                                    String s = name + "@" + (icon == null ? 0 : icon.hashCode());
                                    if (damageIconSet.contains(s)) continue;
                                    damageIconSet.add(s);
                                    permutations.add(itemstack);
                                    continue;
                                }
                                catch (Throwable t) {
                                    StringWriter sw = new StringWriter();
                                    t.printStackTrace(new PrintWriter(sw));
                                    String stackTrace = itemstack + sw.toString();
                                    if (stackTraces.contains(stackTrace)) continue;
                                    System.err.println("NEI: Omitting #" + this.item + ":" + damage + " " + item.getClass().getSimpleName());
                                    t.printStackTrace();
                                    stackTraces.add(stackTrace);
                                }
                            }
                        }
                        Iterator it = permutations.iterator();
                        while (it.hasNext()) {
                            if (!ItemInfo.isHidden((ItemStack)it.next())) continue;
                            it.remove();
                        }
                        items.addAll(permutations);
                        itemMap.putAll((Object)item, permutations);
                    }
                    this.item = null;
                    ItemList.items = items;
                    ItemList.itemMap = itemMap;
                    if (reload) {
                        reload = false;
                        continue;
                    }
                    loading = false;
                }
                catch (TimeoutException e) {
                    System.err.println("Removing itemID: " + e.itemID + " from list.");
                    e.printStackTrace();
                    erroredItems.add(e.itemID);
                }
            }
            ItemList.updateSearch();
        }
    }

    public static class ThreadMatchSearch
    extends Thread
    implements IItemCounter {
        private Item item;

        public ThreadMatchSearch() {
            super("NEI Item Searching Thread");
            matching = true;
        }

        @Override
        public Item getItem() {
            return this.item;
        }

        @Override
        public Thread getThread() {
            return this;
        }

        @Override
        public void run() {
            block2: while (matching) {
                try {
                    ArrayList<ItemPanelStack> visibleitems = new ArrayList<ItemPanelStack>();
                    ItemMatcher matcher = ItemList.getSearchMatcher();
                    for (ItemStack stack : items) {
                        this.item = stack.func_77973_b();
                        if (research) {
                            research = false;
                            continue block2;
                        }
                        if (NEIClientConfig.bannedBlocks.contains(stack) || !matcher.matches(stack)) continue;
                        visibleitems.add(new ItemPanelStack(stack));
                    }
                    ItemPanel.visibleitems = visibleitems;
                }
                catch (TimeoutException e) {
                    System.err.println("Removing itemID: " + e.itemID + " from list.");
                    e.printStackTrace();
                    erroredItems.add(e.itemID);
                    ItemList.loadItems();
                }
                matching = false;
            }
        }
    }

    public static class ThreadLoadMonitor
    extends Thread {
        IItemCounter loadingThread;

        public ThreadLoadMonitor(IItemCounter handle) {
            super("NEI Load Monitor");
            this.loadingThread = handle;
        }

        @Override
        public void run() {
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        public final Item itemID;

        public TimeoutException(String msg, Item lastItem) {
            super(msg);
            this.itemID = lastItem;
        }
    }

    public static interface IItemCounter {
        public Item getItem();

        public Thread getThread();
    }

    private static class NothingItemMatcher
    implements ItemMatcher {
        private NothingItemMatcher() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return false;
        }
    }

    private static class EverythingItemMatcher
    implements ItemMatcher {
        private EverythingItemMatcher() {
        }

        @Override
        public boolean matches(ItemStack item) {
            return true;
        }
    }

    private static class PatternItemMatcher
    implements ItemMatcher {
        Pattern pattern;

        public PatternItemMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(ItemStack item) {
            return this.pattern.matcher(EnumChatFormatting.func_110646_a((String)GuiContainerManager.concatenatedDisplayName(item, true).toLowerCase())).find();
        }
    }

    private static interface ItemMatcher {
        public boolean matches(ItemStack var1);
    }
}

