/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackMap<T> {
    public static NBTTagCompound WILDCARD_TAG = new NBTTagCompound();
    protected HashMap<Item, DetailMap> itemMap = new HashMap();

    public static int getKeyType(int damage, NBTTagCompound tag) {
        int i = 0;
        if (ItemStackMap.isWildcard(damage)) {
            i = 1;
        }
        if (ItemStackMap.isWildcard(tag)) {
            i |= 2;
        }
        return i;
    }

    public static boolean isWildcard(int damage) {
        return damage == Short.MAX_VALUE;
    }

    public static boolean isWildcard(NBTTagCompound tag) {
        return tag != null && tag.func_74767_n("*");
    }

    public T get(ItemStack key) {
        if (key == null || key.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(key.func_77973_b());
        return map == null ? null : (T)map.get(key);
    }

    public void put(ItemStack key, T value) {
        if (key == null || key.func_77973_b() == null) {
            return;
        }
        DetailMap map = this.itemMap.get(key.func_77973_b());
        if (map == null) {
            map = new DetailMap();
            this.itemMap.put(key.func_77973_b(), map);
        }
        map.put(key, value);
    }

    public void clear() {
        this.itemMap.clear();
    }

    public T remove(ItemStack key) {
        if (key == null || key.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(key.func_77973_b());
        return map == null ? null : (T)map.remove(key);
    }

    public List<ItemStack> keys() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (Map.Entry<Item, DetailMap> entry : this.itemMap.entrySet()) {
            entry.getValue().addKeys(entry.getKey(), list);
        }
        return list;
    }

    public List<T> values() {
        LinkedList list = new LinkedList();
        for (DetailMap map : this.itemMap.values()) {
            map.addValues(list);
        }
        return list;
    }

    public List<Entry<T>> entries() {
        LinkedList<Entry<T>> list = new LinkedList<Entry<T>>();
        for (Map.Entry<Item, DetailMap> entry : this.itemMap.entrySet()) {
            entry.getValue().addEntries(entry.getKey(), list);
        }
        return list;
    }

    static {
        WILDCARD_TAG.func_74757_a("*", true);
    }

    public class DetailMap {
        public T wildcard;
        public HashMap<Integer, T> damageMap;
        public HashMap<NBTTagCompound, T> tagMap;
        public HashMap<StackMetaKey, T> metaMap;

        public T get(ItemStack key) {
            Object ret;
            if (this.wildcard != null) {
                return this.wildcard;
            }
            if (this.damageMap != null && (ret = this.damageMap.get(InventoryUtils.actualDamage((ItemStack)key))) != null) {
                return ret;
            }
            if (this.tagMap != null && (ret = this.tagMap.get(key.field_77990_d)) != null) {
                return ret;
            }
            if (this.metaMap != null) {
                return this.metaMap.get(new StackMetaKey(key));
            }
            return null;
        }

        public void put(ItemStack key, T value) {
            switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                case 0: {
                    if (this.metaMap == null) {
                        this.metaMap = new HashMap();
                    }
                    this.metaMap.put(new StackMetaKey(key), value);
                    break;
                }
                case 1: {
                    if (this.tagMap == null) {
                        this.tagMap = new HashMap();
                    }
                    this.tagMap.put(key.field_77990_d, value);
                    break;
                }
                case 2: {
                    if (this.damageMap == null) {
                        this.damageMap = new HashMap();
                    }
                    this.damageMap.put(InventoryUtils.actualDamage((ItemStack)key), value);
                    break;
                }
                case 3: {
                    this.wildcard = value;
                }
            }
        }

        public T remove(ItemStack key) {
            switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                case 0: {
                    return this.metaMap != null ? (Object)this.metaMap.remove(new StackMetaKey(key)) : null;
                }
                case 1: {
                    return this.tagMap != null ? (Object)this.tagMap.remove(key.field_77990_d) : null;
                }
                case 2: {
                    return this.damageMap != null ? (Object)this.damageMap.remove(InventoryUtils.actualDamage((ItemStack)key)) : null;
                }
                case 3: {
                    Object ret = this.wildcard;
                    this.wildcard = null;
                    return ret;
                }
            }
            return null;
        }

        public void addKeys(Item item, List<ItemStack> list) {
            if (this.wildcard != null) {
                list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)WILDCARD_TAG));
            }
            if (this.damageMap != null) {
                Iterator<Object> i$ = this.damageMap.keySet().iterator();
                while (i$.hasNext()) {
                    int damage = i$.next();
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)damage, (NBTTagCompound)WILDCARD_TAG));
                }
            }
            if (this.tagMap != null) {
                for (NBTTagCompound tag : this.tagMap.keySet()) {
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)tag));
                }
            }
            if (this.metaMap != null) {
                for (StackMetaKey key : this.metaMap.keySet()) {
                    list.add(InventoryUtils.newItemStack((Item)item, (int)1, (int)key.damage, (NBTTagCompound)key.tag));
                }
            }
        }

        public void addValues(LinkedList<T> list) {
            if (this.wildcard != null) {
                list.add(this.wildcard);
            }
            if (this.damageMap != null) {
                list.addAll(this.damageMap.values());
            }
            if (this.tagMap != null) {
                list.addAll(this.tagMap.values());
            }
            if (this.metaMap != null) {
                list.addAll(this.metaMap.values());
            }
        }

        public void addEntries(Item item, LinkedList<Entry<T>> list) {
            if (this.wildcard != null) {
                list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)WILDCARD_TAG), this.wildcard));
            }
            if (this.damageMap != null) {
                for (Map.Entry entry : this.damageMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)entry.getKey(), (NBTTagCompound)WILDCARD_TAG), entry.getValue()));
                }
            }
            if (this.tagMap != null) {
                for (Map.Entry entry : this.tagMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)((NBTTagCompound)entry.getKey())), entry.getValue()));
                }
            }
            if (this.metaMap != null) {
                for (Map.Entry entry : this.metaMap.entrySet()) {
                    list.add(new Entry(InventoryUtils.newItemStack((Item)item, (int)1, (int)((StackMetaKey)entry.getKey()).damage, (NBTTagCompound)((StackMetaKey)entry.getKey()).tag), entry.getValue()));
                }
            }
        }
    }

    public static class Entry<T> {
        public ItemStack key;
        public T value;

        public Entry(ItemStack key, T value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class StackMetaKey {
        public int damage;
        public NBTTagCompound tag;

        public StackMetaKey(int damage, NBTTagCompound tag) {
            this.damage = damage;
            this.tag = tag;
        }

        public StackMetaKey(ItemStack key) {
            this(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d);
        }

        public int hashCode() {
            return this.damage * 31 + Objects.hashCode(this.tag);
        }

        public boolean equals(Object o) {
            if (!(o instanceof StackMetaKey)) {
                return false;
            }
            StackMetaKey t = (StackMetaKey)o;
            return this.damage == t.damage && Objects.equals(this.tag, t.tag);
        }
    }
}

