/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiDraw;
import codechicken.core.gui.GuiScreenWidget;
import codechicken.core.gui.GuiScrollSlot;
import codechicken.core.gui.GuiWidget;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionList;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiOptionList
extends GuiScreenWidget {
    private final GuiScreen parent;
    private final OptionList optionList;
    private boolean world;
    private OptionScrollSlot slot;
    private GuiCCButton backButton;
    private GuiCCButton worldButton;

    public GuiOptionList(GuiScreen parent, OptionList optionList, boolean world) {
        this.parent = parent;
        this.optionList = optionList;
        this.world = world;
    }

    public void func_73866_w_() {
        this.xSize = this.field_146294_l;
        this.ySize = this.field_146295_m;
        super.func_73866_w_();
        if (this.slot != null) {
            this.slot.resize();
            this.backButton.width = Math.min(200, this.field_146294_l - 40);
            this.backButton.x = (this.field_146294_l - this.backButton.width) / 2;
            this.backButton.y = this.field_146295_m - 25;
            this.worldButton.width = 60;
            this.worldButton.x = this.field_146294_l - this.worldButton.width - 15;
        }
    }

    public void addWidgets() {
        this.slot = new OptionScrollSlot();
        this.add((GuiWidget)this.slot);
        this.backButton = new GuiCCButton(0, 0, 0, 20, StatCollector.func_74838_a((String)"nei.options.back")).setActionCommand("back");
        this.add((GuiWidget)this.backButton);
        this.worldButton = new GuiCCButton(0, 2, 0, 16, this.worldButtonName()).setActionCommand("world");
        this.add((GuiWidget)this.worldButton);
        this.func_73866_w_();
    }

    private String worldButtonName() {
        return StatCollector.func_74838_a((String)("nei.options." + (this.world ? "world" : "global")));
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("back")) {
            if (this.parent instanceof GuiOptionList) {
                ((GuiOptionList)this.parent).world = this.world;
            }
            GuiInfo.switchGui(this.parent);
        } else if (ident.equals("world")) {
            this.world = !this.world;
            this.worldButton.text = this.worldButtonName();
        }
    }

    public void drawBackground() {
        this.func_146276_q_();
    }

    public void drawForeground() {
        this.func_73732_a(GuiDraw.fontRenderer, StatCollector.func_74838_a((String)this.optionList.fullName()), this.field_146294_l / 2, 6, -1);
        this.drawTooltip();
    }

    private void drawTooltip() {
        List<String> tooltip = new LinkedList<String>();
        Point mouse = GuiDraw.getMousePosition();
        if (this.worldButton.pointInside(mouse.x, mouse.y)) {
            tooltip.addAll(Arrays.asList(StatCollector.func_74838_a((String)("nei.options.global.tip." + (this.world ? "1" : "0"))).split(":")));
        }
        tooltip = this.slot.handleTooltip(mouse.x, mouse.y, tooltip);
        GuiDraw.drawMultilineTip((int)(mouse.x + 12), (int)(mouse.y - 12), tooltip);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73869_a(char c, int keycode) {
        if (keycode == 1) {
            GuiScreen p = this.parent;
            while (p instanceof GuiOptionList) {
                p = ((GuiOptionList)p).parent;
            }
            GuiInfo.switchGui(p);
        } else {
            super.func_73869_a(c, keycode);
        }
    }

    public boolean worldConfig() {
        return this.world;
    }

    public class OptionScrollSlot
    extends GuiScrollSlot {
        public ArrayList<Option> options;

        public OptionScrollSlot() {
            super(0, 0, 0, 0);
            this.options = new ArrayList();
        }

        public void onAdded(GuiScreen s) {
            super.onAdded(s);
            for (Option o : ((GuiOptionList)GuiOptionList.this).optionList.optionList) {
                this.options.add(o);
            }
            for (Option o : this.options) {
                o.onAdded(this);
            }
        }

        public int getSlotHeight() {
            return 24;
        }

        public int contentWidth() {
            return this.width - 20;
        }

        protected int getNumSlots() {
            return this.options.size();
        }

        public void selectNext() {
        }

        public void selectPrev() {
        }

        protected boolean isSlotSelected(int slot) {
            return false;
        }

        protected void drawSlot(int slot, int x, int y, int mousex, int mousey, boolean selected, float frame) {
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            Option o = this.options.get(slot);
            if (o.showWorldSelector() && GuiOptionList.this.world) {
                this.drawWorldSelector(o, mousex, mousey);
            }
            o.draw(mousex, mousey, frame);
            GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        }

        public Rectangle4i worldButtonSize() {
            return new Rectangle4i(-24, 2, 20, 20);
        }

        private void drawWorldSelector(Option o, int mousex, int mousey) {
            Rectangle4i b = this.worldButtonSize();
            boolean set = o.hasWorldOverride();
            boolean mouseover = b.contains(mousex, mousey);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, !set ? 0 : (mouseover ? 2 : 1));
            GuiDraw.drawStringC((String)"W", (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)-1);
        }

        public void drawOverlay(float frame) {
            this.drawOverlayTex(0, 0, this.parentScreen.field_146294_l, this.y);
            this.drawOverlayTex(0, this.y + this.height, this.parentScreen.field_146294_l, this.parentScreen.field_146295_m - this.y - this.height);
            this.drawOverlayGrad(0, this.parentScreen.field_146294_l, this.y, this.y + 4);
            this.drawOverlayGrad(0, this.parentScreen.field_146294_l, this.y + this.height, this.y + this.height - 4);
        }

        public void drawOverlayTex(int x, int y, int w, int h) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderEngine.func_110577_a(Gui.field_110325_k);
            Tessellator t = Tessellator.field_78398_a;
            t.func_78382_b();
            t.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
            t.func_78374_a((double)x, (double)(y + h), (double)this.field_73735_i, 0.0, (double)h / 16.0);
            t.func_78374_a((double)(x + w), (double)(y + h), (double)this.field_73735_i, (double)w / 16.0, (double)h / 16.0);
            t.func_78374_a((double)(x + w), (double)y, (double)this.field_73735_i, (double)w / 16.0, 0.0);
            t.func_78381_a();
        }

        public void drawOverlayGrad(int x1, int x2, int y1, int y2) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            Tessellator t = Tessellator.field_78398_a;
            t.func_78382_b();
            t.func_78384_a(0, 255);
            t.func_78377_a((double)x2, (double)y1, (double)this.field_73735_i);
            t.func_78377_a((double)x1, (double)y1, (double)this.field_73735_i);
            t.func_78384_a(0, 0);
            t.func_78377_a((double)x1, (double)y2, (double)this.field_73735_i);
            t.func_78377_a((double)x2, (double)y2, (double)this.field_73735_i);
            t.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3553);
        }

        public void drawSlotBox(float frame) {
        }

        public boolean drawLineGuide() {
            return false;
        }

        public int getScrollBarWidth() {
            return 6;
        }

        public void drawScrollBar(float frame) {
            int sbarw = this.getScrollBarWidth();
            int sbarx = this.x + this.width - sbarw;
            OptionScrollSlot.func_73734_a((int)sbarx, (int)this.y, (int)(sbarx + sbarw), (int)(this.y + this.height), (int)-16777216);
            super.drawScrollBar(frame);
        }

        public void update() {
            super.update();
            for (Option o : this.options) {
                o.update();
            }
        }

        protected void slotClicked(int slot, int button, int mousex, int mousey, boolean doubleclick) {
            this.options.get(slot).mouseClicked(mousex, mousey, button);
        }

        public void mouseClicked(int mousex, int mousey, int button) {
            for (Option o : this.options) {
                o.onMouseClicked(mousex, mousey, button);
            }
            super.mouseClicked(mousex, mousey, button);
            int slot = this.getClickedSlot(mousey);
            if (slot >= 0) {
                Option o;
                o = this.options.get(slot);
                if (GuiOptionList.this.world && o.showWorldSelector() && this.worldButtonSize().contains(mousex - this.contentx, mousey - this.getSlotY(slot))) {
                    if (button == 1 && o.hasWorldOverride()) {
                        o.useGlobals();
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    } else if (button == 0 && !o.hasWorldOverride()) {
                        o.copyGlobals();
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    }
                }
            }
        }

        public void keyTyped(char c, int keycode) {
            super.keyTyped(c, keycode);
            for (Option o : this.options) {
                o.keyTyped(c, keycode);
            }
        }

        public void resize() {
            int width = Math.min(this.parentScreen.field_146294_l - 80, 320);
            this.setSize((this.parentScreen.field_146294_l - width) / 2, 20, width, this.parentScreen.field_146295_m - 50);
            this.setContentSize(this.x, this.y + 4, this.height - 8);
        }

        public void mouseScrolled(int x, int y, int scroll) {
            this.scroll(-scroll);
        }

        public GuiOptionList getGui() {
            return (GuiOptionList)this.parentScreen;
        }

        public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
            for (int slot = 0; slot < this.getNumSlots(); ++slot) {
                int sloty = this.getSlotY(slot);
                if (sloty <= this.contenty - this.getSlotHeight() || sloty >= this.contenty + this.contentheight) continue;
                tooltip = this.handleTooltip(slot, mousex - this.contentx, mousey - sloty, tooltip);
            }
            return tooltip;
        }

        private List<String> handleTooltip(int slot, int mousex, int mousey, List<String> tooltip) {
            Option o = this.options.get(slot);
            if (GuiOptionList.this.world && o.showWorldSelector() && this.worldButtonSize().contains(mousex, mousey)) {
                tooltip.add(StatCollector.func_74838_a((String)("nei.options.wbutton.tip." + (o.hasWorldOverride() ? "1" : "0"))));
            }
            return o.handleTooltip(mousex, mousey, tooltip);
        }
    }
}

