/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final HashSet<Item> ingredients = new HashSet();
    public static final HashSet<CachedBrewingRecipe> apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBrewingStand.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.brewing", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (CachedBrewingRecipe recipe : apotions) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() != Items.field_151068_bn) {
            return;
        }
        int damage = result.func_77960_j();
        for (CachedBrewingRecipe recipe : apotions) {
            if (recipe.result.item.func_77960_j() != damage) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() != Items.field_151068_bn && !ingredients.contains(ingredient.func_77973_b())) {
            return;
        }
        for (CachedBrewingRecipe recipe : apotions) {
            if (!NEIServerUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIServerUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(60, 1, 185, -2, 12, 30, 35, 3);
    }

    private boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private void addPotion(Item ingred, int basePotion, int result, TreeSet<Integer> allPotions, HashSet<Integer> newPotions) {
        apotions.add(new CachedBrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int hashcode;
        PositionedStack precursorPotion;
        PositionedStack result;
        PositionedStack ingredient;

        public CachedBrewingRecipe(Item ingred, int basePotionID, int resultDamage) {
            super(BrewingRecipeHandler.this);
            this.precursorPotion = new PositionedStack(new ItemStack((Item)Items.field_151068_bn, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(new ItemStack(ingred, 1, 0), 74, 6);
            this.result = new PositionedStack(new ItemStack((Item)Items.field_151068_bn, 1, resultDamage), 97, 35);
            this.calculateHashcode();
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.ingredient);
            recipestacks.add(this.precursorPotion);
            return recipestacks;
        }

        private void calculateHashcode() {
            this.hashcode = this.result.item.func_77960_j() << 16 + this.precursorPotion.item.func_77960_j();
            this.hashcode = 31 * this.hashcode + (Item.func_150891_b((Item)this.ingredient.item.func_77973_b()) << 16 + this.ingredient.item.func_77960_j());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBrewingRecipe)) {
                return false;
            }
            CachedBrewingRecipe recipe2 = (CachedBrewingRecipe)obj;
            return this.result.item.func_77960_j() == recipe2.result.item.func_77960_j() && this.precursorPotion.item.func_77960_j() == recipe2.precursorPotion.item.func_77960_j() && NEIServerUtils.areStacksSameType(this.ingredient.item, recipe2.ingredient.item);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

