/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MCOutputStreamWrapper
implements MCDataOutput {
    public DataOutputStream dataout;

    public MCOutputStreamWrapper(DataOutputStream out) {
        this.dataout = out;
    }

    @Override
    public MCOutputStreamWrapper writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCDataOutput writeVarInt(int i) {
        while ((i & 0x80) != 0) {
            this.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeByte(i);
        return this;
    }

    @Override
    public MCDataOutput writeVarShort(int s) {
        int low = s & Short.MAX_VALUE;
        int high = (s & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        this.writeShort(low);
        if (high != 0) {
            this.writeByte(high);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeItemStack(ItemStack stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public MCOutputStreamWrapper writeItemStack(ItemStack stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            if (large) {
                this.writeInt(stack.field_77994_a);
            } else {
                this.writeByte(stack.field_77994_a);
            }
            this.writeShort(stack.func_77960_j());
            this.writeNBTTagCompound(stack.field_77990_d);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeNBTTagCompound(NBTTagCompound compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
                this.writeShort((short)bytes.length);
                this.writeByteArray(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.fluidID);
            this.writeInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }
}

