/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.SubTileEntity;

public class SubTileFunctional
extends SubTileEntity {
    private static final String TAG_MANA = "mana";
    private static final String TAG_POOL_X = "poolX";
    private static final String TAG_POOL_Y = "poolY";
    private static final String TAG_POOL_Z = "poolZ";
    public int mana;
    int sizeLastCheck = -1;
    TileEntity linkedPool = null;
    public int knownMana = -1;
    ChunkCoordinates cachedPoolCoordinates = null;

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.linkPool();
        if (this.linkedPool != null) {
            IManaPool pool = (IManaPool)this.linkedPool;
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.recieveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
        if (this.supertile.func_145831_w().field_72995_K) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 2.0;
            Color color = new Color(this.getColor());
            if (Math.random() > particleChance) {
                BotaniaAPI.internalHandler.sparkleFX(this.supertile.func_145831_w(), (double)this.supertile.field_145851_c + 0.3 + Math.random() * 0.5, (double)this.supertile.field_145848_d + 0.5 + Math.random() * 0.5, (double)this.supertile.field_145849_e + 0.3 + Math.random() * 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random(), 5);
            }
        }
    }

    public void linkPool() {
        IManaNetwork network;
        int size;
        TileEntity tileAt;
        int range = 6;
        boolean needsNew = false;
        if (this.linkedPool == null) {
            needsNew = true;
            if (this.cachedPoolCoordinates != null) {
                tileAt = this.supertile.func_145831_w().func_147438_o(this.cachedPoolCoordinates.field_71574_a, this.cachedPoolCoordinates.field_71572_b, this.cachedPoolCoordinates.field_71573_c);
                if (tileAt != null && tileAt instanceof IManaPool) {
                    this.linkedPool = tileAt;
                    needsNew = false;
                }
                this.cachedPoolCoordinates = null;
            }
        }
        if (!needsNew) {
            tileAt = this.supertile.func_145831_w().func_147438_o(this.linkedPool.field_145851_c, this.linkedPool.field_145848_d, this.linkedPool.field_145849_e);
            if (!(tileAt instanceof IManaPool)) {
                this.linkedPool = null;
                needsNew = true;
            } else {
                this.linkedPool = tileAt;
            }
        }
        if (needsNew && (size = (network = BotaniaAPI.internalHandler.getManaNetworkInstance()).getAllPoolsInWorld(this.supertile.func_145831_w().field_73011_w.field_76574_g).size()) != this.sizeLastCheck) {
            ChunkCoordinates coords = new ChunkCoordinates(this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e);
            this.linkedPool = network.getClosestPool(coords, this.supertile.func_145831_w().field_73011_w.field_76574_g, 6);
            this.sizeLastCheck = size;
        }
    }

    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.mana + mana);
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        this.knownMana = this.mana;
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 1.0f);
        return super.onWanded(player, wand);
    }

    public int getMaxMana() {
        return 20;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        int x = cmp.func_74762_e(TAG_POOL_X);
        int y = cmp.func_74762_e(TAG_POOL_Y);
        int z = cmp.func_74762_e(TAG_POOL_Z);
        this.cachedPoolCoordinates = new ChunkCoordinates(x, y, z);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        int x = this.linkedPool == null ? 0 : this.linkedPool.field_145851_c;
        int y = this.linkedPool == null ? -1 : this.linkedPool.field_145848_d;
        int z = this.linkedPool == null ? 0 : this.linkedPool.field_145849_e;
        cmp.func_74768_a(TAG_POOL_X, x);
        cmp.func_74768_a(TAG_POOL_Y, y);
        cmp.func_74768_a(TAG_POOL_Z, z);
    }

    @Override
    public ChunkCoordinates getBinding() {
        if (this.linkedPool == null) {
            return null;
        }
        return new ChunkCoordinates(this.linkedPool.field_145851_c, this.linkedPool.field_145848_d, this.linkedPool.field_145849_e);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = StatCollector.func_74838_a((String)("tile.botania:flower." + this.getUnlocalizedName() + ".name"));
        int color = 0x66000000 | this.getColor();
        BotaniaAPI.internalHandler.drawSimpleManaHUD(color, this.knownMana, this.getMaxMana(), name, res);
    }
}

