/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.subtile.SubTileEntity;

public class SubTileGenerating
extends SubTileEntity {
    private static final String TAG_MANA = "mana";
    private static final String TAG_COLLECTOR_X = "collectorX";
    private static final String TAG_COLLECTOR_Y = "collectorY";
    private static final String TAG_COLLECTOR_Z = "collectorZ";
    protected int mana;
    int sizeLastCheck = -1;
    protected TileEntity linkedCollector = null;
    public int knownMana = -1;
    ChunkCoordinates cachedCollectorCoordinates = null;

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.linkCollector();
        if (this.canGeneratePassively()) {
            int delay = this.getDelayBetweenPassiveGeneration();
            if (delay > 0 && this.supertile.func_145831_w().func_72820_D() % (long)delay == 0L) {
                if (this.shouldSyncPassiveGeneration()) {
                    this.sync();
                }
                this.addMana(this.getValueForPassiveGeneration());
            }
            this.emptyManaIntoCollector();
        }
        if (this.supertile.func_145831_w().field_72995_K) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 2.0;
            Color color = new Color(this.getColor());
            if (Math.random() > particleChance) {
                BotaniaAPI.internalHandler.sparkleFX(this.supertile.func_145831_w(), (double)this.supertile.field_145851_c + 0.3 + Math.random() * 0.5, (double)this.supertile.field_145848_d + 0.5 + Math.random() * 0.5, (double)this.supertile.field_145849_e + 0.3 + Math.random() * 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random(), 5);
            }
        }
    }

    public void linkCollector() {
        IManaNetwork network;
        int size;
        TileEntity tileAt;
        int range = 6;
        boolean needsNew = false;
        if (this.linkedCollector == null) {
            needsNew = true;
            if (this.cachedCollectorCoordinates != null) {
                tileAt = this.supertile.func_145831_w().func_147438_o(this.cachedCollectorCoordinates.field_71574_a, this.cachedCollectorCoordinates.field_71572_b, this.cachedCollectorCoordinates.field_71573_c);
                if (tileAt != null && tileAt instanceof IManaCollector) {
                    this.linkedCollector = tileAt;
                    needsNew = false;
                }
                this.cachedCollectorCoordinates = null;
            }
        }
        if (!needsNew) {
            tileAt = this.supertile.func_145831_w().func_147438_o(this.linkedCollector.field_145851_c, this.linkedCollector.field_145848_d, this.linkedCollector.field_145849_e);
            if (!(tileAt instanceof IManaCollector)) {
                this.linkedCollector = null;
                needsNew = true;
            } else {
                this.linkedCollector = tileAt;
            }
        }
        if (needsNew && (size = (network = BotaniaAPI.internalHandler.getManaNetworkInstance()).getAllCollectorsInWorld(this.supertile.func_145831_w().field_73011_w.field_76574_g).size()) != this.sizeLastCheck) {
            ChunkCoordinates coords = new ChunkCoordinates(this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e);
            this.linkedCollector = network.getClosestCollector(coords, this.supertile.func_145831_w().field_73011_w.field_76574_g, 6);
            this.sizeLastCheck = size;
        }
    }

    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.mana + mana);
    }

    public void emptyManaIntoCollector() {
        IManaCollector collector;
        if (this.linkedCollector != null && !(collector = (IManaCollector)this.linkedCollector).isFull()) {
            collector.recieveMana(this.mana);
            this.mana = 0;
        }
    }

    public boolean shouldSyncPassiveGeneration() {
        return false;
    }

    public boolean canGeneratePassively() {
        boolean rain = this.supertile.func_145831_w().func_72959_q().func_76935_a(this.supertile.field_145851_c, this.supertile.field_145849_e).func_76744_g() > 0 && (this.supertile.func_145831_w().func_72896_J() || this.supertile.func_145831_w().func_72911_I());
        return !this.supertile.func_145831_w().field_72995_K && this.supertile.func_145831_w().func_72935_r() && !rain && this.supertile.func_145831_w().func_72937_j(this.supertile.field_145851_c, this.supertile.field_145848_d + 1, this.supertile.field_145849_e);
    }

    public int getDelayBetweenPassiveGeneration() {
        return 20;
    }

    public int getValueForPassiveGeneration() {
        return 1;
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        if (!player.field_70170_p.field_72995_K) {
            this.sync();
        }
        this.knownMana = this.mana;
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 1.0f);
        return super.onWanded(player, wand);
    }

    public int getMaxMana() {
        return 20;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        int x = cmp.func_74762_e(TAG_COLLECTOR_X);
        int y = cmp.func_74762_e(TAG_COLLECTOR_Y);
        int z = cmp.func_74762_e(TAG_COLLECTOR_Z);
        this.cachedCollectorCoordinates = new ChunkCoordinates(x, y, z);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        int x = this.linkedCollector == null ? 0 : this.linkedCollector.field_145851_c;
        int y = this.linkedCollector == null ? -1 : this.linkedCollector.field_145848_d;
        int z = this.linkedCollector == null ? 0 : this.linkedCollector.field_145849_e;
        cmp.func_74768_a(TAG_COLLECTOR_X, x);
        cmp.func_74768_a(TAG_COLLECTOR_Y, y);
        cmp.func_74768_a(TAG_COLLECTOR_Z, z);
    }

    @Override
    public ChunkCoordinates getBinding() {
        if (this.linkedCollector == null) {
            return null;
        }
        return new ChunkCoordinates(this.linkedCollector.field_145851_c, this.linkedCollector.field_145848_d, this.linkedCollector.field_145849_e);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = StatCollector.func_74838_a((String)("tile.botania:flower." + this.getUnlocalizedName() + ".name"));
        int color = 0x66000000 | this.getColor();
        BotaniaAPI.internalHandler.drawSimpleManaHUD(color, this.knownMana, this.getMaxMana(), name, res);
    }
}

