/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.gui.GuiLexicon;
import vazkii.botania.client.gui.GuiLexiconEntry;
import vazkii.botania.client.gui.button.GuiButtonBack;
import vazkii.botania.client.gui.button.GuiButtonInvisible;
import vazkii.botania.client.gui.button.GuiButtonPage;

public class GuiLexiconIndex
extends GuiLexicon {
    LexiconCategory category;
    String title;
    int page = 0;
    GuiButton leftButton;
    GuiButton rightButton;
    List<LexiconEntry> entriesToDisplay = new ArrayList<LexiconEntry>();

    public GuiLexiconIndex(LexiconCategory category) {
        this.category = category;
        this.title = StatCollector.func_74838_a((String)category.getUnlocalizedName());
    }

    @Override
    void drawHeader() {
    }

    @Override
    String getTitle() {
        return this.title;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButtonBack(12, this.left + this.guiWidth / 2 - 8, this.top + this.guiHeight + 2));
        this.leftButton = new GuiButtonPage(13, this.left, this.top + this.guiHeight - 10, false);
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButtonPage(14, this.left + this.guiWidth - 18, this.top + this.guiHeight - 10, true);
        this.field_146292_n.add(this.rightButton);
        this.entriesToDisplay.clear();
        this.entriesToDisplay.addAll(this.category.entries);
        Collections.sort(this.entriesToDisplay);
        this.updatePageButtons();
        this.populateIndex();
    }

    @Override
    void populateIndex() {
        for (int i = this.page * 12; i < (this.page + 1) * 12; ++i) {
            LexiconEntry entry;
            GuiButtonInvisible button = (GuiButtonInvisible)((Object)this.field_146292_n.get(i - this.page * 12));
            LexiconEntry lexiconEntry = entry = i >= this.entriesToDisplay.size() ? null : this.entriesToDisplay.get(i);
            button.field_146126_j = entry != null ? (entry.isPriority() ? EnumChatFormatting.ITALIC : "") + StatCollector.func_74838_a((String)entry.getUnlocalizedName()) : "";
        }
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 12: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiLexicon());
                ClientTickHandler.notifyPageChange();
                break;
            }
            case 13: {
                --this.page;
                this.updatePageButtons();
                this.populateIndex();
                ClientTickHandler.notifyPageChange();
                break;
            }
            case 14: {
                ++this.page;
                this.updatePageButtons();
                this.populateIndex();
                ClientTickHandler.notifyPageChange();
                break;
            }
            default: {
                int index = par1GuiButton.field_146127_k + this.page * 12;
                if (index >= this.entriesToDisplay.size()) {
                    return;
                }
                LexiconEntry entry = this.entriesToDisplay.get(index);
                this.field_146297_k.func_147108_a((GuiScreen)new GuiLexiconEntry(entry, this));
                ClientTickHandler.notifyPageChange();
            }
        }
    }

    public void updatePageButtons() {
        this.leftButton.field_146124_l = this.page != 0;
        this.rightButton.field_146124_l = this.page < (this.entriesToDisplay.size() - 1) / 12;
    }
}

