////////////////////////////////////////////////////////////////////////////////
// アリスの人形MOD

package mods.touhou_alice_extras;

import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import cpw.mods.fml.common.FMLLog;

import java.lang.reflect.Method;

/**
 * 五つの難題MOD+の共通ライブラリのラッパークラス
 */
public class THKaguyaLibWrapper
{
    private static THKaguyaLibWrapper instance = new THKaguyaLibWrapper();

    /**
     * singleton class
     */
    private THKaguyaLibWrapper() {}

    /**
     * インスタンスを取得
     */
    public static THKaguyaLibWrapper getInstance()
    {
        return instance;
    }

    /**
     * ラッパークラスが利用可能かどうか
     */
    public static boolean isEnable()
    {
        return instance.getClazz() != null;
    }

    private Class<?> clazz = null;

    private Class<?> getClazz()
    {
        if(clazz == null)
        {
            try
            {
                clazz = Class.forName("thKaguyaMod.THKaguyaLib");
                FMLLog.info("Found \"thKaguya.THKaguyaLib\"!");
            }
            catch(Exception e)
            {
            }
        }
        return clazz;
    }
    
    private boolean callMethod(String methodName,
                                 Class[] argsClass, Object[] args)
    {
        if(!isEnable())
        {
            return false;
        }
        boolean result = false;
        try
        {
            Method m = clazz.getMethod(methodName, argsClass);
            m.invoke(null, args);
            result = true;
        }
        catch(Exception e)
        {
        }

        return result;
    }

    ////////////////////////////////////////////////////////////////////////////

    /**
     * 五つの難題MOD+の共通ライブラリを利用してホーミングアミュレットを発射
     */
    public boolean createHomingAmulet(EntityLivingBase user,
                                      Entity source,
                                      double posX,
                                      double posY,
                                      double posZ,
                                      double vectorX,
                                      double vectorY,
                                      double vectorZ,
                                      double firstSpeed,
                                      double maxSpeed,
                                      double addSpeed,
                                      double xVectorG,
                                      double yVectorG,
                                      double zVectorG,
                                      float damage,
                                      int color,
                                      float size,
                                      int end,
                                      int delay)
    {
        boolean result = false;
        {
            Class[] argsClass = {EntityLivingBase.class,
                                 Entity.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 double.class,
                                 float.class,
                                 int.class,
                                 float.class,
                                 int.class,
                                 int.class};
            Object[] args = {user,
                             source,
                             new Double(posX),
                             new Double(posY),
                             new Double(posZ),
                             new Double(vectorX),
                             new Double(vectorY),
                             new Double(vectorZ),
                             new Double(firstSpeed),
                             new Double(maxSpeed),
                             new Double(addSpeed),
                             new Double(xVectorG),
                             new Double(yVectorG),
                             new Double(zVectorG),
                             new Float(damage),
                             new Integer(color),
                             new Float(size),
                             new Integer(end),
                             new Integer(delay)};
        
            result = this.callMethod("createHomingAmulet", argsClass, args);
        }
        return result;
    }
}
