/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.client.presentation.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWireless;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiRedstoneWireless
extends GuiScreen {
    protected World world;
    protected EntityPlayer entityplayer;
    protected int xSize = 177;
    protected int ySize = 166;
    protected List<IGuiRedstoneWirelessOverride> overrides = new ArrayList<IGuiRedstoneWirelessOverride>();

    public void addOverride(IGuiRedstoneWirelessOverride override) {
        this.overrides.add(override);
    }

    protected abstract void addControls();

    public void initGui() {
        this.addControls();
        super.initGui();
    }

    private boolean isMouseOverButton(GuiButtonWireless button, int i, int j) {
        if (button != null) {
            return button.inBounds(i, j);
        }
        return false;
    }

    protected abstract ResourceLocation getBackgroundImage();

    protected abstract String getGuiName();

    protected abstract Object getFreq();

    public abstract void setFreq(Object var1);

    public void drawScreen(int i, int j, float f) {
        try {
            this.drawDefaultBackground();
            int k = (this.width - this.xSize) / 2;
            int l = (this.height - this.ySize) / 2;
            this.drawGuiContainerBackgroundLayer(i, j, f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)k, (float)l, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            this.drawGuiName();
            this.drawGuiContainerForegroundLayer(i, j, f);
            GL11.glPopMatrix();
            super.drawScreen(i, j, f);
            this.drawTooltips(i, j, f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWireless").writeStackTrace(e);
        }
    }

    protected void drawStringBorder(int x1, int y1, int x2) {
        GuiRedstoneWireless.drawRect((int)(x1 - 3), (int)(y1 - 3), (int)(x2 + 3), (int)(y1 + 10), (int)-16777216);
        GuiRedstoneWireless.drawRect((int)(x1 - 2), (int)(y1 - 2), (int)(x2 + 2), (int)(y1 + 9), (int)-1);
    }

    protected void drawGuiName() {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getGuiName()) / 2, 6, this.xSize / 2 + this.fontRendererObj.getStringWidth(this.getGuiName()) / 2);
        this.fontRendererObj.drawString(this.getGuiName(), this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getGuiName()) / 2, 6, 0x404040);
    }

    protected void drawFrequency(int y) {
        this.fontRendererObj.drawString(this.getFreq() + "", this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2, this.ySize / 2 + y, 0x404040);
    }

    protected void drawFrequencyAndBox(int y) {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2, this.ySize / 2 + y, this.xSize / 2 + this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2);
        this.drawFrequency(y);
    }

    protected void drawFrequencyLabel(int y) {
        this.fontRendererObj.drawString("Frequency", this.xSize / 2 - this.fontRendererObj.getStringWidth("Frequency") / 2, y, 0x404040);
    }

    protected void drawFrequencyLabelAndBox(int y) {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth("Frequency") / 2, y, this.xSize / 2 + this.fontRendererObj.getStringWidth("Frequency") / 2);
        this.drawFrequencyLabel(y);
    }

    protected void drawGuiContainerForegroundLayer(int i, int j, float f) {
        this.drawFrequencyLabelAndBox(32);
        this.drawFrequencyAndBox(-35);
    }

    protected void drawGuiContainerBackgroundLayer(int i, int j, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(this.getBackgroundImage());
        int sizeX = (this.width - this.xSize) / 2;
        int sizeY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sizeX, sizeY, 0, 0, this.xSize, this.ySize);
    }

    private void drawTooltips(int i, int j, float f) {
        for (Object button : this.buttonList) {
            GuiButtonWireless guibutton;
            if (!(button instanceof GuiButtonWireless) || !this.isMouseOverButton(guibutton = (GuiButtonWireless)((Object)button), i, j)) continue;
            guibutton.drawToolTip(this.mc, i, j);
        }
    }

    protected abstract void actionPerformed(GuiButton var1);

    public void handleKeyboardInput() {
        try {
            super.handleKeyboardInput();
            if (Keyboard.getEventKeyState()) {
                int inventoryKey = 0;
                if (this.mc.gameSettings.keyBindInventory.isPressed()) {
                    inventoryKey = this.mc.gameSettings.keyBindInventory.getKeyCode();
                }
                if (Keyboard.getEventKey() == inventoryKey || Keyboard.getEventKey() == 28) {
                    this.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWireless").writeStackTrace(e);
        }
    }

    public void handleMouseInput() {
        try {
            super.handleMouseInput();
            if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                this.close();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWireless").writeStackTrace(e);
        }
    }

    public void close() {
        try {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWireless").writeStackTrace(e);
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void refreshGui() {
        this.removeControls();
        this.addControls();
    }

    private void removeControls() {
        this.buttonList.clear();
    }
}

