/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.client.presentation.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWireless;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.inventory.ContainerRedstoneWireless;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiRedstoneWirelessContainer
extends GuiContainer {
    protected World world;
    protected EntityPlayer entityplayer;
    protected int xSize = 177;
    protected int ySize = 166;
    protected List<IGuiRedstoneWirelessOverride> overrides = new ArrayList<IGuiRedstoneWirelessOverride>();

    public GuiRedstoneWirelessContainer(ContainerRedstoneWireless container) {
        super((Container)container);
    }

    public void addOverride(IGuiRedstoneWirelessOverride override) {
        this.overrides.add(override);
    }

    protected abstract void addControls();

    public void initGui() {
        this.addControls();
        super.initGui();
    }

    private boolean isMouseOverButton(GuiButtonWireless button, int i, int j) {
        if (button != null) {
            return button.inBounds(i, j);
        }
        return false;
    }

    protected abstract ResourceLocation getBackgroundImage();

    protected abstract String getGuiName();

    protected void drawStringBorder(int x1, int y1, int x2) {
        GuiRedstoneWirelessContainer.drawRect((int)(x1 - 3), (int)(y1 - 3), (int)(x2 + 3), (int)(y1 + 10), (int)-16777216);
        GuiRedstoneWirelessContainer.drawRect((int)(x1 - 2), (int)(y1 - 2), (int)(x2 + 2), (int)(y1 + 9), (int)-1);
    }

    protected void drawGuiName() {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getLocalizedName()) / 2, 7, this.xSize / 2 + this.fontRendererObj.getStringWidth(this.getLocalizedName()) / 2);
        this.fontRendererObj.drawString(this.getLocalizedName(), this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getLocalizedName()) / 2, 7, 0x404040);
    }

    private String getLocalizedName() {
        return StatCollector.translateToLocal((String)this.getGuiName());
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        this.drawGuiName();
        this.drawForegroundObjects(i, j);
    }

    protected abstract void drawForegroundObjects(int var1, int var2);

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(this.getBackgroundImage());
        int sizeX = (this.width - this.xSize) / 2;
        int sizeY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sizeX, sizeY, 0, 0, this.xSize, this.ySize);
    }

    private void drawTooltips(int i, int j, float f) {
        for (Object button : this.buttonList) {
            GuiButtonWireless guibutton;
            if (!(button instanceof GuiButtonWireless) || !this.isMouseOverButton(guibutton = (GuiButtonWireless)((Object)button), i, j)) continue;
            guibutton.drawToolTip(this.mc, i, j);
        }
    }

    public void handleKeyboardInput() {
        try {
            super.handleKeyboardInput();
            if (Keyboard.getEventKeyState()) {
                int inventoryKey = 0;
                if (this.mc.gameSettings.keyBindInventory.isPressed()) {
                    inventoryKey = this.mc.gameSettings.keyBindInventory.getKeyCode();
                }
                if (Keyboard.getEventKey() == inventoryKey || Keyboard.getEventKey() == 28) {
                    this.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWirelessContainer").writeStackTrace(e);
        }
    }

    public void close() {
        try {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWirelessContainer").writeStackTrace(e);
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void refreshGui() {
        this.removeControls();
        this.addControls();
    }

    private void removeControls() {
        this.buttonList.clear();
    }
}

