/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.client.presentation.gui;

import net.minecraft.client.gui.GuiButton;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessInventoryOverride;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWireless;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWirelessExit;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiRedstoneWirelessContainer;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.inventory.ContainerRedstoneWireless;
import net.slimevoid.wirelessredstone.network.handlers.RedstoneEtherPacketHandler;
import net.slimevoid.wirelessredstone.network.packets.PacketRedstoneWirelessCommands;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;

public abstract class GuiRedstoneWirelessInventory
extends GuiRedstoneWirelessContainer {
    protected TileEntityRedstoneWireless inventory;

    public GuiRedstoneWirelessInventory(ContainerRedstoneWireless container) {
        super(container);
        this.inventory = (TileEntityRedstoneWireless)container.redstoneWireless;
        this.xSize = 177;
        this.ySize = 166;
    }

    @Override
    protected void drawForegroundObjects(int i, int k) {
        this.drawFrequencyLabelAndBox(32);
        this.drawFrequencyAndBox(-35);
    }

    protected void drawFrequency(int y) {
        this.fontRendererObj.drawString(this.getFreq() + "", this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2, this.ySize / 2 + y, 0x404040);
    }

    protected void drawFrequencyAndBox(int y) {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2, this.ySize / 2 + y, this.xSize / 2 + this.fontRendererObj.getStringWidth(this.getFreq() + "") / 2);
        this.drawFrequency(y);
    }

    protected void drawFrequencyLabel(int y) {
        this.fontRendererObj.drawString("Frequency", this.xSize / 2 - this.fontRendererObj.getStringWidth("Frequency") / 2, y, 0x404040);
    }

    protected void drawFrequencyLabelAndBox(int y) {
        this.drawStringBorder(this.xSize / 2 - this.fontRendererObj.getStringWidth("Frequency") / 2, y, this.xSize / 2 + this.fontRendererObj.getStringWidth("Frequency") / 2);
        this.drawFrequencyLabel(y);
    }

    public void assTileEntity(TileEntityRedstoneWireless tileentity) {
        this.inventory = tileentity;
    }

    public boolean compareInventory(TileEntityRedstoneWireless tileentity) {
        return this.inventory != null && this.inventory.xCoord == tileentity.xCoord && this.inventory.yCoord == tileentity.yCoord && this.inventory.zCoord == tileentity.zCoord;
    }

    @Override
    protected void addControls() {
        this.buttonList.add(new GuiButtonWireless(0, this.width / 2 + 10, this.height / 2 - 20, 20, 20, "+"));
        this.buttonList.add(new GuiButtonWireless(1, this.width / 2 - 30, this.height / 2 - 20, 20, 20, "-"));
        this.buttonList.add(new GuiButtonWireless(2, this.width / 2 + 32, this.height / 2 - 20, 20, 20, "+10"));
        this.buttonList.add(new GuiButtonWireless(3, this.width / 2 - 52, this.height / 2 - 20, 20, 20, "-10"));
        this.buttonList.add(new GuiButtonWireless(4, this.width / 2 + 54, this.height / 2 - 20, 26, 20, "+100"));
        this.buttonList.add(new GuiButtonWireless(5, this.width / 2 - 80, this.height / 2 - 20, 26, 20, "-100"));
        this.buttonList.add(new GuiButtonWireless(6, this.width / 2 + 48, this.height / 2 - 42, 32, 20, "+1000"));
        this.buttonList.add(new GuiButtonWireless(7, this.width / 2 - 80, this.height / 2 - 42, 32, 20, "-1000"));
        this.buttonList.add(new GuiButtonWirelessExit(100, (this.width - this.xSize) / 2 + this.xSize - 13 - 1, (this.height - this.ySize) / 2 + 1));
    }

    protected void actionPerformed(GuiButton guibutton) {
        try {
            int oldFreq;
            int freq;
            Object a = this.getFreq();
            Object b = this.getFreq();
            try {
                freq = Integer.parseInt(a.toString());
                oldFreq = Integer.parseInt(b.toString());
            }
            catch (NumberFormatException e) {
                return;
            }
            switch (guibutton.id) {
                case 0: {
                    ++freq;
                    break;
                }
                case 1: {
                    --freq;
                    break;
                }
                case 2: {
                    freq += 10;
                    break;
                }
                case 3: {
                    freq -= 10;
                    break;
                }
                case 4: {
                    freq += 100;
                    break;
                }
                case 5: {
                    freq -= 100;
                    break;
                }
                case 6: {
                    freq += 1000;
                    break;
                }
                case 7: {
                    freq -= 1000;
                    break;
                }
                case 100: {
                    this.close();
                }
            }
            if (freq > 9999) {
                freq -= 10000;
            }
            if (freq < 0) {
                freq += 10000;
            }
            boolean prematureExit = false;
            for (IGuiRedstoneWirelessOverride override : this.overrides) {
                if (!((IGuiRedstoneWirelessInventoryOverride)override).beforeFrequencyChange(this.inventory, oldFreq, freq)) continue;
                prematureExit = true;
            }
            if (prematureExit) {
                return;
            }
            RedstoneEtherPacketHandler.sendEtherPacketToServer(PacketRedstoneWirelessCommands.wirelessCommands.changeFreq.toString(), this.inventory.getBlockCoord(0), this.inventory.getBlockCoord(1), this.inventory.getBlockCoord(2), freq - oldFreq, false);
            if (oldFreq != freq) {
                this.setFreq(Integer.toString(freq));
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWirelessInventory").writeStackTrace(e);
        }
    }

    @Override
    protected String getGuiName() {
        return this.inventory.getInventoryName();
    }

    protected Object getFreq() {
        return this.inventory.getFreq();
    }

    public void setFreq(Object freq) {
        this.inventory.setFreq(freq);
    }
}

