/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.device;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IWirelessDevice;
import net.slimevoid.wirelessredstone.data.WirelessCoordinates;
import net.slimevoid.wirelessredstone.device.ItemWirelessDevice;

public abstract class WirelessDevice
implements IWirelessDevice {
    protected World world;
    protected EntityLivingBase entityliving;
    protected int xCoord;
    protected int yCoord;
    protected int zCoord;
    protected Object freq;
    protected boolean state;

    protected WirelessDevice(World world, EntityLivingBase entity, ItemStack itemstack) {
        this.world = world;
        this.entityliving = entity;
        this.setCoords((int)entity.posX, (int)entity.posY, (int)entity.posZ);
        if (itemstack != null && itemstack.hasTagCompound()) {
            this.readFromNBT(itemstack.getTagCompound());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.freq = nbttagcompound.getString("Freq");
        this.state = nbttagcompound.getBoolean("State");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setString("Freq", String.valueOf(this.freq));
        nbttagcompound.setBoolean("State", this.state);
    }

    @Override
    public void setFreq(Object freq) {
        this.freq = freq;
    }

    @Override
    public void setState(boolean state) {
        this.state = state;
    }

    @Override
    public void setOwner(EntityLiving entity) {
        this.entityliving = entity;
    }

    @Override
    public void setCoords(WirelessCoordinates coords) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        this.setCoords(x, y, z);
    }

    @Override
    public void setCoords(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    @Override
    public WirelessCoordinates getCoords() {
        return new WirelessCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Object getFreq() {
        return this.freq;
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public EntityLivingBase getOwner() {
        return this.entityliving;
    }

    @Override
    public void activate(World world, Entity entity) {
        this.state = true;
        if (!world.isRemote) {
            this.doActivateCommand();
        }
    }

    @Override
    public void deactivate(World world, Entity entity, boolean isForced) {
        this.state = true;
        if (!world.isRemote) {
            this.doDeactivateCommand();
        }
    }

    @Override
    public abstract void doActivateCommand();

    @Override
    public abstract void doDeactivateCommand();

    protected abstract String getActivateCommand();

    protected abstract String getDeactivateCommand();

    @Override
    public abstract boolean isBeingHeld(EntityLivingBase var1);

    public int getSizeInventory() {
        return 0;
    }

    public ItemStack getStackInSlot(int i) {
        return null;
    }

    public ItemStack decrStackSize(int i, int j) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public void markDirty() {
        ItemStack heldItem = this.entityliving.getHeldItem();
        if (heldItem != null && heldItem.getItem() != null && heldItem.getItem() instanceof ItemWirelessDevice) {
            if (!heldItem.hasTagCompound()) {
                heldItem.stackTagCompound = new NBTTagCompound();
            }
            this.writeToNBT(heldItem.stackTagCompound);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }
}

