/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.ether;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IRedstoneEtherOverride;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherFrequency;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;

public class RedstoneEther {
    private Map<Integer, Map<String, RedstoneEtherFrequency>> ether = new HashMap<Integer, Map<String, RedstoneEtherFrequency>>();
    private List<IRedstoneEtherOverride> overrides = new ArrayList<IRedstoneEtherOverride>();
    private String currentWorldName = "";
    private static RedstoneEther instance;
    private JFrame gui;

    private RedstoneEther() {
    }

    public static RedstoneEther getInstance() {
        if (instance == null) {
            instance = new RedstoneEther();
        }
        return instance;
    }

    public void addOverride(IRedstoneEtherOverride override) {
        this.overrides.add(override);
    }

    public void assGui(JFrame gui) {
        this.gui = gui;
    }

    public synchronized void addTransmitter(World world, int i, int j, int k, Object object) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "addTransmitter(world, " + i + ", " + j + ", " + k + ", " + object + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeAddTransmitter(world, i, j, k, object)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (!this.freqIsset(world, object)) {
                this.createFreq(world, object);
            }
            RedstoneEtherNode node = new RedstoneEtherNode(i, j, k);
            node.freq = object;
            this.ether.get(world.hashCode()).get(object).addTransmitter(world, node);
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterAddTransmitter(world, i, j, k, object);
        }
    }

    public synchronized void remTransmitter(World world, int i, int j, int k, Object object) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "remTransmitter(world, " + i + ", " + j + ", " + k + ", " + object + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeRemTransmitter(world, i, j, k, object)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (this.freqIsset(world, object)) {
                this.ether.get(world.hashCode()).get(object).remTransmitter(world, i, j, k);
                if (this.ether.get(world.hashCode()).get(object).count() == 0) {
                    this.ether.get(world.hashCode()).remove(object);
                }
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterRemTransmitter(world, i, j, k, object);
        }
    }

    public synchronized void addReceiver(World world, int i, int j, int k, Object freq) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "addReceiver(world, " + i + ", " + j + ", " + k + ", " + freq + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeAddReceiver(world, i, j, k, freq)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (!this.freqIsset(world, freq)) {
                this.createFreq(world, freq);
            }
            RedstoneEtherNode node = new RedstoneEtherNode(i, j, k);
            node.freq = freq;
            this.ether.get(world.hashCode()).get(freq).addReceiver(world, node);
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterAddReceiver(world, i, j, k, freq);
        }
    }

    public synchronized void remReceiver(World world, int i, int j, int k, Object oldFreq) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "remReceiver(world, " + i + ", " + j + ", " + k + ", " + oldFreq + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeRemReceiver(world, i, j, k, oldFreq)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (this.freqIsset(world, oldFreq)) {
                this.ether.get(world.hashCode()).get(oldFreq).remReceiver(world, i, j, k);
                if (this.ether.get(world.hashCode()).get(oldFreq).count() == 0) {
                    this.ether.get(world.hashCode()).remove(oldFreq);
                }
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterRemReceiver(world, i, j, k, oldFreq);
        }
    }

    private synchronized void checkWorldHash(World world) {
        if (!this.currentWorldName.equals(world.getWorldInfo().getWorldName())) {
            this.ether = new HashMap<Integer, Map<String, RedstoneEtherFrequency>>();
            this.currentWorldName = world.getWorldInfo().getWorldName();
        }
        if (!this.ether.containsKey(world.hashCode())) {
            this.ether.put(world.hashCode(), new HashMap());
        }
        if (this.gui != null) {
            this.gui.repaint();
        }
    }

    private synchronized void createFreq(World world, Object freq) {
        this.checkWorldHash(world);
        this.ether.get(world.hashCode()).put(String.valueOf(freq), new RedstoneEtherFrequency());
    }

    private synchronized boolean freqIsset(World world, Object object) {
        this.checkWorldHash(world);
        return this.ether.get(world.hashCode()).containsKey(object);
    }

    public synchronized boolean getFreqState(World world, Object object) {
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "getFreqState(world, " + object + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeGetFreqState(world, object)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit && this.freqIsset(world, object)) {
            returnState = this.ether.get(world.hashCode()).get(object).getState(world);
        }
        boolean out = returnState;
        for (IRedstoneEtherOverride override : this.overrides) {
            out = override.afterGetFreqState(world, object, out);
        }
        return out;
    }

    public synchronized void setTransmitterState(World world, int i, int j, int k, Object freq, boolean state) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "setTransmitterState(world, " + i + ", " + j + ", " + k + ", " + freq + ", " + state + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeSetTransmitterState(world, i, j, k, freq, state)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            if (this.freqIsset(world, freq)) {
                this.ether.get(world.hashCode()).get(freq).setTransmitterState(world, i, j, k, state);
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterSetTransmitterState(world, i, j, k, freq, state);
        }
    }

    public synchronized int[] getClosestActiveTransmitter(World world, int i, int j, int k, String freq) {
        int[] coords = null;
        for (IRedstoneEtherOverride override : this.overrides) {
            coords = override.beforeGetClosestActiveTransmitter(i, j, k, freq);
        }
        if (coords == null) {
            try {
                if (this.freqIsset(world, freq)) {
                    coords = this.ether.get(world.hashCode()).get(freq).getClosestActiveTransmitter(world, i, j, k);
                }
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
            }
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            coords = override.afterGetClosestActiveTransmitter(i, j, k, freq, coords);
        }
        return coords;
    }

    public synchronized int[] getClosestTransmitter(World world, int i, int j, int k, String freq) {
        if (this.freqIsset(world, freq)) {
            return this.ether.get(world.hashCode()).get(freq).getClosestTransmitter(world, i, j, k);
        }
        return null;
    }

    public synchronized boolean isFrequencyActive(World world, String freq) {
        return this.ether.get(world.hashCode()).get(freq).getState(world);
    }

    public static float pythagoras(int[] a, int[] b) {
        double x = 0.0;
        if (a.length <= b.length) {
            for (int n = 0; n < a.length; ++n) {
                x += Math.pow(a[n] - b[n], 2.0);
            }
        } else {
            for (int n = 0; n < b.length; ++n) {
                x += Math.pow(a[n] - b[n], 2.0);
            }
        }
        return (float)Math.sqrt(x);
    }

    public synchronized List<RedstoneEtherNode> getRXNodes() {
        LinkedList<RedstoneEtherNode> list = new LinkedList<RedstoneEtherNode>();
        try {
            HashMap etherClone = (HashMap)((HashMap)this.ether).clone();
            for (Map world : etherClone.values()) {
                for (RedstoneEtherFrequency freq : world.values()) {
                    list.addAll(freq.rxs.values());
                }
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized List<RedstoneEtherNode> getTXNodes() {
        LinkedList<RedstoneEtherNode> list = new LinkedList<RedstoneEtherNode>();
        try {
            HashMap etherClone = (HashMap)((HashMap)this.ether).clone();
            for (Map world : etherClone.values()) {
                for (RedstoneEtherFrequency freq : world.values()) {
                    list.addAll(freq.txs.values());
                }
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized Map<String, Integer> getLoadedFrequenciesForWorld(World world) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        try {
            HashMap etherClone = (HashMap)((HashMap)this.ether.get(world)).clone();
            for (String freq : etherClone.keySet()) {
                if (list.containsKey(freq)) {
                    list.put(freq, (Integer)list.get(freq) + ((RedstoneEtherFrequency)etherClone.get(freq)).count());
                    continue;
                }
                list.put(freq, ((RedstoneEtherFrequency)etherClone.get(freq)).count());
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized Map<String, Integer> getLoadedFrequencies() {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        try {
            HashMap etherClone = (HashMap)((HashMap)this.ether).clone();
            for (Integer world : etherClone.keySet()) {
                for (String freq : ((Map)etherClone.get(world)).keySet()) {
                    if (list.containsKey(freq)) {
                        list.put(freq, (Integer)list.get(freq) + ((RedstoneEtherFrequency)((Map)etherClone.get(world)).get(freq)).count());
                        continue;
                    }
                    list.put(freq, ((RedstoneEtherFrequency)((Map)etherClone.get(world)).get(freq)).count());
                }
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized boolean isLoaded(World world, int i, int j, int k) {
        if (world == null) {
            return false;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.isRemote, "isLoaded(world, " + i + ", " + j + ", " + k + ") [" + (world.getBlock(i, j, k) != Blocks.air) + "&" + (world.getTileEntity(i, j, k) != null) + "]", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeIsLoaded(world, i, j, k)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit) {
            returnState = world.getBlock(i, j, k) != Blocks.air && world.getTileEntity(i, j, k) != null;
        }
        boolean out = returnState;
        for (IRedstoneEtherOverride override : this.overrides) {
            out = override.afterIsLoaded(world, i, j, k, out);
        }
        return out;
    }
}

