/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.network.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.slimevoid.library.network.PacketUpdate;
import net.slimevoid.library.network.handlers.SubPacketHandler;
import net.slimevoid.library.util.helpers.PacketHelper;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;
import net.slimevoid.wirelessredstone.network.packets.PacketRedstoneEther;
import net.slimevoid.wirelessredstone.network.packets.PacketWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessT;

public class RedstoneEtherPacketHandler
extends SubPacketHandler {
    protected PacketWireless createNewPacket() {
        return new PacketRedstoneEther();
    }

    public static void sendEtherTileToAll(TileEntityRedstoneWireless entity, World world) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.isRemote, "sendEtherTileToAll(" + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.broadcastPacket((PacketUpdate)packet);
    }

    public static void sendEtherTileToAllInRange(TileEntityRedstoneWireless entity, World world, int range) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.isRemote, "sendEtherTileToAllInRange(" + packet.toString() + ", " + range + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToAllAround((PacketUpdate)packet, (int)entity.xCoord, (int)entity.yCoord, (int)entity.zCoord, (int)range, (int)world.provider.dimensionId);
    }

    public static void sendEtherTileTo(EntityPlayerMP entityplayermp, TileEntityRedstoneWireless entity, World world) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.isRemote, "sendEtherTileTo(" + entityplayermp.getDisplayName() + "," + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToPlayer((PacketUpdate)packet, (EntityPlayerMP)entityplayermp);
    }

    public static void sendEtherNodeTileToAll(RedstoneEtherNode node) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().worldServerForDimension(0);
        TileEntity entity = world.getTileEntity(node.i, node.j, node.k);
        if (entity instanceof TileEntityRedstoneWireless) {
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWireless)entity, (World)world);
        }
    }

    public static void sendEtherTilesTo(EntityPlayerMP entityplayermp) {
        TileEntity entity;
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherTilesTo(" + entityplayermp.getDisplayName() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().worldServerForDimension(0);
        List<RedstoneEtherNode> list = RedstoneEther.getInstance().getRXNodes();
        for (RedstoneEtherNode node : list) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
            RedstoneEtherPacketHandler.sendEtherTileTo(entityplayermp, (TileEntityRedstoneWirelessR)entity, (World)world);
        }
        list = RedstoneEther.getInstance().getTXNodes();
        for (RedstoneEtherNode node : list) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
            RedstoneEtherPacketHandler.sendEtherTileTo(entityplayermp, (TileEntityRedstoneWirelessT)entity, (World)world);
        }
    }

    public static void sendEtherTilesToAll() {
        TileEntity entity;
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherTilesToAll()", LoggerRedstoneWireless.LogLevel.DEBUG);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().worldServerForDimension(0);
        List<RedstoneEtherNode> list = RedstoneEther.getInstance().getRXNodes();
        for (RedstoneEtherNode node : list) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessR)entity, (World)world);
        }
        list = RedstoneEther.getInstance().getTXNodes();
        for (RedstoneEtherNode node : list) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessT)entity, (World)world);
        }
    }

    public static void sendEtherFrequencyTilesToAll(List<RedstoneEtherNode> txs, List<RedstoneEtherNode> rxs) {
        TileEntity entity;
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherFrequencyTilesToAll()", LoggerRedstoneWireless.LogLevel.DEBUG);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().worldServerForDimension(0);
        for (RedstoneEtherNode node : rxs) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessR)entity, (World)world);
        }
        for (RedstoneEtherNode node : txs) {
            entity = world.getTileEntity(node.i, node.j, node.k);
            if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessT)entity, (World)world);
        }
    }

    public static void sendEtherPacketToServer(String command, int i, int j, int k, Object freq, boolean state) {
        PacketRedstoneEther packet = new PacketRedstoneEther(command);
        packet.setPosition(i, j, k, 0);
        packet.setFreq(freq);
        packet.setState(state);
        LoggerRedstoneWireless.getInstance("ClientRedstoneEtherPacketHandler").write(true, "sendRedstoneEtherPacket(" + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToServer((PacketUpdate)packet);
    }
}

