/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.network.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.slimevoid.library.network.PacketPayload;
import net.slimevoid.library.network.PacketUpdate;
import net.slimevoid.wirelessredstone.api.IPacketWirelessOverride;
import net.slimevoid.wirelessredstone.api.IRedstoneWirelessData;

public abstract class PacketWireless
extends PacketUpdate
implements IRedstoneWirelessData {
    private static List<IPacketWirelessOverride> overrides = new ArrayList<IPacketWirelessOverride>();

    public static void addOverride(IPacketWirelessOverride override) {
        if (!overrides.contains(override)) {
            overrides.add(override);
        }
    }

    public void writeData(ChannelHandlerContext ctx, ByteBuf data) {
        super.writeData(ctx, data);
    }

    public void readData(ChannelHandlerContext ctx, ByteBuf data) {
        super.readData(ctx, data);
    }

    public PacketWireless(int packetId) {
        super(packetId);
        this.setChannel("WR");
    }

    public PacketWireless(int packetId, PacketPayload payload) {
        super(packetId, payload);
        this.setChannel("WR");
    }

    public String toString() {
        return this.getCommand() + "(" + this.xPosition + "," + this.yPosition + "," + this.zPosition + ")[" + this.getFreq() + "]";
    }

    public String getFreq() {
        return this.payload.getStringPayload(0);
    }

    public void setFreq(Object freq) {
        this.payload.setStringPayload(0, freq.toString());
    }

    public boolean getState() {
        return this.payload.getBoolPayload(0);
    }

    public void setState(boolean state) {
        this.payload.setBoolPayload(0, state);
    }

    public TileEntity getTarget(World world) {
        boolean skipDefault = false;
        for (IPacketWirelessOverride override : overrides) {
            if (!override.shouldSkipDefault()) continue;
            skipDefault = true;
            break;
        }
        TileEntity tileentity = null;
        if (!skipDefault && this.targetExists(world)) {
            tileentity = world.getTileEntity(this.xPosition, this.yPosition, this.zPosition);
        }
        for (IPacketWirelessOverride override : overrides) {
            tileentity = override.getTarget(world, this.xPosition, this.yPosition, this.zPosition, tileentity);
        }
        return tileentity;
    }
}

