/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.network.packets;

import net.minecraft.world.World;
import net.slimevoid.library.network.PacketPayload;
import net.slimevoid.wirelessredstone.api.IWirelessData;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.network.packets.PacketWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;

public class PacketWirelessTile
extends PacketWireless
implements IWirelessData {
    public PacketWirelessTile() {
        super(1);
    }

    public PacketWirelessTile(String command, TileEntityRedstoneWireless entity) {
        super(1, new PacketPayload(0, 0, 1, 13));
        this.setPosition(entity.getBlockCoord(0), entity.getBlockCoord(1), entity.getBlockCoord(2), 0);
        LoggerRedstoneWireless.getInstance("PacketWirelessTile").write(entity.getWorldObj().isRemote, this.getCommand() + " - (" + this.xPosition + "," + this.yPosition + "," + this.zPosition + ")", LoggerRedstoneWireless.LogLevel.INFO);
        this.setCommand(command);
        this.setFreq(entity.getFreq());
        this.setState(RedstoneEther.getInstance().getFreqState(entity.getWorldObj(), entity.getFreq()));
        this.setPowerDirections(entity.getPowerDirections());
        this.setInDirectlyPowering(entity.getInDirectlyPowering());
    }

    @Override
    public String toString() {
        return this.getCommand() + "(" + this.xPosition + "," + this.yPosition + "," + this.zPosition + ")[" + this.getFreq() + "]";
    }

    public boolean[] getPowerDirections() {
        int j = this.payload.getBoolSize() - 12;
        boolean[] dir = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            dir[i] = this.payload.getBoolPayload(j);
            ++j;
        }
        return dir;
    }

    public void setPowerDirections(boolean[] dir) {
        int j = this.payload.getBoolSize() - 12;
        for (int i = 0; i < 6; ++i) {
            this.payload.setBoolPayload(j, dir[i]);
            ++j;
        }
    }

    public boolean[] getInDirectlyPowering() {
        int j = this.payload.getBoolSize() - 6;
        boolean[] indir = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            indir[i] = this.payload.getBoolPayload(j);
            ++j;
        }
        return indir;
    }

    public void setInDirectlyPowering(boolean[] indir) {
        int j = this.payload.getBoolSize() - 6;
        for (int i = 0; i < 6; ++i) {
            this.payload.setBoolPayload(j, indir[i]);
            ++j;
        }
    }

    public boolean targetExists(World world) {
        return world.getTileEntity(this.xPosition, this.yPosition, this.zPosition) != null;
    }
}

