/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.slimevoid.wirelessredstone.api.IRedstoneWirelessData;
import net.slimevoid.wirelessredstone.api.ITileEntityRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.api.IWirelessData;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;

public abstract class TileEntityRedstoneWireless
extends TileEntity
implements IInventory {
    protected BlockRedstoneWireless blockRedstoneWireless;
    private boolean state = false;
    public boolean firstTick = false;
    public Object oldFreq = "";
    public Object currentFreq = "0";
    protected boolean[] powerRoute;
    protected boolean[] indirPower;
    public HashMap<String, IRedstoneWirelessData> tileData = new HashMap();
    protected static List<ITileEntityRedstoneWirelessOverride> overrides = new ArrayList<ITileEntityRedstoneWirelessOverride>();

    public TileEntityRedstoneWireless(BlockRedstoneWireless block) {
        this.blockRedstoneWireless = block;
        this.flushPowerRoute();
        this.flushIndirPower();
    }

    public static void addOverride(ITileEntityRedstoneWirelessOverride override) {
        overrides.add(override);
    }

    public int getSizeInventory() {
        return 0;
    }

    public ItemStack getStackInSlot(int i) {
        return this.getRedstoneWirelessStackInSlot(i);
    }

    protected ItemStack getRedstoneWirelessStackInSlot(int i) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.getStackInSlot(this, i, itemstack);
        }
        return itemstack;
    }

    public Object getFreq() {
        return this.currentFreq;
    }

    public void setFreq(Object freq) {
        try {
            this.currentFreq = freq;
            this.updateEntity();
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("WirelessRedstone: " + ((Object)((Object)this)).getClass().toString()).writeStackTrace(e);
        }
    }

    public int getBlockCoord(int i) {
        switch (i) {
            case 0: {
                return this.xCoord;
            }
            case 1: {
                return this.yCoord;
            }
            case 2: {
                return this.zCoord;
            }
        }
        return 0;
    }

    public void updateEntity() {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeUpdateEntity(this)) continue;
            prematureExit = true;
        }
        if (!prematureExit) {
            String freq = this.getFreq().toString();
            if (!this.oldFreq.equals(freq) || this.firstTick) {
                this.blockRedstoneWireless.changeFreq(this.worldObj, this.getBlockCoord(0), this.getBlockCoord(1), this.getBlockCoord(2), this.oldFreq, freq);
                this.oldFreq = freq;
                if (this.firstTick) {
                    this.firstTick = false;
                }
            }
            this.onUpdateEntity();
        }
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            override.afterUpdateEntity(this);
        }
    }

    protected abstract void onUpdateEntity();

    public ItemStack decrStackSize(int i, int j) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.decrStackSize(this, i, j, itemstack);
        }
        return itemstack;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.setRedstoneWirelessSlotContents(i, itemstack);
    }

    protected void setRedstoneWirelessSlotContents(int slot, ItemStack itemstack) {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory() || !override.setInventorySlotContents(this, slot, itemstack)) continue;
            prematureExit = true;
        }
    }

    public abstract String getInventoryName();

    public boolean isPoweringDirection(int l) {
        if (l < 6) {
            return this.powerRoute[l];
        }
        return false;
    }

    public void flipPowerDirection(int l) {
        if (this.isPoweringIndirectly(l) && this.powerRoute[l]) {
            this.flipIndirectPower(l);
        }
        this.powerRoute[l] = !this.powerRoute[l];
        this.markDirty();
        this.notifyNeighbors();
    }

    public void flushPowerRoute() {
        this.powerRoute = new boolean[6];
        for (int i = 0; i < this.powerRoute.length; ++i) {
            this.powerRoute[i] = true;
        }
    }

    public boolean[] getPowerDirections() {
        return this.powerRoute;
    }

    public boolean[] getInDirectlyPowering() {
        return this.indirPower;
    }

    public void setPowerDirections(boolean[] dir) {
        try {
            this.powerRoute = dir;
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void setInDirectlyPowering(boolean[] indir) {
        try {
            this.indirPower = indir;
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void flipIndirectPower(int l) {
        if (!this.isPoweringDirection(l) && !this.indirPower[l]) {
            this.flipPowerDirection(l);
        }
        this.indirPower[l] = !this.indirPower[l];
        this.markDirty();
        this.notifyNeighbors();
    }

    public boolean isPoweringIndirectly(int l) {
        if (l < 6) {
            return this.indirPower[l];
        }
        return false;
    }

    public void flushIndirPower() {
        this.indirPower = new boolean[6];
        for (int i = 0; i < this.indirPower.length; ++i) {
            this.indirPower[i] = true;
        }
    }

    private void notifyNeighbors() {
        int i = this.getBlockCoord(0);
        int j = this.getBlockCoord(1);
        int k = this.getBlockCoord(2);
        BlockRedstoneWireless.notifyNeighbors(this.worldObj, i, j, k, this.getBlockType());
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        try {
            super.readFromNBT(nbttagcompound);
            NBTTagList nbttaglist3 = nbttagcompound.getTagList("Frequency", 10);
            NBTTagCompound nbttagcompound3 = nbttaglist3.getCompoundTagAt(0);
            this.currentFreq = nbttagcompound3.getString("freq");
            NBTTagList nbttaglist1 = nbttagcompound.getTagList("PowerRoute", 10);
            if (nbttaglist1.tagCount() == 6) {
                for (int i = 0; i < nbttaglist1.tagCount(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist1.getCompoundTagAt(i);
                    this.powerRoute[i] = nbttagcompound1.getBoolean("b");
                }
            } else {
                this.flushPowerRoute();
                this.writeToNBT(nbttagcompound);
            }
            NBTTagList nbttaglist4 = nbttagcompound.getTagList("IndirPower", 10);
            if (nbttaglist4.tagCount() == 6) {
                for (int i = 0; i < nbttaglist4.tagCount(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist4.getCompoundTagAt(i);
                    this.indirPower[i] = nbttagcompound1.getBoolean("b");
                }
            } else {
                this.flushIndirPower();
                this.writeToNBT(nbttagcompound);
            }
            this.state = nbttagcompound.getBoolean("State");
            for (ITileEntityRedstoneWirelessOverride override : overrides) {
                if (!override.handlesExtraNBTTags()) continue;
                override.readFromNBT(this, nbttagcompound);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        try {
            super.writeToNBT(nbttagcompound);
            NBTTagList nbttaglist3 = new NBTTagList();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setString("freq", this.currentFreq.toString());
            nbttaglist3.appendTag((NBTBase)nbttagcompound1);
            nbttagcompound.setTag("Frequency", (NBTBase)nbttaglist3);
            NBTTagList nbttaglist2 = new NBTTagList();
            for (int i = 0; i < this.powerRoute.length; ++i) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setBoolean("b", this.powerRoute[i]);
                nbttaglist2.appendTag((NBTBase)nbttagcompound2);
            }
            nbttagcompound.setTag("PowerRoute", (NBTBase)nbttaglist2);
            NBTTagList nbttaglist4 = new NBTTagList();
            for (int i = 0; i < this.indirPower.length; ++i) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setBoolean("b", this.indirPower[i]);
                nbttaglist4.appendTag((NBTBase)nbttagcompound2);
            }
            nbttagcompound.setTag("IndirPower", (NBTBase)nbttaglist4);
            nbttagcompound.setBoolean("State", this.state);
            for (ITileEntityRedstoneWirelessOverride override : overrides) {
                if (!override.handlesExtraNBTTags()) continue;
                override.writeToNBT(this, nbttagcompound);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(this.worldObj.isRemote, "isUseableByPlayer(" + entityplayer.getDisplayName() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeIsUseableByPlayer(this, entityplayer)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit) {
            try {
                returnState = this.isTileRedstoneWirelessUseable(entityplayer);
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
                return false;
            }
        }
        boolean output = returnState;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            output = override.afterIsUseableByPlayer(this, entityplayer, output);
        }
        return output;
    }

    private boolean isTileRedstoneWirelessUseable(EntityPlayer entityplayer) {
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.getStackInSlotOnClosing(this, i, itemstack);
        }
        return itemstack;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
        this.markDirty();
        this.getWorldObj().markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, nbttagcompound);
        return packet;
    }

    public void handleData(IWirelessData data) {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeHandleData(this, data)) continue;
            prematureExit = true;
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    protected boolean isRedstoneWirelessStackValidForSlot(int slot, ItemStack itemstack) {
        boolean result = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            result = override.isStackValidForSlot(this, slot, itemstack, result);
        }
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return this.isRedstoneWirelessStackValidForSlot(slot, itemstack);
    }

    public void onBlockRemoval(Block block, int metadata) {
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            override.onBlockRemoval(this, block, metadata);
        }
    }

    public void setAdditionalData(String dataID, IRedstoneWirelessData data) {
        this.tileData.put(dataID, data);
    }

    public IRedstoneWirelessData getAdditionalData(String dataID) {
        if (this.tileData.containsKey(dataID)) {
            return this.tileData.get(dataID);
        }
        return null;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean getState() {
        return this.state;
    }
}

