/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.blocks;

import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class BlockTransientLight
extends Block {
    public BlockTransientLight() {
        super(Material.air);
    }

    public boolean isAirBlock(World world, int x, int y, int z) {
        return true;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public boolean isCollidable() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (!world.isRemote) {
            world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
        }
    }

    public void onBlockPreDestroy(World par1World, int par2, int par3, int par4, int par5) {
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (!world.isRemote) {
            if (!this.handleLightingConditions(world, x, y, z, random)) {
                world.setBlockToAir(x, y, z);
            }
            world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
        }
    }

    protected abstract boolean handleLightingConditions(World var1, int var2, int var3, int var4, Random var5);

    public int getRenderType() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    public static void setBlock(Block block, int x, int y, int z, World world) {
        if (!(world.isRemote || world.getBlock(x, y, z) != Blocks.air && world.getBlock(x, y, z) != block)) {
            world.setBlock(x, y, z, block, 0, 2);
        }
    }
}

