/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.data;

import net.minecraft.world.World;
import net.slimevoid.library.data.Logger;
import net.slimevoid.library.data.LoggerSlimevoidLib;

public class ReadWriteLock {
    private int readers = 0;
    private int writers = 0;
    private int writeReq = 0;

    public synchronized void readLock(World world) throws InterruptedException {
        while (this.writers > 0 || this.writeReq > 0) {
            LoggerSlimevoidLib.getInstance("ReadWriteLock").write(world.isRemote, "readLock() - waiting", Logger.LogLevel.INFO);
            this.wait();
        }
        ++this.readers;
    }

    public synchronized void readUnlock() {
        --this.readers;
        this.notifyAll();
    }

    public synchronized void writeLock(World world) throws InterruptedException {
        ++this.writeReq;
        while (this.readers > 0 || this.writers > 0) {
            LoggerSlimevoidLib.getInstance("ReadWriteLock").write(world.isRemote, "writeLock() - waiting", Logger.LogLevel.INFO);
            this.wait();
        }
        ++this.writers;
        --this.writeReq;
    }

    public synchronized void writeUnlock() {
        --this.writers;
        this.notifyAll();
    }
}

