/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.slimevoid.library.inventory.ContainerBase;

public class InventorySubUpdate
implements IInventory {
    int size;
    int start;
    IInventory parent;
    ContainerBase container;

    public InventorySubUpdate(ContainerBase container, IInventory parentInventory, int startSlot, int inventorySize) {
        this.parent = parentInventory;
        this.start = startSlot;
        this.size = inventorySize;
        this.container = container;
    }

    public int getSizeInventory() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.parent.getStackInSlot(slot + this.start);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack itemstack = this.parent.decrStackSize(slot + this.start, amount);
        if (itemstack != null) {
            // empty if block
        }
        return itemstack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.parent.getStackInSlotOnClosing(slot + this.start);
    }

    public void setInventorySlotContents(int slot, ItemStack ist) {
        this.parent.setInventorySlotContents(slot + this.start, ist);
    }

    public String getInventoryName() {
        return this.parent.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.parent.getInventoryStackLimit();
    }

    public void markDirty() {
        this.parent.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }
}

