/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.nbt;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static void writeItemStack(ByteBuf data, ItemStack itemstack) {
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)itemstack);
    }

    public static ItemStack readItemStack(ByteBuf data) {
        return ByteBufUtils.readItemStack((ByteBuf)data);
    }

    public static void writeString(String stringToWrite, DataOutputStream data) throws IOException {
        if (stringToWrite.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        data.writeShort(stringToWrite.length());
        data.writeChars(stringToWrite);
    }

    public static String readString(DataInputStream data, int allowedLength) throws IOException {
        int stringLength = data.readShort();
        if (stringLength > allowedLength) {
            throw new IOException("Received string length longer than maximum allowed (" + stringLength + " > " + allowedLength + ")");
        }
        if (stringLength < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            stringBuilder.append(data.readChar());
        }
        return stringBuilder.toString();
    }

    public static void writeNBTTagCompound(NBTTagCompound nbttagcompound, ByteBuf data) {
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)nbttagcompound);
    }

    public static NBTTagCompound readNBTTagCompound(ByteBuf data) {
        return ByteBufUtils.readTag((ByteBuf)data);
    }

    public static int getTagInteger(ItemStack itemstack, String key, int defaultValue) {
        NBTTagCompound tag = itemstack.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (tag.hasKey(key)) {
            return tag.getInteger(key);
        }
        tag.setInteger(key, defaultValue);
        itemstack.setTagCompound(tag);
        return tag.getInteger(key);
    }
}

