/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.slimevoid.library.network.PacketUpdate;

public abstract class PacketEntity
extends PacketUpdate {
    private int entityId;

    public PacketEntity() {
        super(4);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public void writeData(ChannelHandlerContext ctx, ByteBuf data) {
        super.writeData(ctx, data);
        data.writeInt(this.entityId);
    }

    @Override
    public void readData(ChannelHandlerContext ctx, ByteBuf data) {
        super.readData(ctx, data);
        this.entityId = data.readInt();
    }

    @Override
    public boolean targetExists(World world) {
        List entities = world.loadedEntityList;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = (Entity)entities.get(i);
            if (entity == null || entity.getEntityId() != this.getEntityId()) continue;
            return true;
        }
        return false;
    }
}

