/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.network;

import java.util.Arrays;
import net.slimevoid.library.network.IndexInPayload;

public class PacketPayload {
    private int[] intPayload;
    private float[] floatPayload;
    private String[] stringPayload;
    private double[] doublePayload;
    private boolean[] boolPayload;

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static double[] concat(double[] first, double[] second) {
        double[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean[] concat(boolean[] first, boolean[] second) {
        boolean[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public PacketPayload() {
    }

    public int getIntSize() {
        if (this.intPayload != null) {
            return this.intPayload.length;
        }
        return 0;
    }

    public int getFloatSize() {
        if (this.floatPayload != null) {
            return this.floatPayload.length;
        }
        return 0;
    }

    public int getDoubleSize() {
        if (this.doublePayload != null) {
            return this.doublePayload.length;
        }
        return 0;
    }

    public int getStringSize() {
        if (this.stringPayload != null) {
            return this.stringPayload.length;
        }
        return 0;
    }

    public int getBoolSize() {
        if (this.boolPayload != null) {
            return this.boolPayload.length;
        }
        return 0;
    }

    public boolean setIntPayload(int index, int newInt) {
        if (this.intPayload != null && index < this.getIntSize()) {
            this.intPayload[index] = newInt;
            return true;
        }
        return false;
    }

    public boolean setFloatPayload(int index, float newFloat) {
        if (this.floatPayload != null && index < this.getFloatSize()) {
            this.floatPayload[index] = newFloat;
            return true;
        }
        return false;
    }

    public boolean setDoublePayload(int index, double newDouble) {
        if (this.doublePayload != null && index < this.getDoubleSize()) {
            this.doublePayload[index] = newDouble;
            return true;
        }
        return false;
    }

    public boolean setStringPayload(int index, String newString) {
        if (this.stringPayload != null && index < this.getStringSize()) {
            this.stringPayload[index] = newString;
            return true;
        }
        return false;
    }

    public boolean setBoolPayload(int index, boolean newBool) {
        if (this.boolPayload != null && index < this.getBoolSize()) {
            this.boolPayload[index] = newBool;
            return true;
        }
        return false;
    }

    public int getIntPayload(int index) {
        if (this.intPayload != null && index < this.getIntSize()) {
            return this.intPayload[index];
        }
        return 0;
    }

    public float getFloatPayload(int index) {
        if (this.floatPayload != null && index < this.getFloatSize()) {
            return this.floatPayload[index];
        }
        return 0.0f;
    }

    public double getDoublePayload(int index) {
        if (this.doublePayload != null && index < this.getDoubleSize()) {
            return this.doublePayload[index];
        }
        return 0.0;
    }

    public String getStringPayload(int index) {
        if (this.stringPayload != null && index < this.getStringSize() && this.stringPayload[index] != null) {
            return this.stringPayload[index];
        }
        return "null";
    }

    public boolean getBoolPayload(int index) {
        if (this.boolPayload != null && index < this.getBoolSize()) {
            return this.boolPayload[index];
        }
        return false;
    }

    public PacketPayload(int intSize, int floatSize, int stringSize, int boolSize) {
        this.intPayload = new int[intSize];
        this.floatPayload = new float[floatSize];
        this.stringPayload = new String[stringSize];
        this.boolPayload = new boolean[boolSize];
    }

    public PacketPayload(int intSize, int floatSize, int stringSize, int boolSize, int doubleSize) {
        this(intSize, floatSize, stringSize, boolSize);
        this.doublePayload = new double[doubleSize];
    }

    public void append(PacketPayload other) {
        if (other == null) {
            return;
        }
        if (other.intPayload.length > 0) {
            this.intPayload = PacketPayload.concat(this.intPayload, other.intPayload);
        }
        if (other.floatPayload.length > 0) {
            this.floatPayload = PacketPayload.concat(this.floatPayload, other.floatPayload);
        }
        if (other.doublePayload.length > 0) {
            this.doublePayload = PacketPayload.concat(this.doublePayload, other.doublePayload);
        }
        if (other.stringPayload.length > 0) {
            this.stringPayload = PacketPayload.concat(this.stringPayload, other.stringPayload);
        }
        if (other.boolPayload.length > 0) {
            this.boolPayload = PacketPayload.concat(this.boolPayload, other.boolPayload);
        }
    }

    public void append(int[] other) {
        if (other == null || other.length < 0) {
            return;
        }
        this.intPayload = PacketPayload.concat(this.intPayload, other);
    }

    public void splitTail(IndexInPayload index) {
        PacketPayload payload = new PacketPayload(this.intPayload.length - index.intIndex, this.floatPayload.length - index.floatIndex, this.stringPayload.length - index.stringIndex, this.boolPayload.length - index.boolIndex);
        if (this.intPayload.length > 0) {
            System.arraycopy(this.intPayload, index.intIndex, payload.intPayload, 0, payload.intPayload.length);
        }
        if (this.floatPayload.length > 0) {
            System.arraycopy(this.floatPayload, index.floatIndex, payload.floatPayload, 0, payload.floatPayload.length);
        }
        if (this.doublePayload.length > 0) {
            System.arraycopy(this.doublePayload, index.doubleIndex, payload.doublePayload, 0, payload.doublePayload.length);
        }
        if (this.stringPayload.length > 0) {
            System.arraycopy(this.stringPayload, index.stringIndex, payload.stringPayload, 0, payload.stringPayload.length);
        }
        if (this.boolPayload.length > 0) {
            System.arraycopy(this.boolPayload, index.boolIndex, payload.boolPayload, 0, payload.boolPayload.length);
        }
    }

    public void addIntValue(int newValue) {
        int[] newInt = new int[]{newValue};
        this.append(newInt);
    }
}

