/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.network.handlers;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.slimevoid.library.IPacketExecutor;
import net.slimevoid.library.data.Logger;
import net.slimevoid.library.data.LoggerSlimevoidLib;
import net.slimevoid.library.network.PacketUpdate;

public abstract class SubPacketHandler {
    private EnumMap<Side, Map<String, IPacketExecutor>> executors = Maps.newEnumMap(Side.class);

    public SubPacketHandler() {
        this.executors.put(Side.CLIENT, Maps.newConcurrentMap());
        this.executors.put(Side.SERVER, Maps.newConcurrentMap());
    }

    public void registerClientExecutor(String commandString, IPacketExecutor executor) {
        if (this.executors.get(Side.CLIENT).containsKey(commandString)) {
            LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.toString())).write(false, "Command String [" + commandString + "] already registered.", Logger.LogLevel.ERROR);
            throw new RuntimeException("Command String [" + commandString + "] already registered.");
        }
        this.executors.get(Side.CLIENT).put(commandString, executor);
    }

    public void registerServerExecutor(String commandString, IPacketExecutor executor) {
        if (this.executors.get(Side.SERVER).containsKey(commandString)) {
            LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.toString())).write(false, "Command String [" + commandString + "] already registered.", Logger.LogLevel.ERROR);
            throw new RuntimeException("Command String [" + commandString + "] already registered.");
        }
        this.executors.get(Side.SERVER).put(commandString, executor);
    }

    protected abstract PacketUpdate createNewPacket();

    protected void handleClientPacket(PacketUpdate packet, World world, EntityPlayer entityplayer) {
        LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.getClass().toString())).write(world.isRemote, "handlePacket(" + packet.toString() + ", world," + entityplayer.getGameProfile().getName() + ")", Logger.LogLevel.DEBUG);
        String command = packet.getCommand();
        if (!this.executors.get(Side.CLIENT).containsKey(command)) {
            LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.getClass().toString())).write(world.isRemote, "handlePacket(" + packet.toString() + ", world," + entityplayer.getGameProfile().getName() + ") - UNKNOWN COMMAND", Logger.LogLevel.WARNING);
            throw new RuntimeException("Tried to get a Packet Executor for command: " + command + " that has not been registered.");
        }
        this.executors.get(Side.CLIENT).get(command).execute(packet, world, entityplayer);
    }

    protected void handleServerPacket(PacketUpdate packet, World world, EntityPlayer entityplayer) {
        LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.getClass().toString())).write(world.isRemote, "handlePacket(" + packet.toString() + ", world," + entityplayer.getGameProfile().getName() + ")", Logger.LogLevel.DEBUG);
        String command = packet.getCommand();
        if (!this.executors.get(Side.SERVER).containsKey(command)) {
            LoggerSlimevoidLib.getInstance(Logger.filterClassName(this.getClass().toString())).write(world.isRemote, "handlePacket(" + packet.toString() + ", world," + entityplayer.getGameProfile().getName() + ") - UNKNOWN COMMAND", Logger.LogLevel.WARNING);
            throw new RuntimeException("Tried to get a Packet Executor for command: " + command + " that has not been registered.");
        }
        this.executors.get(Side.SERVER).get(command).execute(packet, world, entityplayer);
    }

    public void onPacketData(ChannelHandlerContext ctx, ByteBuf data, List<Object> out) {
        EntityPlayer entityplayer = null;
        PacketUpdate packet = this.createNewPacket();
        packet.readData(ctx, data);
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                entityplayer = this.getClientPlayer();
                this.handleClientPacket(packet, entityplayer.worldObj, entityplayer);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                entityplayer = ((NetHandlerPlayServer)netHandler).playerEntity;
                this.handleServerPacket(packet, entityplayer.worldObj, entityplayer);
                break;
            }
        }
        out.add(packet);
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }
}

