/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.slimevoid.library.core.SlimevoidCore;

public class FileUtils {
    public static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        SlimevoidCore.console("SlimevoidLib", "Attempting resource load from [" + path + "] using Class Parent [" + clazz.getSimpleName() + "]");
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            SlimevoidCore.console("SlimevoidLib", "Found resource in file path!");
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL != null) {
            if (dirURL.getProtocol().equals("jar") || dirURL.getProtocol().equals("zip")) {
                String filePath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                Enumeration<JarEntry> entries = null;
                SlimevoidCore.console("SlimevoidLib", "Jar protocol loaded!");
                JarFile jar = new JarFile(URLDecoder.decode(filePath, "UTF-8"));
                entries = jar.entries();
                SlimevoidCore.console("SlimevoidLib", "JarFile initialized with the following [Path: " + filePath + ", Name: " + jar.getName() + ", Number of entries: " + entries);
                HashSet<String> result = new HashSet<String>();
                if (entries != null) {
                    while (entries.hasMoreElements()) {
                        String name = ((ZipEntry)entries.nextElement()).getName();
                        if (!name.startsWith(path)) continue;
                        String entry = name.substring(path.length());
                        int checkSubdir = entry.indexOf("/");
                        if (checkSubdir >= 0) {
                            entry = entry.substring(0, checkSubdir);
                        }
                        if (entry == "") continue;
                        result.add(entry);
                    }
                    if (result.size() > 0) {
                        SlimevoidCore.console("SlimevoidLib", "Resource folder loaded [" + path + "], Number of resource files [" + result.size() + "]");
                        return result.toArray(new String[result.size()]);
                    }
                }
            } else {
                SlimevoidCore.console("SlimevoidLib", "Caution: Failed to read URL [" + dirURL.getPath() + "], unknown protocol [" + dirURL.getProtocol() + " | Pathed to [" + path + "]", 1);
            }
        } else {
            SlimevoidCore.console("SlimevoidLib", "Caution: Resource folder entries [" + path + "] could not be located!", 1);
        }
        UnsupportedOperationException uOE = new UnsupportedOperationException("Cannot list files for URL " + dirURL);
        SlimevoidCore.console("SlimevoidLib", uOE.getLocalizedMessage(), 1);
        throw uOE;
    }

    public static boolean copyFile(File toCopy, File destFile) {
        try {
            return FileUtils.copyStream((InputStream)new FileInputStream(toCopy), new FileOutputStream(destFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyFilesRecusively(File toCopy, File destDir) {
        assert (destDir.isDirectory());
        if (!toCopy.isDirectory()) {
            return FileUtils.copyFile(toCopy, new File(destDir, toCopy.getName()));
        }
        File newDestDir = new File(destDir, toCopy.getName());
        if (!newDestDir.exists() && !newDestDir.mkdir()) {
            return false;
        }
        for (File child : toCopy.listFiles()) {
            if (FileUtils.copyFilesRecusively(child, newDestDir)) continue;
            return false;
        }
        return true;
    }

    public static String removeStart(String str, String remove) {
        if (FileUtils.isEmpty(str) || FileUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean copyJarResourcesRecursively(File destDir, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String filename = FileUtils.removeStart(entry.getName(), jarConnection.getEntryName());
            File f = new File(destDir, filename);
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                if (!FileUtils.copyStream(entryInputStream, f)) {
                    return false;
                }
                entryInputStream.close();
                continue;
            }
            if (FileUtils.ensureDirectoryExists(f)) continue;
            throw new IOException("Could not create directory: " + f.getAbsolutePath());
        }
        return true;
    }

    public static boolean copyResourcesRecursively(URL originUrl, File destination) {
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                return FileUtils.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
            }
            return FileUtils.copyFilesRecusively(new File(originUrl.getPath()), destination);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyStream(InputStream is, File f) {
        try {
            return FileUtils.copyStream(is, new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyStream(InputStream is, OutputStream os) {
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean ensureDirectoryExists(File f) {
        return f.exists() || f.mkdir();
    }
}

