/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.library.util.helpers.SlimevoidHelper;

public class BlockHelper {
    public static void notifyBlock(World world, int x, int y, int z, Block source) {
        Block block = world.getBlock(x, y, z);
        if (block != null) {
            block.onNeighborBlockChange(world, x, y, z, source);
        }
    }

    public static void updateIndirectNeighbors(World world, int x, int y, int z, Block block) {
        if (world.isRemote || FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return;
        }
        for (int inDirX = -3; inDirX <= 3; ++inDirX) {
            for (int inDirY = -3; inDirY <= 3; ++inDirY) {
                for (int inDirZ = -3; inDirZ <= 3; ++inDirZ) {
                    int updateDirection = inDirX >= 0 ? inDirX : -inDirX;
                    updateDirection += inDirY >= 0 ? inDirY : -inDirY;
                    if ((updateDirection += inDirZ >= 0 ? inDirZ : -inDirZ) > 3) continue;
                    BlockHelper.notifyBlock(world, x + inDirX, y + inDirY, z + inDirZ, block);
                }
            }
        }
    }

    public static void markBlockDirty(World world, int x, int y, int z) {
        if (world.blockExists(x, y, z)) {
            world.getChunkFromBlockCoords(x, z).setChunkModified();
        }
    }

    public static Object getTileEntity(IBlockAccess world, int x, int y, int z, Class tileEntityClass) {
        if (tileEntityClass == null) {
            return null;
        }
        TileEntity tileentity = SlimevoidHelper.getBlockTileEntity(world, x, y, z);
        if (!tileEntityClass.isInstance(tileentity)) {
            return null;
        }
        return tileentity;
    }

    public static TileEntity getTileEntityAtBase(Entity entity) {
        int x = MathHelper.floor_double((double)entity.posX);
        int y = MathHelper.floor_double((double)(entity.posY - (double)0.2f - (double)entity.yOffset));
        int z = MathHelper.floor_double((double)entity.posZ);
        return SlimevoidHelper.getBlockTileEntity((IBlockAccess)entity.worldObj, x, y, z);
    }

    public static void playBlockPlaceNoise(World world, int x, int y, int z, Block block) {
        world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "step.stone", (block.stepSound.getPitch() + 1.0f) / 2.0f, block.stepSound.getVolume() * 0.8f);
    }
}

