/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.helpers;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemHelper {
    public static boolean isBlockStack(ItemStack itemstack) {
        return itemstack != null && itemstack.getItem() != null && itemstack.getItem() instanceof ItemBlock && !Block.getBlockFromItem((Item)itemstack.getItem()).hasTileEntity(itemstack.getItemDamage());
    }

    public static boolean isSolidBlockStack(ItemStack itemstack, World world, int x, int y, int z) {
        return ItemHelper.isBlockStack(itemstack) && Block.getBlockFromItem((Item)itemstack.getItem()).renderAsNormalBlock();
    }

    public static void dropItem(World world, int x, int y, int z, ItemStack itemstack) {
        if (world.isRemote) {
            return;
        }
        double d = 0.7;
        double xx = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
        double yy = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
        double zz = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
        EntityItem item = new EntityItem(world, (double)x + xx, (double)y + yy, (double)z + zz, itemstack);
        item.age = 10;
        world.spawnEntityInWorld((Entity)item);
    }

    public static String correctName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String itemstackArrayToIntegers(Object[] input) {
        String concat = "";
        for (int i = 0; i < input.length; ++i) {
            String itemstack = null;
            if (input[i] instanceof ItemStack) {
                itemstack = ItemHelper.itemstackToName((ItemStack)input[i]);
            }
            if (itemstack == null) continue;
            concat = concat + itemstack;
            concat = concat + (i < input.length - 1 ? " : " : "");
        }
        return concat;
    }

    public static String itemstackToName(ItemStack itemstack) {
        return itemstack != null ? itemstack.getDisplayName() + " | " + itemstack.stackSize : "null";
    }

    public static String itemstackArrayToStrings(Object[] input) {
        String concat = "";
        for (int i = 0; i < input.length; ++i) {
            concat = concat + (i > 0 ? " + " : "");
            if (!(input[i] instanceof ItemStack)) continue;
            concat = concat + ItemHelper.itemstackToString((ItemStack)input[i]);
        }
        return concat;
    }

    public static String itemstackToString(ItemStack itemstack) {
        return itemstack != null ? itemstack.getDisplayName() + " | " + itemstack.stackSize : "null";
    }
}

