/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.json;

import argo.saj.InvalidSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import net.slimevoid.library.core.SlimevoidCore;
import net.slimevoid.library.util.FileUtils;

public abstract class JSONLoader {
    private static HashMap<String, JSONLoader> jsonLoaders = new HashMap();
    protected Class _class;
    protected String location;
    protected String filename;

    public static JSONLoader getJSONLoader(String filename) {
        if (jsonLoaders.containsKey(filename)) {
            return jsonLoaders.get(filename);
        }
        return null;
    }

    public static void registerJSONLoader(JSONLoader loader) {
        if (!jsonLoaders.containsKey(loader.filename)) {
            jsonLoaders.put(loader.filename, loader);
        }
    }

    public static void loadJSON() {
        for (JSONLoader loader : jsonLoaders.values()) {
            loader.loadFile();
        }
    }

    public JSONLoader(Class clazz, String location, String filename) {
        this._class = clazz;
        this.location = location;
        this.filename = filename;
    }

    public void loadFile() {
        try {
            this.parseJSON(this.readFile());
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String readFile() throws IOException {
        InputStream in = this.getInputStream();
        if (in == null) {
            SlimevoidCore.console(this.getModID(), " Failed to get resource list from [" + this._class.getSimpleName() + "][" + this.location + this.filename + "]", 1);
            return "";
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(isr);
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    public InputStream getInputStream() {
        try {
            String[] resourceList = FileUtils.getResourceListing(this._class, this.location);
            if (resourceList.length > 0) {
                for (String file : resourceList) {
                    if (!file.equals(this.filename)) continue;
                    InputStream instr = this._class.getClassLoader().getResourceAsStream(this.location + this.filename);
                    SlimevoidCore.console("SlimevoidLib", "Resource loaded from [" + this._class.getSimpleName() + "][" + this.location + this.filename + "]");
                    return instr;
                }
            } else {
                SlimevoidCore.console("SlimevoidLib", "Caution: Failed to get resource list from [" + this._class.getSimpleName() + "][" + this.location + this.filename + "]", 1);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected abstract void parseJSON(String var1) throws InvalidSyntaxException;

    protected abstract String getModID();
}

