/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.BetterHorses.client;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thehippomaster.BetterHorses.Horse;
import thehippomaster.BetterHorses.client.HorseModel;

@SideOnly(value=Side.CLIENT)
public class HorseRenderer
extends RenderLiving {
    private RenderHorse vanillaHorseRenderer;
    private HorseModel horseModel;
    private static final Map textureMap = Maps.newHashMap();
    private static final ResourceLocation whiteHorseTexture = new ResourceLocation("textures/entity/horse/horse_white.png");
    private static final ResourceLocation muleTexture = new ResourceLocation("textures/entity/horse/mule.png");
    private static final ResourceLocation donkeyTexture = new ResourceLocation("textures/entity/horse/donkey.png");
    private static final ResourceLocation zombieHorseTexture = new ResourceLocation("textures/entity/horse/horse_zombie.png");
    private static final ResourceLocation skeletonHorseTexture = new ResourceLocation("textures/entity/horse/horse_skeleton.png");

    public HorseRenderer(ModelBase base, float f) {
        super(base, f);
        this.vanillaHorseRenderer = new RenderHorse((ModelBase)new ModelHorse(), f);
        this.horseModel = (HorseModel)base;
    }

    public void func_76986_a(EntityLiving living, double d, double d1, double d2, float f, float f1) {
        Horse horse = (Horse)living;
        this.vanillaHorseRenderer.func_76976_a(this.field_76990_c);
        if (horse.func_110228_bR()) {
            super.func_76986_a(living, d, d1, d2, f, f1);
        } else {
            this.vanillaHorseRenderer.func_76986_a(living, d, d1, d2, f, f1);
        }
    }

    protected void func_77036_a(EntityLivingBase living, float f, float f1, float f2, float f3, float f4, float f5) {
        Horse horse = (Horse)living;
        if (horse.func_82150_aj()) {
            this.horseModel.animate(horse, f, f1, f2, f3, f4, f5);
        } else {
            this.func_110777_b((Entity)horse);
            this.horseModel.func_78088_a((Entity)horse, f, f1, f2, f3, f4, f5);
        }
    }

    protected void func_77041_b(EntityLivingBase living, float partialTick) {
        EntityHorse horse = (EntityHorse)living;
        float scale = 1.0f;
        int i = horse.func_110265_bP();
        if (i == 1) {
            scale *= 0.87f;
        } else if (i == 2) {
            scale *= 0.92f;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        super.func_77041_b((EntityLivingBase)horse, partialTick);
    }

    protected void func_77043_a(EntityLivingBase living, float par2, float par3, float partialTick) {
        super.func_77043_a(living, par2, par3, partialTick);
        Horse horse = (Horse)living;
        float pitch = horse.prevRenderPitch + (horse.renderPitch - horse.prevRenderPitch) * partialTick;
        if (horse.field_70725_aQ <= 0) {
            GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        EntityHorse horse = (EntityHorse)entity;
        if (!horse.func_110239_cn()) {
            if (horse.func_110265_bP() == 1) {
                return donkeyTexture;
            }
            if (horse.func_110265_bP() == 2) {
                return muleTexture;
            }
            if (horse.func_110265_bP() == 3) {
                return zombieHorseTexture;
            }
            if (horse.func_110265_bP() == 4) {
                return skeletonHorseTexture;
            }
            return whiteHorseTexture;
        }
        return this.getLayeredHorseTexture(horse);
    }

    private ResourceLocation getLayeredHorseTexture(EntityHorse horse) {
        String s = horse.func_110264_co();
        ResourceLocation texture = (ResourceLocation)textureMap.get(s);
        if (texture == null) {
            texture = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(texture, (ITextureObject)new LayeredTexture(horse.func_110212_cp()));
            textureMap.put(s, texture);
        }
        return texture;
    }
}

